/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.sun.istack.NotNull;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.util.SizedUtil;

public class PTableStatsImpl
implements PTableStats {
    private final SortedMap<byte[], GuidePostsInfo> guidePosts;
    private final int estimatedSize;
    private final long timeStamp;

    public PTableStatsImpl() {
        this(new TreeMap<byte[], GuidePostsInfo>(Bytes.BYTES_COMPARATOR), 0L);
    }

    public PTableStatsImpl(@NotNull SortedMap<byte[], GuidePostsInfo> guidePosts, long timeStamp) {
        this.guidePosts = guidePosts;
        this.timeStamp = timeStamp;
        int estimatedSize = 20 + SizedUtil.sizeOfTreeMap(guidePosts.size());
        for (Map.Entry<byte[], GuidePostsInfo> entry : guidePosts.entrySet()) {
            byte[] cf = entry.getKey();
            estimatedSize += 24 + cf.length;
            List<byte[]> keys = entry.getValue().getGuidePosts();
            estimatedSize += SizedUtil.sizeOfArrayList(keys.size());
            for (byte[] key : keys) {
                estimatedSize += 24 + key.length;
            }
            estimatedSize += 8;
        }
        this.estimatedSize = estimatedSize;
    }

    @Override
    public SortedMap<byte[], GuidePostsInfo> getGuidePosts() {
        return this.guidePosts;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PTableStats [");
        for (Map.Entry<byte[], GuidePostsInfo> entry : this.guidePosts.entrySet()) {
            buf.append(Bytes.toStringBinary(entry.getKey()));
            buf.append(":(");
            List<byte[]> keys = entry.getValue().getGuidePosts();
            if (!keys.isEmpty()) {
                for (byte[] key : keys) {
                    buf.append(Bytes.toStringBinary(key));
                    buf.append(",");
                }
                buf.setLength(buf.length() - 1);
            }
            buf.append(")");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public long getTimestamp() {
        return this.timeStamp;
    }
}

