/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.filter.CompareFilter;

public enum SortOrder {
    ASC(2){

        @Override
        public CompareFilter.CompareOp transform(CompareFilter.CompareOp op) {
            return op;
        }
    }
    ,
    DESC(1){

        @Override
        public CompareFilter.CompareOp transform(CompareFilter.CompareOp op) {
            switch (op) {
                case EQUAL: {
                    return op;
                }
                case NOT_EQUAL: {
                    return op;
                }
                case NO_OP: {
                    return op;
                }
                case GREATER: {
                    return CompareFilter.CompareOp.LESS;
                }
                case GREATER_OR_EQUAL: {
                    return CompareFilter.CompareOp.LESS_OR_EQUAL;
                }
                case LESS: {
                    return CompareFilter.CompareOp.GREATER;
                }
                case LESS_OR_EQUAL: {
                    return CompareFilter.CompareOp.GREATER_OR_EQUAL;
                }
            }
            throw new IllegalArgumentException("Add the missing case statement!");
        }
    };

    private final int serializationId;

    public static SortOrder getDefault() {
        return ASC;
    }

    public static byte[] invert(byte[] src, int srcOffset, byte[] dest, int dstOffset, int length) {
        Preconditions.checkNotNull(src);
        Preconditions.checkNotNull(dest);
        for (int i = 0; i < length; ++i) {
            dest[dstOffset + i] = (byte)(src[srcOffset + i] ^ 0xFF);
        }
        return dest;
    }

    public static byte[] invert(byte[] src, int srcOffset, int length) {
        return SortOrder.invert(src, srcOffset, new byte[length], 0, length);
    }

    public static byte invert(byte b) {
        return (byte)(b ^ 0xFF);
    }

    public static SortOrder fromDDLValue(String sortOrder) {
        Preconditions.checkArgument(sortOrder != null);
        if (sortOrder.equalsIgnoreCase("ASC")) {
            return ASC;
        }
        if (sortOrder.equalsIgnoreCase("DESC")) {
            return DESC;
        }
        throw new IllegalArgumentException("Unknown SortOrder: " + sortOrder);
    }

    public static SortOrder fromSystemValue(int value) {
        for (SortOrder mod : SortOrder.values()) {
            if (mod.getSystemValue() != value) continue;
            return mod;
        }
        return SortOrder.getDefault();
    }

    private SortOrder(int serializationId) {
        this.serializationId = serializationId;
    }

    public int getSystemValue() {
        return this.serializationId;
    }

    public abstract CompareFilter.CompareOp transform(CompareFilter.CompareOp var1);
}

