/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SequenceUtil;

public class Sequence {
    public static final int SUCCESS = 0;
    private static final KeyValue CURRENT_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES);
    private static final KeyValue INCREMENT_BY_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.INCREMENT_BY_BYTES);
    private static final KeyValue CACHE_SIZE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CACHE_SIZE_BYTES);
    private static final KeyValue MIN_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_VALUE_BYTES);
    private static final KeyValue MAX_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MAX_VALUE_BYTES);
    private static final KeyValue CYCLE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CYCLE_FLAG_BYTES);
    private static final KeyValue LIMIT_REACHED_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES);
    private static final List<KeyValue> SEQUENCE_KV_COLUMNS = Arrays.asList(CURRENT_VALUE_KV, INCREMENT_BY_KV, CACHE_SIZE_KV, MIN_VALUE_KV, MAX_VALUE_KV, CYCLE_KV, LIMIT_REACHED_KV);
    private static final int CURRENT_VALUE_INDEX;
    private static final int INCREMENT_BY_INDEX;
    private static final int CACHE_SIZE_INDEX;
    private static final int MIN_VALUE_INDEX;
    private static final int MAX_VALUE_INDEX;
    private static final int CYCLE_INDEX;
    private static final int LIMIT_REACHED_INDEX;
    public static final int NUM_SEQUENCE_KEY_VALUES;
    private static final EmptySequenceCacheException EMPTY_SEQUENCE_CACHE_EXCEPTION;
    private final SequenceKey key;
    private final ReentrantLock lock;
    private List<SequenceValue> values;

    public Sequence(SequenceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.lock = new ReentrantLock();
    }

    private void insertSequenceValue(SequenceValue value) {
        if (this.values == null) {
            this.values = Lists.newArrayListWithExpectedSize(1);
            this.values.add(value);
        } else {
            int i;
            for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp > value.timestamp; --i) {
            }
            if (i >= 0 && this.values.get((int)i).timestamp == value.timestamp) {
                if (this.values.get((int)i).isDeleted) {
                    throw new IllegalStateException("Unexpected delete marker at timestamp " + value.timestamp + " for " + this.key);
                }
                this.values.set(i, value);
            } else {
                this.values.add(i + 1, value);
            }
        }
    }

    private SequenceValue findSequenceValue(long timestamp) {
        int i;
        if (this.values == null) {
            return null;
        }
        for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp >= timestamp; --i) {
        }
        if (i < 0) {
            return null;
        }
        SequenceValue value = this.values.get(i);
        return value.isDeleted ? null : value;
    }

    private long increment(SequenceValue value, ValueOp op) throws SQLException {
        boolean increasingSeq;
        boolean bl = increasingSeq = value.incrementBy > 0L && op != ValueOp.VALIDATE_SEQUENCE;
        if (value.limitReached && op != ValueOp.VALIDATE_SEQUENCE) {
            if (value.cycle) {
                value.limitReached = false;
                throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
            }
            SQLExceptionCode code = increasingSeq ? SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE : SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE;
            throw SequenceUtil.getException(this.key.getSchemaName(), this.key.getSequenceName(), code);
        }
        long returnValue = value.currentValue;
        if (op == ValueOp.INCREMENT_SEQUENCE) {
            boolean overflowOrUnderflow = false;
            try {
                value.currentValue = LongMath.checkedAdd(value.currentValue, value.incrementBy);
            }
            catch (ArithmeticException e) {
                overflowOrUnderflow = true;
            }
            if (overflowOrUnderflow || increasingSeq && value.currentValue > value.maxValue || !increasingSeq && value.currentValue < value.minValue) {
                value.limitReached = true;
            }
        }
        return returnValue;
    }

    public long incrementValue(long timestamp, ValueOp op) throws SQLException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (value.currentValue == value.nextValue) {
            if (op == ValueOp.VALIDATE_SEQUENCE) {
                return value.currentValue;
            }
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return this.increment(value, op);
    }

    public List<Append> newReturns() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        ArrayList<Append> appends = Lists.newArrayListWithExpectedSize(this.values.size());
        for (SequenceValue value : this.values) {
            if (!value.isInitialized() || value.currentValue == value.nextValue) continue;
            appends.add(this.newReturn(value));
        }
        return appends;
    }

    public Append newReturn(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (value.currentValue == value.nextValue) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return this.newReturn(value);
    }

    private Append newReturn(SequenceValue value) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        byte[] opBuf = new byte[]{(byte)MetaOp.RETURN_SEQUENCE.ordinal()};
        append.setAttribute("SEQUENCE_OPERATION", opBuf);
        append.setAttribute("CURRENT_VALUE", PLong.INSTANCE.toBytes(value.nextValue));
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, value.timestamp, PLong.INSTANCE.toBytes(value.currentValue)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, value.timestamp, PBoolean.INSTANCE.toBytes(value.limitReached))));
        return append;
    }

    public long currentValue(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null || value.isUnitialized()) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return value.currentValue - value.incrementBy;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public SequenceKey getKey() {
        return this.key;
    }

    public long incrementValue(Result result, ValueOp op) throws SQLException {
        if (result.rawCells().length == 1) {
            Cell errorKV = result.rawCells()[0];
            int errorCode = PInteger.INSTANCE.getCodec().decodeInt(errorKV.getValueArray(), errorKV.getValueOffset(), SortOrder.getDefault());
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(errorCode);
            throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
        }
        SequenceValue value = new SequenceValue(result, op);
        this.insertSequenceValue(value);
        return this.increment(value, op);
    }

    public Increment newIncrement(long timestamp, ValueOp action) {
        Increment inc = new Increment(this.key.getKey());
        try {
            inc.setTimeRange(0L, timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (KeyValue kv : SEQUENCE_KV_COLUMNS) {
            inc.addColumn(kv.getFamily(), kv.getQualifier(), action.ordinal());
        }
        return inc;
    }

    private static KeyValue getKeyValue(Result r, KeyValue kv, int cellIndex) {
        Cell[] cells = r.rawCells();
        Cell cell = cells.length == NUM_SEQUENCE_KEY_VALUES ? cells[cellIndex] : r.getColumnLatestCell(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(cell);
    }

    private static KeyValue getKeyValue(Result r, KeyValue kv) {
        return Sequence.getKeyValue(r, kv, SEQUENCE_KV_COLUMNS.indexOf(kv));
    }

    public static KeyValue getCurrentValueKV(Result r) {
        return Sequence.getKeyValue(r, CURRENT_VALUE_KV, CURRENT_VALUE_INDEX);
    }

    public static KeyValue getIncrementByKV(Result r) {
        return Sequence.getKeyValue(r, INCREMENT_BY_KV, INCREMENT_BY_INDEX);
    }

    public static KeyValue getCacheSizeKV(Result r) {
        return Sequence.getKeyValue(r, CACHE_SIZE_KV, CACHE_SIZE_INDEX);
    }

    public static KeyValue getMinValueKV(Result r) {
        return Sequence.getKeyValue(r, MIN_VALUE_KV, MIN_VALUE_INDEX);
    }

    public static KeyValue getMaxValueKV(Result r) {
        return Sequence.getKeyValue(r, MAX_VALUE_KV, MAX_VALUE_INDEX);
    }

    public static KeyValue getCycleKV(Result r) {
        return Sequence.getKeyValue(r, CYCLE_KV, CYCLE_INDEX);
    }

    public static KeyValue getLimitReachedKV(Result r) {
        return Sequence.getKeyValue(r, LIMIT_REACHED_KV, LIMIT_REACHED_INDEX);
    }

    public static void replaceCurrentValueKV(List<Cell> kvs, KeyValue currentValueKV) {
        kvs.set(CURRENT_VALUE_INDEX, currentValueKV);
    }

    public static void replaceMinValueKV(List<Cell> kvs, KeyValue minValueKV) {
        kvs.set(MIN_VALUE_INDEX, minValueKV);
    }

    public static void replaceMaxValueKV(List<Cell> kvs, KeyValue maxValueKV) {
        kvs.set(MAX_VALUE_INDEX, maxValueKV);
    }

    public static void replaceCycleValueKV(List<Cell> kvs, KeyValue cycleValueKV) {
        kvs.set(CYCLE_INDEX, cycleValueKV);
    }

    public static void replaceLimitReachedKV(List<Cell> kvs, KeyValue limitReachedKV) {
        kvs.set(LIMIT_REACHED_INDEX, limitReachedKV);
    }

    public static List<Cell> getCells(Result r, int numKVs) {
        if (r.rawCells().length == numKVs) {
            return Lists.newArrayList(r.rawCells());
        }
        ArrayList<Cell> cellList = Lists.newArrayListWithCapacity(NUM_SEQUENCE_KEY_VALUES);
        for (KeyValue kv : SEQUENCE_KV_COLUMNS) {
            cellList.add(Sequence.getKeyValue(r, kv));
        }
        return cellList;
    }

    public boolean returnValue(Result result) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        if (statusKV.getValueLength() == 0) {
            return false;
        }
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = this.findSequenceValue(timestamp);
            if (value == null) {
                throw new EmptySequenceCacheException(this.key.getSchemaName(), this.key.getSequenceName());
            }
            return true;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append createSequence(long startWith, long incrementBy, long cacheSize, long timestamp, long minValue, long maxValue, boolean cycle) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)MetaOp.CREATE_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes(timestamp));
        }
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        byte[] startWithBuf = PLong.INSTANCE.toBytes(startWith);
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, timestamp, startWithBuf), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.START_WITH_BYTES, timestamp, startWithBuf), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.INCREMENT_BY_BYTES, timestamp, PLong.INSTANCE.toBytes(incrementBy)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CACHE_SIZE_BYTES, timestamp, PLong.INSTANCE.toBytes(cacheSize)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_VALUE_BYTES, timestamp, PLong.INSTANCE.toBytes(minValue)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MAX_VALUE_BYTES, timestamp, PLong.INSTANCE.toBytes(maxValue)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CYCLE_FLAG_BYTES, timestamp, PBoolean.INSTANCE.toBytes(cycle)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, timestamp, PDataType.FALSE_BYTES)));
        return append;
    }

    public long createSequence(Result result, long minValue, long maxValue, boolean cycle) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = new SequenceValue(timestamp, minValue, maxValue, cycle);
            this.insertSequenceValue(value);
            return timestamp;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append dropSequence(long timestamp) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)MetaOp.DROP_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes(timestamp));
        }
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY)));
        return append;
    }

    public long dropSequence(Result result) throws SQLException {
        SQLExceptionCode code;
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        SQLExceptionCode sQLExceptionCode = code = statusCode == 0 ? null : SQLExceptionCode.fromErrorCode(statusCode);
        if (code == null) {
            this.insertSequenceValue(new SequenceValue(timestamp, true));
            return timestamp;
        }
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public static String getCreateTableStatement(int nSaltBuckets) {
        if (nSaltBuckets <= 0) {
            return "CREATE TABLE SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT, \nCURRENT_VALUE BIGINT, \nINCREMENT_BY BIGINT, \nCACHE_SIZE BIGINT, \nMIN_VALUE BIGINT, \nMAX_VALUE BIGINT, \nCYCLE_FLAG BOOLEAN, \nLIMIT_REACHED_FLAG BOOLEAN \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true\n";
        }
        return "CREATE TABLE SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT, \nCURRENT_VALUE BIGINT, \nINCREMENT_BY BIGINT, \nCACHE_SIZE BIGINT, \nMIN_VALUE BIGINT, \nMAX_VALUE BIGINT, \nCYCLE_FLAG BOOLEAN, \nLIMIT_REACHED_FLAG BOOLEAN \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000,\nKEEP_DELETED_CELLS=true\n,SALT_BUCKETS=" + nSaltBuckets;
    }

    static {
        Collections.sort(SEQUENCE_KV_COLUMNS, KeyValue.COMPARATOR);
        CURRENT_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CURRENT_VALUE_KV);
        INCREMENT_BY_INDEX = SEQUENCE_KV_COLUMNS.indexOf(INCREMENT_BY_KV);
        CACHE_SIZE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CACHE_SIZE_KV);
        MIN_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(MIN_VALUE_KV);
        MAX_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(MAX_VALUE_KV);
        CYCLE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CYCLE_KV);
        LIMIT_REACHED_INDEX = SEQUENCE_KV_COLUMNS.indexOf(LIMIT_REACHED_KV);
        NUM_SEQUENCE_KEY_VALUES = SEQUENCE_KV_COLUMNS.size();
        EMPTY_SEQUENCE_CACHE_EXCEPTION = new EmptySequenceCacheException();
    }

    private static final class SequenceValue {
        public final long incrementBy;
        public final long timestamp;
        public final long cacheSize;
        public long currentValue;
        public long nextValue;
        public long minValue;
        public long maxValue;
        public boolean cycle;
        public boolean isDeleted;
        public boolean limitReached;

        public SequenceValue(long timestamp, long minValue, long maxValue, boolean cycle) {
            this(timestamp, false);
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.cycle = cycle;
        }

        public SequenceValue(long timestamp, boolean isDeleted) {
            this.timestamp = timestamp;
            this.isDeleted = isDeleted;
            this.incrementBy = 0L;
            this.limitReached = false;
            this.cacheSize = 0L;
        }

        public boolean isInitialized() {
            return this.incrementBy != 0L;
        }

        public boolean isUnitialized() {
            return this.incrementBy == 0L;
        }

        public SequenceValue(Result r, ValueOp op) {
            KeyValue currentValueKV = Sequence.getCurrentValueKV(r);
            KeyValue incrementByKV = Sequence.getIncrementByKV(r);
            KeyValue cacheSizeKV = Sequence.getCacheSizeKV(r);
            KeyValue minValueKV = Sequence.getMinValueKV(r);
            KeyValue maxValueKV = Sequence.getMaxValueKV(r);
            KeyValue cycleKV = Sequence.getCycleKV(r);
            this.timestamp = currentValueKV.getTimestamp();
            this.nextValue = PLong.INSTANCE.getCodec().decodeLong(currentValueKV.getValueArray(), currentValueKV.getValueOffset(), SortOrder.getDefault());
            this.incrementBy = PLong.INSTANCE.getCodec().decodeLong(incrementByKV.getValueArray(), incrementByKV.getValueOffset(), SortOrder.getDefault());
            this.cacheSize = PLong.INSTANCE.getCodec().decodeLong(cacheSizeKV.getValueArray(), cacheSizeKV.getValueOffset(), SortOrder.getDefault());
            this.minValue = PLong.INSTANCE.getCodec().decodeLong(minValueKV.getValueArray(), minValueKV.getValueOffset(), SortOrder.getDefault());
            this.maxValue = PLong.INSTANCE.getCodec().decodeLong(maxValueKV.getValueArray(), maxValueKV.getValueOffset(), SortOrder.getDefault());
            this.cycle = (Boolean)PBoolean.INSTANCE.toObject(cycleKV.getValueArray(), cycleKV.getValueOffset(), cycleKV.getValueLength());
            this.limitReached = false;
            this.currentValue = this.nextValue;
            if (op != ValueOp.VALIDATE_SEQUENCE) {
                this.currentValue -= this.incrementBy * this.cacheSize;
            }
        }
    }

    public static enum MetaOp {
        CREATE_SEQUENCE,
        DROP_SEQUENCE,
        RETURN_SEQUENCE;

    }

    public static enum ValueOp {
        VALIDATE_SEQUENCE,
        RESERVE_SEQUENCE,
        INCREMENT_SEQUENCE;

    }
}

