/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;

public final class PTableType
extends Enum<PTableType> {
    public static final /* enum */ PTableType SYSTEM;
    public static final /* enum */ PTableType TABLE;
    public static final /* enum */ PTableType VIEW;
    public static final /* enum */ PTableType INDEX;
    public static final /* enum */ PTableType PROJECTED;
    public static final /* enum */ PTableType SUBQUERY;
    private final PName value;
    private final String serializedValue;
    private static final PTableType[] FROM_SERIALIZED_VALUE;
    private static final int FROM_SERIALIZED_VALUE_OFFSET;
    private static final Map<String, PTableType> FROM_VALUE;
    private static final /* synthetic */ PTableType[] $VALUES;

    public static PTableType[] values() {
        return (PTableType[])$VALUES.clone();
    }

    public static PTableType valueOf(String name) {
        return Enum.valueOf(PTableType.class, name);
    }

    private PTableType(String serializedValue, String value) {
        this.serializedValue = serializedValue;
        this.value = PNameFactory.newName(value);
    }

    public String getSerializedValue() {
        return this.serializedValue;
    }

    public PName getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.getString();
    }

    public static PTableType fromValue(String value) {
        PTableType type = FROM_VALUE.get(value);
        if (type == null) {
            throw new IllegalArgumentException("Unable to PTableType enum for value of '" + value + "'");
        }
        return type;
    }

    public static PTableType fromSerializedValue(String serializedValue) {
        int i;
        if (serializedValue.length() == 1 && (i = serializedValue.charAt(0) - FROM_SERIALIZED_VALUE_OFFSET) >= 0 && i < FROM_SERIALIZED_VALUE.length && FROM_SERIALIZED_VALUE[i] != null) {
            return FROM_SERIALIZED_VALUE[i];
        }
        throw new IllegalArgumentException("Unable to PTableType enum for serialized value of '" + serializedValue + "'");
    }

    public static PTableType fromSerializedValue(byte serializedByte) {
        int i = serializedByte - FROM_SERIALIZED_VALUE_OFFSET;
        if (i >= 0 && i < FROM_SERIALIZED_VALUE.length && FROM_SERIALIZED_VALUE[i] != null) {
            return FROM_SERIALIZED_VALUE[i];
        }
        throw new IllegalArgumentException("Unable to PTableType enum for serialized value of '" + (char)serializedByte + "'");
    }

    static {
        char c;
        SYSTEM = new PTableType("s", "SYSTEM TABLE");
        TABLE = new PTableType("u", "TABLE");
        VIEW = new PTableType("v", "VIEW");
        INDEX = new PTableType("i", "INDEX");
        PROJECTED = new PTableType("p", "PROJECTED");
        SUBQUERY = new PTableType("q", "SUBQUERY");
        $VALUES = new PTableType[]{SYSTEM, TABLE, VIEW, INDEX, PROJECTED, SUBQUERY};
        FROM_VALUE = Maps.newHashMapWithExpectedSize(PTableType.values().length);
        int minChar = Integer.MAX_VALUE;
        int n = Integer.MIN_VALUE;
        for (PTableType type : PTableType.values()) {
            char c2 = type.getSerializedValue().charAt(0);
            if (c2 < minChar) {
                minChar = c2;
            }
            if (c2 <= c) continue;
            c = c2;
        }
        FROM_SERIALIZED_VALUE_OFFSET = minChar;
        FROM_SERIALIZED_VALUE = new PTableType[c - minChar + true];
        PTableType[] pTableTypeArray = PTableType.values();
        int n2 = pTableTypeArray.length;
        for (int i = 0; i < n2; ++i) {
            PTableType type;
            PTableType.FROM_SERIALIZED_VALUE[type.getSerializedValue().charAt((int)0) - minChar] = type = pTableTypeArray[i];
        }
        for (PTableType type : PTableType.values()) {
            if (FROM_VALUE.put(type.getValue().getString(), type) == null) continue;
            throw new IllegalStateException("Duplicate PTableType value of " + type.getValue().getString() + " is not allowed");
        }
    }
}

