/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.stats.PTableStats;

public interface PTable
extends PMetaDataEntity {
    public static final long INITIAL_SEQ_NUM = 0L;
    public static final String IS_IMMUTABLE_ROWS_PROP_NAME = "IMMUTABLE_ROWS";
    public static final boolean DEFAULT_DISABLE_WAL = false;

    public long getTimeStamp();

    public long getSequenceNumber();

    public PName getName();

    public PName getSchemaName();

    public PName getTableName();

    public PName getTenantId();

    public PTableType getType();

    public PName getPKName();

    public List<PColumn> getPKColumns();

    public List<PColumn> getColumns();

    public List<PColumnFamily> getColumnFamilies();

    public PColumnFamily getColumnFamily(byte[] var1) throws ColumnFamilyNotFoundException;

    public PColumnFamily getColumnFamily(String var1) throws ColumnFamilyNotFoundException;

    public PColumn getColumn(String var1) throws ColumnNotFoundException, AmbiguousColumnException;

    public PColumn getPKColumn(String var1) throws ColumnNotFoundException;

    public PRow newRow(KeyValueBuilder var1, long var2, ImmutableBytesWritable var4, byte[] ... var5);

    public PRow newRow(KeyValueBuilder var1, ImmutableBytesWritable var2, byte[] ... var3);

    public int newKey(ImmutableBytesWritable var1, byte[][] var2);

    public RowKeySchema getRowKeySchema();

    public Integer getBucketNum();

    public List<PTable> getIndexes();

    public PIndexState getIndexState();

    public PName getParentName();

    public PName getParentTableName();

    public PName getParentSchemaName();

    public int getRowTimestampColPos();

    public List<PName> getPhysicalNames();

    public PName getPhysicalName();

    public boolean isImmutableRows();

    public void getIndexMaintainers(ImmutableBytesWritable var1, PhoenixConnection var2);

    public IndexMaintainer getIndexMaintainer(PTable var1, PhoenixConnection var2);

    public PName getDefaultFamilyName();

    public boolean isWALDisabled();

    public boolean isMultiTenant();

    public boolean getStoreNulls();

    public ViewType getViewType();

    public String getViewStatement();

    public Short getViewIndexId();

    public PTableKey getKey();

    public IndexType getIndexType();

    public PTableStats getTableStats();

    public static enum LinkType {
        INDEX_TABLE(1),
        PHYSICAL_TABLE(2),
        PARENT_TABLE(3);

        private final byte[] byteValue;
        private final byte serializedValue;

        private LinkType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes(this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static LinkType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > LinkType.values().length) {
                return null;
            }
            return LinkType.values()[serializedValue - 1];
        }
    }

    public static enum IndexType {
        GLOBAL(1),
        LOCAL(2);

        private final byte[] byteValue;
        private final byte serializedValue;

        private IndexType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes(this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static IndexType getDefault() {
            return GLOBAL;
        }

        public static IndexType fromToken(String token) {
            return IndexType.valueOf(token.trim().toUpperCase());
        }

        public static IndexType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > IndexType.values().length) {
                throw new IllegalArgumentException("Invalid IndexType " + serializedValue);
            }
            return IndexType.values()[serializedValue - 1];
        }
    }

    public static enum ViewType {
        MAPPED(1),
        READ_ONLY(2),
        UPDATABLE(3);

        private final byte[] byteValue;
        private final byte serializedValue;

        private ViewType(byte serializedValue) {
            this.serializedValue = serializedValue;
            this.byteValue = Bytes.toBytes(this.name());
        }

        public byte[] getBytes() {
            return this.byteValue;
        }

        public boolean isReadOnly() {
            return this != UPDATABLE;
        }

        public byte getSerializedValue() {
            return this.serializedValue;
        }

        public static ViewType fromSerializedValue(byte serializedValue) {
            if (serializedValue < 1 || serializedValue > ViewType.values().length) {
                throw new IllegalArgumentException("Invalid ViewType " + serializedValue);
            }
            return ViewType.values()[serializedValue - 1];
        }

        public ViewType combine(ViewType otherType) {
            if (otherType == null) {
                return this;
            }
            if (this == UPDATABLE && otherType == UPDATABLE) {
                return UPDATABLE;
            }
            return READ_ONLY;
        }
    }
}

