/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.primitives.Longs;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.TimeKeeper;

public class PMetaDataImpl
implements PMetaData {
    private final PMetaDataCache metaData;

    public PMetaDataImpl(int initialCapacity, long maxByteSize) {
        this.metaData = new PMetaDataCache(initialCapacity, maxByteSize, TimeKeeper.SYSTEM);
    }

    public PMetaDataImpl(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper) {
        this.metaData = new PMetaDataCache(initialCapacity, maxByteSize, timeKeeper);
    }

    private PMetaDataImpl(PMetaDataCache metaData) {
        this.metaData = metaData.clone();
    }

    @Override
    public PMetaDataImpl clone() {
        return new PMetaDataImpl(this.metaData);
    }

    @Override
    public PTable getTable(PTableKey key) throws TableNotFoundException {
        PTableRef ref = this.metaData.get(key);
        if (ref == null) {
            throw new TableNotFoundException(key.getName());
        }
        return ref.table;
    }

    @Override
    public PFunction getFunction(PTableKey key) throws FunctionNotFoundException {
        PFunction function = (PFunction)this.metaData.functions.get(key);
        if (function == null) {
            throw new FunctionNotFoundException(key.getName());
        }
        return function;
    }

    @Override
    public int size() {
        return this.metaData.size();
    }

    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        long overage;
        PMetaDataCache newMetaData;
        int netGain = 0;
        PTableKey key = table.getKey();
        PTableRef oldTableRef = this.metaData.get(key);
        if (oldTableRef != null) {
            netGain -= oldTableRef.estSize;
        }
        PTable newParentTable = null;
        if (table.getParentName() != null) {
            String parentName = table.getParentName().getString();
            PTableRef oldParentRef = this.metaData.get(new PTableKey(table.getTenantId(), parentName));
            if (oldParentRef != null) {
                List<PTable> oldIndexes = oldParentRef.table.getIndexes();
                ArrayList<PTable> newIndexes = Lists.newArrayListWithExpectedSize(oldIndexes.size() + 1);
                newIndexes.addAll(oldIndexes);
                for (int i = 0; i < newIndexes.size(); ++i) {
                    PTable index = (PTable)newIndexes.get(i);
                    if (!index.getName().equals(table.getName())) continue;
                    newIndexes.remove(i);
                    break;
                }
                newIndexes.add(table);
                netGain -= oldParentRef.estSize;
                newParentTable = PTableImpl.makePTable(oldParentRef.table, table.getTimeStamp(), newIndexes);
                netGain += newParentTable.getEstimatedSize();
            }
        }
        if (newParentTable == null) {
            netGain += table.getEstimatedSize();
        }
        PMetaDataCache pMetaDataCache = newMetaData = (overage = this.metaData.getCurrentSize() + (long)netGain - this.metaData.getMaxSize()) <= 0L ? this.metaData.clone() : this.metaData.cloneMinusOverage(overage);
        if (newParentTable != null) {
            newMetaData.put(newParentTable.getKey(), newParentTable);
            newMetaData.putDuplicate(table.getKey(), table);
        } else {
            newMetaData.put(table.getKey(), table);
        }
        for (PTable index : table.getIndexes()) {
            newMetaData.putDuplicate(index.getKey(), index);
        }
        return new PMetaDataImpl(newMetaData);
    }

    @Override
    public PMetaData addColumn(PName tenantId, String tableName, List<PColumn> columnsToAdd, long tableTimeStamp, long tableSeqNum, boolean isImmutableRows, boolean isWalDisabled, boolean isMultitenant, boolean storeNulls) throws SQLException {
        List<PColumn> newColumns;
        PTableRef oldTableRef = this.metaData.get(new PTableKey(tenantId, tableName));
        if (oldTableRef == null) {
            return this;
        }
        List<PColumn> oldColumns = PTableImpl.getColumnsToClone(oldTableRef.table);
        if (columnsToAdd.isEmpty()) {
            newColumns = oldColumns;
        } else {
            newColumns = Lists.newArrayListWithExpectedSize(oldColumns.size() + columnsToAdd.size());
            newColumns.addAll(oldColumns);
            newColumns.addAll(columnsToAdd);
        }
        PTableImpl newTable = PTableImpl.makePTable(oldTableRef.table, tableTimeStamp, tableSeqNum, newColumns, isImmutableRows, isWalDisabled, isMultitenant, storeNulls);
        return this.addTable(newTable);
    }

    @Override
    public PMetaData removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        List<PTable> oldIndexes;
        PMetaDataCache tables = null;
        PTableRef parentTableRef = null;
        PTableKey key = new PTableKey(tenantId, tableName);
        if (this.metaData.get(key) == null) {
            if (parentTableName != null) {
                parentTableRef = this.metaData.get(new PTableKey(tenantId, parentTableName));
            }
            if (parentTableRef == null) {
                return this;
            }
        } else {
            tables = this.metaData.clone();
            PTable table = tables.remove(key);
            for (PTable index : table.getIndexes()) {
                tables.remove(index.getKey());
            }
            if (table.getParentName() != null) {
                parentTableRef = tables.get(new PTableKey(tenantId, table.getParentName().getString()));
            }
        }
        if (parentTableRef != null && (oldIndexes = parentTableRef.table.getIndexes()) != null && !oldIndexes.isEmpty()) {
            ArrayList<PTable> newIndexes = Lists.newArrayListWithExpectedSize(oldIndexes.size());
            newIndexes.addAll(oldIndexes);
            for (int i = 0; i < newIndexes.size(); ++i) {
                PTable index = (PTable)newIndexes.get(i);
                if (!index.getName().getString().equals(tableName)) continue;
                newIndexes.remove(i);
                PTableImpl parentTable = PTableImpl.makePTable(parentTableRef.table, tableTimeStamp == Long.MAX_VALUE ? parentTableRef.table.getTimeStamp() : tableTimeStamp, newIndexes);
                if (tables == null) {
                    tables = this.metaData.clone();
                }
                tables.put(parentTable.getKey(), parentTable);
                break;
            }
        }
        return tables == null ? this : new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData removeColumn(PName tenantId, String tableName, List<PColumn> columnsToRemove, long tableTimeStamp, long tableSeqNum) throws SQLException {
        PTableRef tableRef = this.metaData.get(new PTableKey(tenantId, tableName));
        if (tableRef == null) {
            return this;
        }
        PTable table = tableRef.table;
        PMetaDataCache tables = this.metaData.clone();
        for (PColumn columnToRemove : columnsToRemove) {
            String familyName = columnToRemove.getFamilyName().getString();
            PColumn column = familyName == null ? table.getPKColumn(columnToRemove.getName().getString()) : table.getColumnFamily(familyName).getColumn(columnToRemove.getName().getString());
            int positionOffset = 0;
            int position = column.getPosition();
            List<PColumn> oldColumns = table.getColumns();
            if (table.getBucketNum() != null) {
                --position;
                positionOffset = 1;
                oldColumns = oldColumns.subList(positionOffset, oldColumns.size());
            }
            ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(oldColumns.size() - 1);
            columns.addAll(oldColumns.subList(0, position));
            for (int i = position + 1; i < oldColumns.size(); ++i) {
                PColumn oldColumn = oldColumns.get(i);
                PColumnImpl newColumn = new PColumnImpl(oldColumn.getName(), oldColumn.getFamilyName(), oldColumn.getDataType(), oldColumn.getMaxLength(), oldColumn.getScale(), oldColumn.isNullable(), i - 1 + positionOffset, oldColumn.getSortOrder(), oldColumn.getArraySize(), oldColumn.getViewConstant(), oldColumn.isViewReferenced(), null, oldColumn.isRowTimestamp());
                columns.add(newColumn);
            }
            table = PTableImpl.makePTable(table, tableTimeStamp, tableSeqNum, columns);
        }
        tables.put(table.getKey(), table);
        return new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData pruneTables(PMetaData.Pruner pruner) {
        ArrayList<PTableKey> keysToPrune = Lists.newArrayListWithExpectedSize(this.size());
        for (PTable table : this) {
            if (!pruner.prune(table)) continue;
            keysToPrune.add(table.getKey());
        }
        if (keysToPrune.isEmpty()) {
            return this;
        }
        PMetaDataCache tables = this.metaData.clone();
        for (PTableKey key : keysToPrune) {
            tables.remove(key);
        }
        return new PMetaDataImpl(tables);
    }

    @Override
    public Iterator<PTable> iterator() {
        return this.metaData.iterator();
    }

    @Override
    public PMetaData addFunction(PFunction function) throws SQLException {
        this.metaData.functions.put(function.getKey(), function);
        return this;
    }

    @Override
    public PMetaData removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        this.metaData.functions.remove(new PTableKey(tenantId, function));
        return this;
    }

    @Override
    public PMetaData pruneFunctions(PMetaData.Pruner pruner) {
        ArrayList<PTableKey> keysToPrune = Lists.newArrayListWithExpectedSize(this.size());
        for (PFunction function : this.metaData.functions.values()) {
            if (!pruner.prune(function)) continue;
            keysToPrune.add(function.getKey());
        }
        if (keysToPrune.isEmpty()) {
            return this;
        }
        PMetaDataCache clone = this.metaData.clone();
        for (PTableKey key : keysToPrune) {
            clone.functions.remove(key);
        }
        return new PMetaDataImpl(clone);
    }

    private static class PMetaDataCache
    implements Cloneable {
        private static final int MIN_REMOVAL_SIZE = 3;
        private static final Comparator<PTableRef> COMPARATOR = new Comparator<PTableRef>(){

            @Override
            public int compare(PTableRef tableRef1, PTableRef tableRef2) {
                return Longs.compare(tableRef1.lastAccessTime, tableRef2.lastAccessTime);
            }
        };
        private static final MinMaxPriorityQueue.Builder<PTableRef> BUILDER = MinMaxPriorityQueue.orderedBy(COMPARATOR);
        private long currentByteSize;
        private final long maxByteSize;
        private final int expectedCapacity;
        private final TimeKeeper timeKeeper;
        private final Map<PTableKey, PTableRef> tables;
        private final Map<PTableKey, PFunction> functions;

        private static Map<PTableKey, PTableRef> newMap(int expectedCapacity) {
            return Maps.newHashMapWithExpectedSize(expectedCapacity);
        }

        private static Map<PTableKey, PFunction> newFunctionMap(int expectedCapacity) {
            return Maps.newHashMapWithExpectedSize(expectedCapacity);
        }

        private static Map<PTableKey, PTableRef> cloneMap(Map<PTableKey, PTableRef> tables, int expectedCapacity) {
            Map<PTableKey, PTableRef> newTables = PMetaDataCache.newMap(Math.max(tables.size(), expectedCapacity));
            for (PTableRef tableAccess : tables.values()) {
                newTables.put(tableAccess.table.getKey(), new PTableRef(tableAccess));
            }
            return newTables;
        }

        private static Map<PTableKey, PFunction> cloneFunctionsMap(Map<PTableKey, PFunction> functions, int expectedCapacity) {
            Map<PTableKey, PFunction> newFunctions = PMetaDataCache.newFunctionMap(Math.max(functions.size(), expectedCapacity));
            for (PFunction functionAccess : functions.values()) {
                newFunctions.put(functionAccess.getKey(), new PFunction(functionAccess));
            }
            return newFunctions;
        }

        private PMetaDataCache(PMetaDataCache toClone) {
            this.timeKeeper = toClone.timeKeeper;
            this.maxByteSize = toClone.maxByteSize;
            this.currentByteSize = toClone.currentByteSize;
            this.expectedCapacity = toClone.expectedCapacity;
            this.tables = PMetaDataCache.cloneMap(toClone.tables, this.expectedCapacity);
            this.functions = PMetaDataCache.cloneFunctionsMap(toClone.functions, this.expectedCapacity);
        }

        public PMetaDataCache(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper) {
            this.currentByteSize = 0L;
            this.maxByteSize = maxByteSize;
            this.expectedCapacity = initialCapacity;
            this.tables = PMetaDataCache.newMap(this.expectedCapacity);
            this.functions = PMetaDataCache.newFunctionMap(this.expectedCapacity);
            this.timeKeeper = timeKeeper;
        }

        public PTableRef get(PTableKey key) {
            PTableRef tableAccess = this.tables.get(key);
            if (tableAccess == null) {
                return null;
            }
            tableAccess.lastAccessTime = this.timeKeeper.getCurrentTime();
            return tableAccess;
        }

        public PMetaDataCache clone() {
            return new PMetaDataCache(this);
        }

        public PMetaDataCache cloneMinusOverage(long overage) {
            assert (overage > 0L);
            int nToRemove = Math.max(3, (int)Math.ceil((double)(this.currentByteSize - this.maxByteSize) / ((double)this.currentByteSize / (double)this.size())) + 1);
            MinMaxPriorityQueue toRemove = BUILDER.expectedSize(nToRemove).create();
            PMetaDataCache newCache = new PMetaDataCache(this.size(), this.maxByteSize, this.timeKeeper);
            long toRemoveBytes = 0L;
            for (PTableRef tableRef : this.tables.values()) {
                newCache.put(tableRef.table.getKey(), new PTableRef(tableRef));
                toRemove.add(tableRef);
                if ((toRemoveBytes += (long)tableRef.estSize) - (long)((PTableRef)toRemove.peekLast()).estSize <= overage) continue;
                PTableRef removedRef = (PTableRef)toRemove.removeLast();
                toRemoveBytes -= (long)removedRef.estSize;
            }
            for (PTableRef toRemoveRef : toRemove) {
                newCache.remove(toRemoveRef.table.getKey());
            }
            return newCache;
        }

        private PTable put(PTableKey key, PTableRef ref) {
            this.currentByteSize += (long)ref.estSize;
            PTableRef oldTableAccess = this.tables.put(key, ref);
            PTable oldTable = null;
            if (oldTableAccess != null) {
                this.currentByteSize -= (long)oldTableAccess.estSize;
                oldTable = oldTableAccess.table;
            }
            return oldTable;
        }

        public PTable put(PTableKey key, PTable value) {
            return this.put(key, new PTableRef(value, this.timeKeeper.getCurrentTime()));
        }

        public PTable putDuplicate(PTableKey key, PTable value) {
            return this.put(key, new PTableRef(value, this.timeKeeper.getCurrentTime(), 0));
        }

        public PTable remove(PTableKey key) {
            PTableRef value = this.tables.remove(key);
            if (value == null) {
                return null;
            }
            this.currentByteSize -= (long)value.estSize;
            return value.table;
        }

        public Iterator<PTable> iterator() {
            final Iterator<PTableRef> iterator = this.tables.values().iterator();
            return new Iterator<PTable>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public PTable next() {
                    return ((PTableRef)iterator.next()).table;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return this.tables.size();
        }

        public long getCurrentSize() {
            return this.currentByteSize;
        }

        public long getMaxSize() {
            return this.maxByteSize;
        }
    }

    private static final class PTableRef {
        public final PTable table;
        public final int estSize;
        public volatile long lastAccessTime;

        public PTableRef(PTable table, long lastAccessTime, int estSize) {
            this.table = table;
            this.lastAccessTime = lastAccessTime;
            this.estSize = estSize;
        }

        public PTableRef(PTable table, long lastAccessTime) {
            this(table, lastAccessTime, table.getEstimatedSize());
        }

        public PTableRef(PTableRef tableRef) {
            this(tableRef.table, tableRef.lastAccessTime, tableRef.estSize);
        }
    }
}

