/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.IndexExpressionCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateFunctionStatement;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropFunctionStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.UpdateStatisticsStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.DelegateTable;
import org.apache.phoenix.schema.FunctionAlreadyExistsException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.NewerFunctionAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataClient {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataClient.class);
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private static final String CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT,SALT_BUCKETS,PK_NAME,DATA_TABLE_NAME,INDEX_STATE,IMMUTABLE_ROWS,DEFAULT_COLUMN_FAMILY,VIEW_STATEMENT,DISABLE_WAL,MULTI_TENANT,VIEW_TYPE,VIEW_INDEX_ID,INDEX_TYPE,STORE_NULLS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE) VALUES (?, ?, ?, ?, ?)";
    private static final String CREATE_VIEW_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,PARENT_TENANT_ID " + PVarchar.INSTANCE.getSqlTypeName() + ") VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INCREMENT_SEQ_NUM = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_SEQ_NUM) VALUES (?, ?, ?, ?)";
    private static final String MUTATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_INDEX_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE) VALUES (?, ?, ?, ?)";
    private static final String UPDATE_INDEX_STATE_TO_ACTIVE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE,INDEX_DISABLE_TIMESTAMP) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_COLUMN_CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_COLUMN_ALTER_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_COLUMN_POSITION = "UPSERT INTO SYSTEM.\"CATALOG\" ( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,ORDINAL_POSITION) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_FUNCTION = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,NUM_ARGS,CLASS_NAME,JAR_PATH,RETURN_TYPE) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_FUNCTION_ARGUMENT = "UPSERT INTO SYSTEM.\"FUNCTION\" ( TENANT_ID,FUNCTION_NAME,TYPE,ARG_POSITION,IS_ARRAY,IS_CONSTANT,DEFAULT_VALUE,MIN_VALUE,MAX_VALUE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final PhoenixConnection connection;

    public MetaDataClient(PhoenixConnection connection) {
        this.connection = connection;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public long getCurrentTime(String schemaName, String tableName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.updateCache(schemaName, tableName, true);
        return result.getMutationTime();
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName) throws SQLException {
        return this.updateCache(schemaName, tableName, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), schemaName, tableName, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, String schemaName, String tableName) throws SQLException {
        return this.updateCache(tenantId, schemaName, tableName, false);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames) throws SQLException {
        return this.updateCache(functionNames, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        return this.updateCache(this.connection.getTenantId(), functionNames, alwaysHitServer);
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames) throws SQLException {
        return this.updateCache(tenantId, functionNames, false);
    }

    private long getClientTimeStamp() {
        Long scn = this.connection.getSCN();
        long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
        return clientTimeStamp;
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        long clientTimeStamp = this.getClientTimeStamp();
        boolean systemTable = "SYSTEM".equals(schemaName);
        tenantId = systemTable ? null : tenantId;
        PTable table = null;
        String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
        long tableTimestamp = Long.MAX_VALUE;
        try {
            table = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
            tableTimestamp = table.getTimeStamp();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        if (table != null && !alwaysHitServer && (systemTable || tableTimestamp == clientTimeStamp - 1L)) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, -1L, table);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            byte[] schemaBytes = PVarchar.INSTANCE.toBytes(schemaName);
            byte[] tableBytes = PVarchar.INSTANCE.toBytes(tableName);
            result = this.connection.getQueryServices().getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, clientTimeStamp);
            if ("SYSTEM".equals(schemaName)) {
                return result;
            }
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            PTable resultTable = result.getTable();
            if (resultTable != null) {
                this.addTableToCache(result);
                return result;
            }
            if (table != null) {
                if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    result.setTable(table);
                    if (this.addIndexesFromPhysicalTable(result)) {
                        this.connection.addTable(result.getTable());
                    }
                    return result;
                }
                if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND && tryCount + 1 == maxTryCount) {
                    this.connection.removeTable(tenantId, fullTableName, table.getParentName() == null ? null : table.getParentName().getString(), table.getTimeStamp());
                }
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(PName tenantId, List<String> functionNames, boolean alwaysHitServer) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        long clientTimeStamp = this.getClientTimeStamp();
        ArrayList<PFunction> functions = new ArrayList<PFunction>(functionNames.size());
        ArrayList<Long> functionTimeStamps = new ArrayList<Long>(functionNames.size());
        Iterator<String> iterator = functionNames.iterator();
        while (iterator.hasNext()) {
            PFunction function = null;
            try {
                String functionName = iterator.next();
                function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function != null && !alwaysHitServer && function.getTimeStamp() == clientTimeStamp - 1L) {
                    functions.add(function);
                    iterator.remove();
                    continue;
                }
                if (function != null && function.getTimeStamp() != clientTimeStamp - 1L) {
                    functionTimeStamps.add(function.getTimeStamp());
                    continue;
                }
                functionTimeStamps.add(Long.MAX_VALUE);
            }
            catch (FunctionNotFoundException e) {
                functionTimeStamps.add(Long.MAX_VALUE);
            }
        }
        if (functionNames.isEmpty()) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS, -1L, functions, true);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            ArrayList<Pair<byte[], Long>> functionsToFecth = new ArrayList<Pair<byte[], Long>>(functionNames.size());
            for (int i = 0; i < functionNames.size(); ++i) {
                functionsToFecth.add(new Pair(PVarchar.INSTANCE.toBytes(functionNames.get(i)), functionTimeStamps.get(i)));
            }
            result = this.connection.getQueryServices().getFunctions(tenantId, functionsToFecth, clientTimeStamp);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (result.getFunctions() != null && !result.getFunctions().isEmpty()) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_ALREADY_EXISTS) {
                result.getFunctions().addAll(functions);
                this.addFunctionToCache(result);
                return result;
            }
            if (code == MetaDataProtocol.MutationCode.FUNCTION_NOT_FOUND && tryCount + 1 == maxTryCount) {
                for (Pair pair : functionsToFecth) {
                    this.connection.removeFunction(tenantId, Bytes.toString((byte[])pair.getFirst()), (Long)pair.getSecond());
                }
                throw new FunctionNotFoundException(functionNames.toString() + " not found");
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    private boolean addIndexesFromPhysicalTable(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        String tableName;
        PTable table = result.getTable();
        if (table.getType() != PTableType.VIEW || table.getViewType() == PTable.ViewType.MAPPED) {
            return false;
        }
        String physicalName = table.getPhysicalName().getString();
        String schemaName = SchemaUtil.getSchemaNameFromFullName(physicalName);
        MetaDataProtocol.MetaDataMutationResult parentResult = this.updateCache(null, schemaName, tableName = SchemaUtil.getTableNameFromFullName(physicalName), false);
        PTable physicalTable = parentResult.getTable();
        if (physicalTable == null) {
            throw new TableNotFoundException(schemaName, tableName);
        }
        if (!result.wasUpdated() && !parentResult.wasUpdated()) {
            return false;
        }
        List<PTable> indexes = physicalTable.getIndexes();
        if (indexes.isEmpty()) {
            return false;
        }
        ArrayList<PTable> allIndexes = Lists.newArrayListWithExpectedSize(indexes.size() + table.getIndexes().size());
        if (result.wasUpdated()) {
            allIndexes.addAll(table.getIndexes());
        } else {
            for (PTable index : indexes) {
                if (index.getViewIndexId() == null) continue;
                allIndexes.add(index);
            }
        }
        for (PTable index : indexes) {
            int i;
            if (index.getViewIndexId() != null) continue;
            boolean containsAllReqdCols = true;
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(physicalTable, this.connection);
            Set<ColumnReference> indexColRefs = indexMaintainer.getIndexedColumns();
            for (ColumnReference colRef : indexColRefs) {
                try {
                    byte[] cf = colRef.getFamily();
                    byte[] cq = colRef.getQualifier();
                    if (cf != null) {
                        table.getColumnFamily(cf).getColumn(cq);
                        continue;
                    }
                    table.getColumn(Bytes.toString(cq));
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
            }
            List<PColumn> pkColumns = physicalTable.getPKColumns();
            int n = i = physicalTable.getBucketNum() == null ? 0 : 1;
            while (i < pkColumns.size()) {
                try {
                    PColumn pkColumn = pkColumns.get(i);
                    table.getColumn(pkColumn.getName().getString());
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
                ++i;
            }
            for (PColumn col : table.getColumns()) {
                if (col.getViewConstant() == null) continue;
                try {
                    String indexColumnName = IndexUtil.getIndexColumnName(col);
                    index.getColumn(indexColumnName);
                }
                catch (ColumnNotFoundException e) {
                    containsAllReqdCols = false;
                    break;
                }
            }
            if (!containsAllReqdCols) continue;
            String viewStatement = IndexUtil.rewriteViewStatement(this.connection, index, physicalTable, table.getViewStatement());
            index = PTableImpl.makePTable(index, viewStatement);
            allIndexes.add(index);
        }
        PTableImpl allIndexesTable = PTableImpl.makePTable(table, table.getTimeStamp(), allIndexes);
        result.setTable(allIndexesTable);
        return true;
    }

    private void addColumnMutation(String schemaName, String tableName, PColumn column, PreparedStatement colUpsert, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        colUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        colUpsert.setString(2, schemaName);
        colUpsert.setString(3, tableName);
        colUpsert.setString(4, column.getName().getString());
        colUpsert.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
        colUpsert.setInt(6, column.getDataType().getSqlType());
        colUpsert.setInt(7, column.isNullable() ? 1 : 0);
        if (column.getMaxLength() == null) {
            colUpsert.setNull(8, 4);
        } else {
            colUpsert.setInt(8, column.getMaxLength());
        }
        if (column.getScale() == null) {
            colUpsert.setNull(9, 4);
        } else {
            colUpsert.setInt(9, column.getScale());
        }
        colUpsert.setInt(10, column.getPosition() + (isSalted ? 0 : 1));
        colUpsert.setInt(11, column.getSortOrder().getSystemValue());
        colUpsert.setString(12, parentTableName);
        if (column.getArraySize() == null) {
            colUpsert.setNull(13, 4);
        } else {
            colUpsert.setInt(13, column.getArraySize());
        }
        colUpsert.setBytes(14, column.getViewConstant());
        colUpsert.setBoolean(15, column.isViewReferenced());
        colUpsert.setString(16, pkName);
        if (keySeq == null) {
            colUpsert.setNull(17, 5);
        } else {
            colUpsert.setShort(17, keySeq);
        }
        if (column.getExpressionStr() == null) {
            colUpsert.setNull(18, 12);
        } else {
            colUpsert.setString(18, column.getExpressionStr());
        }
        if (colUpsert.getParameterMetaData().getParameterCount() > 18) {
            colUpsert.setBoolean(19, column.isRowTimestamp());
        }
        colUpsert.execute();
    }

    private void addFunctionArgMutation(String functionName, PFunction.FunctionArgument arg, PreparedStatement argUpsert, int position) throws SQLException {
        argUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        argUpsert.setString(2, functionName);
        argUpsert.setString(3, arg.getArgumentType());
        byte[] bytes = Bytes.toBytes((short)position);
        argUpsert.setBytes(4, bytes);
        argUpsert.setBoolean(5, arg.isArrayType());
        argUpsert.setBoolean(6, arg.isConstant());
        argUpsert.setString(7, arg.getDefaultValue() == null ? null : arg.getDefaultValue().toString());
        argUpsert.setString(8, arg.getMinValue() == null ? null : arg.getMinValue().toString());
        argUpsert.setString(9, arg.getMaxValue() == null ? null : arg.getMaxValue().toString());
        argUpsert.execute();
    }

    private PColumn newColumn(int position, ColumnDef def, PrimaryKeyConstraint pkConstraint, String defaultColumnFamily, boolean addingToPK) throws SQLException {
        try {
            Pair<ColumnName, SortOrder> pkSortOrder;
            ColumnName columnDefName = def.getColumnDefName();
            SortOrder sortOrder = def.getSortOrder();
            boolean isPK = def.isPK();
            boolean isRowTimestamp = def.isRowTimestamp();
            if (pkConstraint != null && (pkSortOrder = pkConstraint.getColumnWithSortOrder(columnDefName)) != null) {
                isPK = true;
                sortOrder = pkSortOrder.getSecond();
                isRowTimestamp = pkConstraint.isColumnRowTimestamp(columnDefName);
            }
            String columnName = columnDefName.getColumnName();
            PName familyName = null;
            if (def.isPK() && !pkConstraint.getColumnNames().isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(columnName).build().buildException();
            }
            boolean isNull = def.isNull();
            if (def.getColumnDefName().getFamilyName() != null) {
                String family = def.getColumnDefName().getFamilyName();
                if (isPK) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                if (!def.isNull()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                familyName = PNameFactory.newName(family);
            } else if (!isPK) {
                familyName = PNameFactory.newName(defaultColumnFamily == null ? "0" : defaultColumnFamily);
            }
            if (isPK && !addingToPK && pkConstraint.getColumnNames().size() <= 1) {
                if (def.isNull() && def.isNullSet()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_PK_MAY_NOT_BE_NULL).setColumnName(columnName).build().buildException();
                }
                isNull = false;
            }
            PColumnImpl column = new PColumnImpl(PNameFactory.newName(columnName), familyName, def.getDataType(), def.getMaxLength(), def.getScale(), isNull, position, sortOrder, def.getArraySize(), null, false, def.getExpression(), isRowTimestamp);
            return column;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    public MutationState createTable(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, byte[][] viewColumnConstants, BitSet isViewColumnReferenced) throws SQLException {
        PTable table = this.createTableInternal(statement, splits, parent, viewStatement, viewType, viewColumnConstants, isViewColumnReferenced, null, null);
        if (table == null || table.getType() == PTableType.VIEW) {
            return new MutationState(0L, this.connection);
        }
        PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
        Long scn = this.connection.getSCN();
        long ts = scn == null ? table.getTimeStamp() : scn.longValue();
        TableRef tableRef = new TableRef(null, table, ts, false);
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(table);
        MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), emptyCF, null, null, tableRef.getTimeStamp());
        return this.connection.getQueryServices().updateData(plan);
    }

    public MutationState updateStatistics(UpdateStatisticsStatement updateStatisticsStmt) throws SQLException {
        this.connection.rollback();
        ColumnResolver resolver = FromCompiler.getResolver(updateStatisticsStmt, this.connection);
        PTable table = resolver.getTables().get(0).getTable();
        long rowCount = 0L;
        if (updateStatisticsStmt.updateColumns()) {
            rowCount += this.updateStatisticsInternal(table.getPhysicalName(), table, updateStatisticsStmt.getProps());
        }
        if (updateStatisticsStmt.updateIndex()) {
            for (PTable index : table.getIndexes()) {
                rowCount += this.updateStatisticsInternal(index.getPhysicalName(), index, updateStatisticsStmt.getProps());
            }
            if (table.getType() != PTableType.VIEW) {
                ArrayList<PName> names = Lists.newArrayListWithExpectedSize(2);
                if (table.isMultiTenant() || MetaDataUtil.hasViewIndexTable(this.connection, table.getName())) {
                    names.add(PNameFactory.newName(SchemaUtil.getTableName(MetaDataUtil.getViewIndexSchemaName(table.getSchemaName().getString()), MetaDataUtil.getViewIndexTableName(table.getTableName().getString()))));
                }
                for (final PName name : names) {
                    DelegateTable indexLogicalTable = new DelegateTable(table){

                        @Override
                        public PName getPhysicalName() {
                            return name;
                        }

                        @Override
                        public PTableStats getTableStats() {
                            return PTableStats.EMPTY_STATS;
                        }
                    };
                    rowCount += this.updateStatisticsInternal(name, indexLogicalTable, updateStatisticsStmt.getProps());
                }
            }
        }
        return new MutationState((int)rowCount, this.connection);
    }

    private long updateStatisticsInternal(PName physicalName, PTable logicalTable, Map<String, Object> statsProps) throws SQLException {
        ReadOnlyProps props = this.connection.getQueryServices().getProps();
        long msMinBetweenUpdates = props.getLong("phoenix.stats.minUpdateFrequency", props.getLong("phoenix.stats.updateFrequency", 900000L) / 2L);
        byte[] tenantIdBytes = ByteUtil.EMPTY_BYTE_ARRAY;
        Long scn = this.connection.getSCN();
        long clientTimeStamp = this.connection.getSCN() == null ? Long.MAX_VALUE : scn;
        String query = "SELECT CURRENT_DATE(),LAST_STATS_UPDATE_TIME FROM " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " WHERE " + "PHYSICAL_NAME" + "='" + physicalName.getString() + "' AND " + "COLUMN_FAMILY" + " IS NULL AND " + "REGION_NAME" + " IS NULL AND " + "LAST_STATS_UPDATE_TIME" + " IS NOT NULL";
        ResultSet rs = this.connection.createStatement().executeQuery(query);
        long msSinceLastUpdate = Long.MAX_VALUE;
        if (rs.next()) {
            msSinceLastUpdate = rs.getLong(1) - rs.getLong(2);
        }
        long rowCount = 0L;
        if (msSinceLastUpdate >= msMinBetweenUpdates) {
            PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
            TableRef tableRef = new TableRef(null, logicalTable, clientTimeStamp, false);
            MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), null, null, null, clientTimeStamp);
            Scan scan = plan.getContext().getScan();
            scan.setCacheBlocks(false);
            scan.setAttribute("_ANALYZETABLE", PDataType.TRUE_BYTES);
            if (statsProps != null) {
                Object gp_per_region;
                Object gp_width = statsProps.get("phoenix.stats.guidepost.width");
                if (gp_width != null) {
                    scan.setAttribute("_GUIDEPOST_WIDTH_BYTES", PLong.INSTANCE.toBytes(gp_width));
                }
                if ((gp_per_region = statsProps.get("phoenix.stats.guidepost.per.region")) != null) {
                    scan.setAttribute("_GUIDEPOST_PER_REGION", PInteger.INSTANCE.toBytes(gp_per_region));
                }
            }
            MutationState mutationState = plan.execute();
            rowCount = mutationState.getUpdateCount();
        }
        this.connection.getQueryServices().clearTableFromCache(tenantIdBytes, Bytes.toBytes(SchemaUtil.getSchemaNameFromFullName(physicalName.getString())), Bytes.toBytes(SchemaUtil.getTableNameFromFullName(physicalName.getString())), clientTimeStamp);
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndexAtTimeStamp(PTable index, NamedTableNode dataTableNode) throws SQLException {
        block13: {
            Properties props = new Properties(this.connection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(this.connection.getSCN() + 1L));
            PhoenixConnection conn = DriverManager.getConnection(this.connection.getURL(), props).unwrap(PhoenixConnection.class);
            MetaDataClient newClientAtNextTimeStamp = new MetaDataClient(conn);
            conn.setAutoCommit(true);
            ColumnResolver resolver = FromCompiler.getResolver(dataTableNode, conn);
            TableRef tableRef = resolver.getTables().get(0);
            boolean success = false;
            SQLException sqlException = null;
            try {
                MutationState state = newClientAtNextTimeStamp.buildIndex(index, tableRef);
                success = true;
                MutationState mutationState = state;
                return mutationState;
            }
            catch (SQLException e) {
                sqlException = e;
                return sqlException;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (sqlException == null) {
                        if (success) {
                            sqlException = e;
                        }
                    }
                    sqlException.setNextException(e);
                }
                if (sqlException == null) break block13;
                throw sqlException;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndex(PTable index, TableRef dataTableRef) throws SQLException {
        AlterIndexStatement indexStatement = null;
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            MutationPlan mutationPlan;
            Object object;
            this.connection.setAutoCommit(true);
            if (index.getIndexType() == PTable.IndexType.LOCAL) {
                PhoenixStatement statement = new PhoenixStatement(this.connection);
                object = null;
                try {
                    String tableName = this.getFullTableName(dataTableRef);
                    String query = "SELECT count(*) FROM " + tableName;
                    final QueryPlan plan = statement.compileQuery(query);
                    TableRef tableRef = plan.getTableRef();
                    Scan scan = plan.getContext().getScan();
                    try {
                        if (ScanUtil.isDefaultTimeRange(scan.getTimeRange())) {
                            Long scn = this.connection.getSCN();
                            if (scn == null) {
                                scn = plan.getContext().getCurrentTime();
                            }
                            scan.setTimeRange(dataTableRef.getLowerBoundTimeStamp(), scn);
                        }
                    }
                    catch (IOException e) {
                        throw new SQLException(e);
                    }
                    ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                    PTable dataTable = tableRef.getTable();
                    for (PTable idx : dataTable.getIndexes()) {
                        if (!idx.getName().equals(index.getName())) continue;
                        index = idx;
                        break;
                    }
                    ArrayList<PTable> indexes = Lists.newArrayListWithExpectedSize(1);
                    indexes.add(index);
                    IndexMaintainer.serialize(dataTable, ptr, indexes, plan.getContext().getConnection());
                    scan.setAttribute("_LocalIndexBuild", ByteUtil.copyKeyBytesIfNecessary(ptr));
                    IndexMaintainer indexMaintainer = index.getIndexMaintainer(dataTable, this.connection);
                    for (ColumnReference columnRef : indexMaintainer.getAllColumns()) {
                        scan.addColumn(columnRef.getFamily(), columnRef.getQualifier());
                    }
                    mutationPlan = new MutationPlan(){

                        @Override
                        public StatementContext getContext() {
                            return plan.getContext();
                        }

                        @Override
                        public ParameterMetaData getParameterMetaData() {
                            return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
                        }

                        @Override
                        public ExplainPlan getExplainPlan() throws SQLException {
                            return ExplainPlan.EMPTY_PLAN;
                        }

                        @Override
                        public PhoenixConnection getConnection() {
                            return MetaDataClient.this.connection;
                        }

                        @Override
                        public MutationState execute() throws SQLException {
                            Cell kv = plan.iterator().next().getValue(0);
                            ImmutableBytesWritable tmpPtr = new ImmutableBytesWritable(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                            long rowCount = PLong.INSTANCE.getCodec().decodeLong(tmpPtr, SortOrder.getDefault());
                            return new MutationState(0L, MetaDataClient.this.connection, rowCount);
                        }
                    };
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (object != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            PostIndexDDLCompiler compiler = new PostIndexDDLCompiler(this.connection, dataTableRef);
            mutationPlan = compiler.compile(index);
            try {
                Long scn = this.connection.getSCN();
                if (scn == null) {
                    scn = mutationPlan.getContext().getCurrentTime();
                }
                mutationPlan.getContext().getScan().setTimeRange(dataTableRef.getLowerBoundTimeStamp(), scn);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            MutationState state = this.connection.getQueryServices().updateData(mutationPlan);
            indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.ACTIVE);
            this.alterIndex(indexStatement);
            object = state;
            return object;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String getFullTableName(TableRef dataTableRef) {
        String schemaName = dataTableRef.getTable().getSchemaName().getString();
        String tableName = dataTableRef.getTable().getTableName().getString();
        String fullName = schemaName == null ? "\"" + tableName + "\"" : "\"" + schemaName + "\"" + "." + "\"" + tableName + "\"";
        return fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPartialIndexFromTimeStamp(PTable index, TableRef dataTableRef) throws SQLException {
        boolean needRestoreIndexState = false;
        AlterIndexStatement indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.INACTIVE);
        this.alterIndex(indexStatement);
        needRestoreIndexState = true;
        try {
            this.buildIndex(index, dataTableRef);
            needRestoreIndexState = false;
        }
        finally {
            if (needRestoreIndexState) {
                indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.DISABLE);
                this.alterIndex(indexStatement);
            }
        }
    }

    public MutationState createIndex(CreateIndexStatement statement, byte[][] splits) throws SQLException {
        IndexKeyConstraint ik = statement.getIndexConstraint();
        TableName indexTableName = statement.getIndexTableName();
        List<Pair<ParseNode, SortOrder>> indexParseNodeAndSortOrderList = ik.getParseNodeAndSortOrderList();
        List<ColumnName> includedColumns = statement.getIncludeColumns();
        TableRef tableRef = null;
        PTable table = null;
        boolean retry = true;
        Short indexId = null;
        boolean allocateIndexId = false;
        boolean isLocalIndex = statement.getIndexType() == PTable.IndexType.LOCAL;
        int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
        if (isLocalIndex) {
            if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.index.allowLocalIndex", true)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNALLOWED_LOCAL_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
            }
            if (!this.connection.getQueryServices().supportsFeature(ConnectionQueryServices.Feature.LOCAL_INDEX)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_LOCAL_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
            }
        }
        while (true) {
            try {
                PColumn col;
                LinkedHashSet<RowKeyColumnExpression> unusedPkColumns;
                boolean isTenantConnection;
                ColumnResolver resolver = FromCompiler.getResolver(statement, this.connection, statement.getUdfParseNodes());
                tableRef = resolver.getTables().get(0);
                PTable dataTable = tableRef.getTable();
                boolean bl = isTenantConnection = this.connection.getTenantId() != null;
                if (isTenantConnection && dataTable.getType() != PTableType.VIEW) {
                    throw new SQLFeatureNotSupportedException("An index may only be created for a VIEW through a tenant-specific connection");
                }
                if (!dataTable.isImmutableRows()) {
                    if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                    if (this.connection.getQueryServices().hasInvalidIndexConfiguration()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                }
                int posOffset = 0;
                List<PColumn> pkColumns = dataTable.getPKColumns();
                if (dataTable.getBucketNum() != null) {
                    unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize(pkColumns.size() - 1);
                    ++posOffset;
                } else {
                    unusedPkColumns = Sets.newLinkedHashSetWithExpectedSize(pkColumns.size());
                }
                for (int i = posOffset; i < pkColumns.size(); ++i) {
                    PColumn column = pkColumns.get(i);
                    unusedPkColumns.add(new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(pkColumns, i), "\"" + column.getName().getString() + "\""));
                }
                ArrayList<ColumnDefInPkConstraint> allPkColumns = Lists.newArrayListWithExpectedSize(unusedPkColumns.size());
                ArrayList<ColumnDef> columnDefs = Lists.newArrayListWithExpectedSize(includedColumns.size() + indexParseNodeAndSortOrderList.size());
                if (dataTable.isMultiTenant()) {
                    PColumn col2 = dataTable.getPKColumns().get(posOffset);
                    RowKeyColumnExpression columnExpression = new RowKeyColumnExpression((PDatum)col2, new RowKeyValueAccessor(pkColumns, posOffset), col2.getName().getString());
                    unusedPkColumns.remove(columnExpression);
                    PDataType dataType = IndexUtil.getIndexColumnDataType(col2);
                    ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col2));
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, col2.getSortOrder(), false));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col2.isNullable(), col2.getMaxLength(), col2.getScale(), false, SortOrder.getDefault(), col2.getName().getString(), col2.isRowTimestamp()));
                }
                if (isLocalIndex || dataTable.getType() == PTableType.VIEW && dataTable.getViewType() != PTable.ViewType.MAPPED) {
                    allocateIndexId = true;
                    PDataType dataType = MetaDataUtil.getViewIndexIdDataType();
                    ColumnName colName = ColumnName.caseSensitiveColumnName(MetaDataUtil.getViewIndexIdColumnName());
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, SortOrder.getDefault(), false));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), false, null, null, false, SortOrder.getDefault(), null, false));
                }
                PhoenixStatement phoenixStatment = new PhoenixStatement(this.connection);
                StatementContext context = new StatementContext(phoenixStatment, resolver);
                IndexExpressionCompiler expressionIndexCompiler = new IndexExpressionCompiler(context);
                HashSet<ColumnName> indexedColumnNames = Sets.newHashSetWithExpectedSize(indexParseNodeAndSortOrderList.size());
                for (Pair<ParseNode, SortOrder> pair : indexParseNodeAndSortOrderList) {
                    ParseNode parseNode = pair.getFirst();
                    parseNode = StatementNormalizer.normalize(parseNode, resolver);
                    expressionIndexCompiler.reset();
                    Expression expression = parseNode.accept(expressionIndexCompiler);
                    if (expressionIndexCompiler.isAggregate()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    if (expression.getDeterminism() != Determinism.ALWAYS) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NON_DETERMINISTIC_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    if (expression.isStateless()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.STATELESS_EXPRESSION_NOT_ALLOWED_IN_INDEX).build().buildException();
                    }
                    unusedPkColumns.remove(expression);
                    StringBuilder buf = new StringBuilder();
                    parseNode.toSQL(resolver, buf);
                    String expressionStr = StringUtil.escapeBackslash(buf.toString());
                    ColumnName colName = null;
                    ColumnRef colRef = expressionIndexCompiler.getColumnRef();
                    boolean isRowTimestamp = false;
                    if (colRef != null) {
                        PColumn column = colRef.getColumn();
                        String columnFamilyName = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
                        colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(columnFamilyName, column.getName().getString()));
                        isRowTimestamp = column.isRowTimestamp();
                    } else {
                        String name = expressionStr.replaceAll("\"", "'");
                        colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, name));
                    }
                    indexedColumnNames.add(colName);
                    PDataType dataType = IndexUtil.getIndexColumnDataType(expression.isNullable(), expression.getDataType());
                    allPkColumns.add(new ColumnDefInPkConstraint(colName, pair.getSecond(), isRowTimestamp));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), expression.isNullable(), expression.getMaxLength(), expression.getScale(), false, pair.getSecond(), expressionStr, isRowTimestamp));
                }
                if (!unusedPkColumns.isEmpty()) {
                    for (RowKeyColumnExpression colExpression : unusedPkColumns) {
                        col = dataTable.getPKColumns().get(colExpression.getPosition());
                        if (col.getViewConstant() != null) continue;
                        ColumnName colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                        allPkColumns.add(new ColumnDefInPkConstraint(colName, colExpression.getSortOrder(), col.isRowTimestamp()));
                        PDataType dataType = IndexUtil.getIndexColumnDataType(colExpression.isNullable(), colExpression.getDataType());
                        columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), colExpression.isNullable(), colExpression.getMaxLength(), colExpression.getScale(), false, colExpression.getSortOrder(), colExpression.toString(), col.isRowTimestamp()));
                    }
                }
                for (ColumnName colName : includedColumns) {
                    col = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName()).getColumn();
                    if (indexedColumnNames.contains(colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col)))) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_EXIST_IN_DEF).build().buildException();
                    }
                    if (SchemaUtil.isPKColumn(col) || col.getViewConstant() != null) continue;
                    colName = ColumnName.caseSensitiveColumnName(isLocalIndex ? IndexUtil.getLocalIndexColumnFamily(col.getFamilyName().getString()) : col.getFamilyName().getString(), IndexUtil.getIndexColumnName(col));
                    columnDefs.add(FACTORY.columnDef(colName, col.getDataType().getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, col.getSortOrder(), null, col.isRowTimestamp()));
                }
                if (allocateIndexId && indexId == null) {
                    Long scn = this.connection.getSCN();
                    long timestamp = scn == null ? Long.MAX_VALUE : scn;
                    PName tenantId = this.connection.getTenantId();
                    String tenantIdStr = tenantId == null ? null : this.connection.getTenantId().getString();
                    PName physicalName = dataTable.getPhysicalName();
                    int nSequenceSaltBuckets = this.connection.getQueryServices().getSequenceSaltBuckets();
                    SequenceKey key = MetaDataUtil.getViewIndexSequenceKey(tenantIdStr, physicalName, nSequenceSaltBuckets);
                    this.createSequence(key.getTenantId(), key.getSchemaName(), key.getSequenceName(), true, -32768L, 1L, 1L, false, Long.MIN_VALUE, Long.MAX_VALUE, dataTable.getTimeStamp());
                    long[] seqValues = new long[1];
                    SQLException[] sqlExceptions = new SQLException[1];
                    this.connection.getQueryServices().incrementSequences(Collections.singletonList(key), Math.max(timestamp, dataTable.getTimeStamp()), seqValues, sqlExceptions);
                    if (sqlExceptions[0] != null) {
                        throw sqlExceptions[0];
                    }
                    long seqValue = seqValues[0];
                    if (seqValue > 32767L) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.TOO_MANY_INDEXES).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalName.getString())).setTableName(SchemaUtil.getTableNameFromFullName(physicalName.getString())).build().buildException();
                    }
                    indexId = (short)seqValue;
                }
                if (dataTable.getDefaultFamilyName() != null && dataTable.getType() != PTableType.VIEW && indexId == null) {
                    statement.getProps().put("", new Pair<String, String>("DEFAULT_COLUMN_FAMILY", dataTable.getDefaultFamilyName().getString()));
                }
                PrimaryKeyConstraint pk = FACTORY.primaryKey(null, allPkColumns);
                CreateTableStatement tableStatement = FACTORY.createTable(indexTableName, statement.getProps(), columnDefs, pk, statement.getSplitNodes(), PTableType.INDEX, statement.ifNotExists(), null, null, statement.getBindCount());
                table = this.createTableInternal(tableStatement, splits, dataTable, null, null, null, null, indexId, statement.getIndexType());
            }
            catch (ConcurrentTableMutationException e) {
                if (retry) {
                    retry = false;
                    continue;
                }
                throw e;
            }
            break;
        }
        if (table == null) {
            return new MutationState(0L, this.connection);
        }
        if (statement.isAsync()) {
            return new MutationState(0L, this.connection);
        }
        if (this.connection.getSCN() != null) {
            return this.buildIndexAtTimeStamp(table, statement.getTable());
        }
        return this.buildIndex(table, tableRef);
    }

    public MutationState dropSequence(DropSequenceStatement statement) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String schemaName = statement.getSequenceName().getSchemaName();
        String sequenceName = statement.getSequenceName().getTableName();
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try {
            this.connection.getQueryServices().dropSequence(tenantId, schemaName, sequenceName, timestamp);
        }
        catch (SequenceNotFoundException e) {
            if (statement.ifExists()) {
                return new MutationState(0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1L, this.connection);
    }

    public MutationState createSequence(CreateSequenceStatement statement, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        return this.createSequence(tenantId, statement.getSequenceName().getSchemaName(), statement.getSequenceName().getTableName(), statement.ifNotExists(), startWith, incrementBy, cacheSize, statement.getCycle(), minValue, maxValue, timestamp);
    }

    private MutationState createSequence(String tenantId, String schemaName, String sequenceName, boolean ifNotExists, long startWith, long incrementBy, long cacheSize, boolean cycle, long minValue, long maxValue, long timestamp) throws SQLException {
        try {
            this.connection.getQueryServices().createSequence(tenantId, schemaName, sequenceName, startWith, incrementBy, cacheSize, minValue, maxValue, cycle, timestamp);
        }
        catch (SequenceAlreadyExistsException e) {
            if (ifNotExists) {
                return new MutationState(0L, this.connection);
            }
            throw e;
        }
        return new MutationState(1L, this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState createFunction(CreateFunctionStatement stmt) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            PFunction function = new PFunction(stmt.getFunctionInfo(), stmt.isTemporary());
            this.connection.setAutoCommit(false);
            String tenantIdStr = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
            ArrayList<Mutation> functionData = Lists.newArrayListWithExpectedSize(function.getFunctionArguments().size() + 1);
            List<PFunction.FunctionArgument> args = function.getFunctionArguments();
            PreparedStatement argUpsert = this.connection.prepareStatement(INSERT_FUNCTION_ARGUMENT);
            for (int i = 0; i < args.size(); ++i) {
                PFunction.FunctionArgument arg = args.get(i);
                this.addFunctionArgMutation(function.getFunctionName(), arg, argUpsert, i);
            }
            functionData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            PreparedStatement functionUpsert = this.connection.prepareStatement(CREATE_FUNCTION);
            functionUpsert.setString(1, tenantIdStr);
            functionUpsert.setString(2, function.getFunctionName());
            functionUpsert.setInt(3, function.getFunctionArguments().size());
            functionUpsert.setString(4, function.getClassName());
            functionUpsert.setString(5, function.getJarPath());
            functionUpsert.setString(6, function.getReturnType());
            functionUpsert.execute();
            functionData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createFunction(functionData, function, stmt.isTemporary());
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_ALREADY_EXISTS: {
                    throw new FunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                }
                case NEWER_FUNCTION_FOUND: {
                    throw new NewerFunctionAlreadyExistsException(function.getFunctionName(), result.getFunctions().get(0));
                }
            }
            ArrayList<PFunction> functions = new ArrayList<PFunction>(1);
            functions.add(function);
            result = new MetaDataProtocol.MetaDataMutationResult(code, result.getMutationTime(), functions, true);
            this.addFunctionToCache(result);
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
        return new MutationState(1L, this.connection);
    }

    private static ColumnDef findColumnDefOrNull(List<ColumnDef> colDefs, ColumnName colName) {
        for (ColumnDef colDef : colDefs) {
            if (!colDef.getColumnDefName().getColumnName().equals(colName.getColumnName())) continue;
            return colDef;
        }
        return null;
    }

    private static boolean checkAndValidateRowTimestampCol(ColumnDef colDef, PrimaryKeyConstraint pkConstraint, boolean rowTimeStampColAlreadyFound, PTableType tableType) throws SQLException {
        ColumnName columnDefName = colDef.getColumnDefName();
        if (tableType == PTableType.VIEW && (pkConstraint.getNumColumnsWithRowTimestamp() > 0 || colDef.isRowTimestamp())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_NOT_ALLOWED_ON_VIEW).setColumnName(columnDefName.getColumnName()).build().buildException();
        }
        if (tableType == PTableType.TABLE) {
            boolean isColumnDeclaredRowTimestamp;
            boolean bl = isColumnDeclaredRowTimestamp = colDef.isRowTimestamp() || pkConstraint.isColumnRowTimestamp(columnDefName);
            if (isColumnDeclaredRowTimestamp) {
                boolean isColumnPartOfPk;
                boolean bl2 = isColumnPartOfPk = colDef.isPK() || pkConstraint.contains(columnDefName);
                if (isColumnDeclaredRowTimestamp && !isColumnPartOfPk) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                PDataType dataType = colDef.getDataType();
                if (isColumnDeclaredRowTimestamp && dataType != PLong.INSTANCE && dataType != PUnsignedLong.INSTANCE && !dataType.isCoercibleTo(PTimestamp.INSTANCE)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_COL_INVALID_TYPE).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                if (rowTimeStampColAlreadyFound && isColumnDeclaredRowTimestamp) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_ONE_PK_COL_ONLY).setColumnName(columnDefName.getColumnName()).build().buildException();
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable createTableInternal(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, final byte[][] viewColumnConstants, final BitSet isViewColumnReferenced, Short indexId, PTable.IndexType indexType) throws SQLException {
        PTableType tableType = statement.getTableType();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            boolean bl;
            LinkedHashSet<PColumn> pkColumns;
            ArrayList<PColumn> columns;
            Boolean storeNullsProp;
            boolean isLocalIndex;
            this.connection.setAutoCommit(false);
            ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize(statement.getColumnDefs().size() + 3);
            TableName tableNameNode = statement.getTableName();
            String schemaName = tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            String parentTableName = null;
            PName tenantId = this.connection.getTenantId();
            String tenantIdStr = tenantId == null ? null : this.connection.getTenantId().getString();
            boolean multiTenant = false;
            boolean storeNulls = false;
            Integer saltBucketNum = null;
            String defaultFamilyName = null;
            boolean isImmutableRows = false;
            List<Object> physicalNames = Collections.emptyList();
            boolean addSaltColumn = false;
            boolean bl2 = isLocalIndex = indexType == PTable.IndexType.LOCAL;
            if (parent != null && tableType == PTableType.INDEX) {
                if (isLocalIndex || parent.getType() == PTableType.VIEW && parent.getViewType() != PTable.ViewType.MAPPED) {
                    PName physicalName = parent.getPhysicalName();
                    saltBucketNum = parent.getBucketNum();
                    boolean bl3 = addSaltColumn = saltBucketNum != null && !isLocalIndex;
                    if (isLocalIndex) {
                        defaultFamilyName = parent.getDefaultFamilyName() == null ? "L#0" : IndexUtil.getLocalIndexColumnFamily(parent.getDefaultFamilyName().getString());
                        saltBucketNum = null;
                        physicalNames = Collections.singletonList(PNameFactory.newName(physicalName.getBytes()));
                    } else {
                        defaultFamilyName = parent.getDefaultFamilyName() == null ? "0" : parent.getDefaultFamilyName().getString();
                        physicalNames = Collections.singletonList(PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(physicalName.getBytes())));
                    }
                }
                multiTenant = parent.isMultiTenant();
                storeNulls = parent.getStoreNulls();
                parentTableName = parent.getTableName().getString();
                PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                incrementStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                incrementStatement.setString(2, schemaName);
                incrementStatement.setString(3, parentTableName);
                incrementStatement.setLong(4, parent.getSequenceNumber());
                incrementStatement.execute();
                tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                linkStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                linkStatement.setString(2, schemaName);
                linkStatement.setString(3, parentTableName);
                linkStatement.setString(4, tableName);
                linkStatement.setByte(5, PTable.LinkType.INDEX_TABLE.getSerializedValue());
                linkStatement.execute();
            }
            PrimaryKeyConstraint pkConstraint = statement.getPrimaryKeyConstraint();
            String pkName = null;
            List<Object> pkColumnsNames = Collections.emptyList();
            Iterator<Object> pkColumnsIterator = Iterators.emptyIterator();
            if (pkConstraint != null) {
                pkColumnsNames = pkConstraint.getColumnNames();
                pkColumnsIterator = pkColumnsNames.iterator();
                pkName = pkConstraint.getName();
            }
            HashMap<String, Object> tableProps = Maps.newHashMapWithExpectedSize(statement.getProps().size());
            Map commonFamilyProps = Collections.emptyMap();
            HColumnDescriptor defaultDescriptor = new HColumnDescriptor(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            if (!statement.getProps().isEmpty()) {
                commonFamilyProps = Maps.newHashMapWithExpectedSize(statement.getProps().size());
                List<Pair<String, Object>> props = statement.getProps().get("");
                for (Pair pair : props) {
                    if (defaultDescriptor.getValue((String)pair.getFirst()) == null) {
                        tableProps.put((String)pair.getFirst(), pair.getSecond());
                        continue;
                    }
                    commonFamilyProps.put(pair.getFirst(), pair.getSecond());
                }
            }
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean isImmutableRowsProp = (Boolean)tableProps.remove("IMMUTABLE_ROWS");
                isImmutableRows = isImmutableRowsProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.mutate.immutableRows", false) : isImmutableRowsProp.booleanValue();
            }
            if (tableType != PTableType.VIEW && indexId == null) {
                saltBucketNum = (Integer)tableProps.remove("SALT_BUCKETS");
                if (saltBucketNum != null && (saltBucketNum < 0 || saltBucketNum > SaltingUtil.MAX_BUCKET_NUM)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_BUCKET_NUM).build().buildException();
                }
                if (saltBucketNum == null) {
                    if (parent != null) {
                        saltBucketNum = parent.getBucketNum();
                    }
                } else if (saltBucketNum == 0) {
                    saltBucketNum = null;
                }
                addSaltColumn = saltBucketNum != null;
            }
            boolean removedProp = false;
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean multiTenantProp = (Boolean)tableProps.remove("MULTI_TENANT");
                multiTenant = Boolean.TRUE.equals(multiTenantProp);
                defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
                removedProp = defaultFamilyName != null;
            }
            boolean disableWAL = false;
            Boolean bl4 = (Boolean)tableProps.remove("DISABLE_WAL");
            if (bl4 != null) {
                disableWAL = bl4;
            }
            boolean bl5 = storeNulls = (storeNullsProp = (Boolean)tableProps.remove("STORE_NULLS")) == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.table.default.store.nulls", false) : storeNullsProp.booleanValue();
            if (!(statement.getTableType() != PTableType.VIEW && indexId == null || tableProps.isEmpty())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
            }
            if (removedProp) {
                tableProps.put("DEFAULT_COLUMN_FAMILY", defaultFamilyName);
            }
            List<ColumnDef> colDefs = statement.getColumnDefs();
            if (tenantId != null && tableType != PTableType.VIEW && indexId == null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (tableType == PTableType.VIEW) {
                physicalNames = Collections.singletonList(PNameFactory.newName(parent.getPhysicalName().getString()));
                if (viewType == PTable.ViewType.MAPPED) {
                    columns = Lists.newArrayListWithExpectedSize(colDefs.size());
                    pkColumns = Sets.newLinkedHashSetWithExpectedSize(colDefs.size());
                } else {
                    multiTenant = parent.isMultiTenant();
                    saltBucketNum = parent.getBucketNum();
                    isImmutableRows = parent.isImmutableRows();
                    disableWAL = bl4 == null ? parent.isWALDisabled() : bl4.booleanValue();
                    defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                    List<PColumn> allColumns = parent.getColumns();
                    if (saltBucketNum != null) {
                        allColumns = allColumns.subList(1, allColumns.size());
                    }
                    columns = Lists.newArrayListWithExpectedSize(allColumns.size() + colDefs.size());
                    columns.addAll(allColumns);
                    pkColumns = Sets.newLinkedHashSet(parent.getPKColumns());
                    PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_VIEW_LINK);
                    linkStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                    linkStatement.setString(2, schemaName);
                    linkStatement.setString(3, tableName);
                    linkStatement.setString(4, parent.getName().getString());
                    linkStatement.setByte(5, PTable.LinkType.PARENT_TABLE.getSerializedValue());
                    linkStatement.setString(6, parent.getTenantId() == null ? null : parent.getTenantId().getString());
                    linkStatement.execute();
                }
            } else {
                columns = Lists.newArrayListWithExpectedSize(colDefs.size());
                pkColumns = Sets.newLinkedHashSetWithExpectedSize(colDefs.size() + 1);
            }
            if (!(physicalNames.isEmpty() || viewType == PTable.ViewType.MAPPED && ((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getTableName(schemaName, tableName)))) {
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                for (PName pName : physicalNames) {
                    linkStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                    linkStatement.setString(2, schemaName);
                    linkStatement.setString(3, tableName);
                    linkStatement.setString(4, pName.getString());
                    linkStatement.setByte(5, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                    linkStatement.execute();
                }
            }
            PreparedStatement colUpsert = this.connection.prepareStatement(INSERT_COLUMN_CREATE_TABLE);
            LinkedHashMap<String, PName> familyNames = Maps.newLinkedHashMap();
            boolean bl6 = false;
            boolean rowTimeStampColumnAlreadyFound = false;
            int positionOffset = columns.size();
            if (saltBucketNum != null) {
                ++positionOffset;
                if (addSaltColumn) {
                    pkColumns.add(SaltingUtil.SALTING_COLUMN);
                }
            }
            int position = positionOffset;
            for (ColumnDef colDef : colDefs) {
                rowTimeStampColumnAlreadyFound = MetaDataClient.checkAndValidateRowTimestampCol(colDef, pkConstraint, rowTimeStampColumnAlreadyFound, tableType);
                if (colDef.isPK()) {
                    if (bl) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                    }
                    bl = true;
                } else if (Boolean.FALSE.equals(colDef.isNull()) && (bl || pkConstraint != null && !pkConstraint.contains(colDef.getColumnDefName()))) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_NOT_NULL_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                }
                PColumn column = this.newColumn(position++, colDef, pkConstraint, defaultFamilyName, false);
                if (SchemaUtil.isPKColumn(column)) {
                    if (pkColumnsIterator.hasNext() && !column.getName().getString().equals(((ColumnName)((Pair)pkColumnsIterator.next()).getFirst()).getColumnName())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_OUT_OF_ORDER).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                    }
                    if (tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DEFINE_PK_FOR_VIEW).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                    }
                    if (!pkColumns.add(column)) {
                        throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                    }
                }
                if (tableType == PTableType.VIEW && MetaDataClient.hasColumnWithSameNameAndFamily(columns, column)) {
                    throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                }
                columns.add(column);
                if ((colDef.getDataType() == PVarbinary.INSTANCE || colDef.getDataType().isArrayType()) && SchemaUtil.isPKColumn(column) && pkColumnsIterator.hasNext()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_IN_ROW_KEY).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                }
                if (column.getFamilyName() == null) continue;
                familyNames.put(IndexUtil.getActualColumnFamilyName(column.getFamilyName().getString()), column.getFamilyName());
            }
            if (!bl && pkColumnsNames.isEmpty() && tableType != PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (!pkColumnsNames.isEmpty() && pkColumnsNames.size() != pkColumns.size() - positionOffset) {
                Iterator<Object> pkColumnNamesIterator = pkColumnsNames.iterator();
                while (pkColumnNamesIterator.hasNext()) {
                    ColumnName colName = (ColumnName)((Pair)pkColumnNamesIterator.next()).getFirst();
                    ColumnDef colDef = MetaDataClient.findColumnDefOrNull(colDefs, colName);
                    if (colDef == null) {
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName.getColumnName());
                    }
                    if (colDef.getColumnDefName().getFamilyName() == null) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).setFamilyName(colDef.getColumnDefName().getFamilyName()).build().buildException();
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_PRIMARY_KEY_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            ArrayList<Pair<byte[], Map<String, Object>>> familyPropList = Lists.newArrayListWithExpectedSize(familyNames.size());
            if (!statement.getProps().isEmpty()) {
                for (Object familyName : statement.getProps().keySet()) {
                    if (((String)familyName).equals("")) continue;
                    if (familyNames.get(familyName) == null) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PROPERTIES_FOR_FAMILY).setFamilyName((String)familyName).build().buildException();
                    }
                    if (statement.getTableType() != PTableType.VIEW) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                }
            }
            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, pkColumns, saltBucketNum != null, multiTenant);
            for (Object familyName : familyNames.values()) {
                String fam = familyName.getString();
                List<Pair<String, Object>> props = statement.getProps().get(IndexUtil.getActualColumnFamilyName(fam));
                if (props.isEmpty()) {
                    familyPropList.add(new Pair(familyName.getBytes(), commonFamilyProps));
                    continue;
                }
                HashMap combinedFamilyProps = Maps.newHashMapWithExpectedSize(props.size() + commonFamilyProps.size());
                combinedFamilyProps.putAll(commonFamilyProps);
                for (Pair pair : props) {
                    if (!familyName.equals("") && ((String)pair.getFirst()).equals("TTL")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_TTL).build().buildException();
                    }
                    combinedFamilyProps.put(pair.getFirst(), pair.getSecond());
                }
                familyPropList.add(new Pair(familyName.getBytes(), combinedFamilyProps));
            }
            if (familyNames.isEmpty()) {
                byte[] cf = defaultFamilyName == null ? (!isLocalIndex ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES) : Bytes.toBytes(defaultFamilyName);
                familyPropList.add(new Pair(cf, commonFamilyProps));
            }
            if (SchemaUtil.isMetaTable(schemaName, tableName)) {
                PName newSchemaName = PNameFactory.newName(schemaName);
                PTableImpl table = PTableImpl.makePTable(tenantId, newSchemaName, PNameFactory.newName(tableName), tableType, null, 0L, 0L, PNameFactory.newName("pk"), null, columns, null, null, Collections.emptyList(), isImmutableRows, Collections.emptyList(), defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), null, Boolean.TRUE.equals(disableWAL), false, false, null, indexId, indexType);
                this.connection.addTable(table);
            } else if (tableType == PTableType.INDEX && indexId == null && tableProps.get("MAX_FILESIZE") == null) {
                int nIndexRowKeyColumns = bl ? 1 : pkColumnsNames.size();
                int nIndexKeyValueColumns = columns.size() - nIndexRowKeyColumns;
                int nBaseRowKeyColumns = parent.getPKColumns().size() - (parent.getBucketNum() == null ? 0 : 1);
                int nBaseKeyValueColumns = parent.getColumns().size() - parent.getPKColumns().size();
                double ratio = ((double)(1 + nIndexKeyValueColumns) + (double)(nIndexRowKeyColumns - nBaseRowKeyColumns) / 4.0) / (double)(1 + nBaseKeyValueColumns);
                HTableDescriptor hTableDescriptor = this.connection.getQueryServices().getTableDescriptor(parent.getPhysicalName().getBytes());
                if (hTableDescriptor != null) {
                    long maxFileSize = hTableDescriptor.getMaxFileSize();
                    if (maxFileSize == -1L) {
                        maxFileSize = 0x280000000L;
                    }
                    tableProps.put("MAX_FILESIZE", (long)((double)maxFileSize * ratio));
                }
            }
            short nextKeySeq = 0;
            for (int i = 0; i < columns.size(); ++i) {
                Short s;
                PColumn column = (PColumn)columns.get(i);
                final int columnPosition = column.getPosition();
                if (isViewColumnReferenced != null) {
                    if (viewColumnConstants != null && columnPosition < viewColumnConstants.length) {
                        column = new DelegateColumn(column){

                            @Override
                            public byte[] getViewConstant() {
                                return viewColumnConstants[columnPosition];
                            }

                            @Override
                            public boolean isViewReferenced() {
                                return isViewColumnReferenced.get(columnPosition);
                            }
                        };
                        columns.set(i, column);
                    } else {
                        column = new DelegateColumn(column){

                            @Override
                            public boolean isViewReferenced() {
                                return isViewColumnReferenced.get(columnPosition);
                            }
                        };
                        columns.set(i, column);
                    }
                }
                if (SchemaUtil.isPKColumn(column)) {
                    nextKeySeq = (short)(nextKeySeq + 1);
                    s = nextKeySeq;
                } else {
                    s = null;
                }
                Short keySeq = s;
                this.addColumnMutation(schemaName, tableName, column, colUpsert, parentTableName, pkName, keySeq, saltBucketNum != null);
            }
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            String dataTableName = parent == null || tableType == PTableType.VIEW ? null : parent.getTableName().getString();
            PIndexState indexState = parent == null || tableType == PTableType.VIEW ? null : PIndexState.BUILDING;
            PreparedStatement tableUpsert = this.connection.prepareStatement(CREATE_TABLE);
            tableUpsert.setString(1, tenantIdStr);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, tableType.getSerializedValue());
            tableUpsert.setLong(5, 0L);
            tableUpsert.setInt(6, position);
            if (saltBucketNum != null) {
                tableUpsert.setInt(7, saltBucketNum);
            } else {
                tableUpsert.setNull(7, 4);
            }
            tableUpsert.setString(8, pkName);
            tableUpsert.setString(9, dataTableName);
            tableUpsert.setString(10, indexState == null ? null : indexState.getSerializedValue());
            tableUpsert.setBoolean(11, isImmutableRows);
            tableUpsert.setString(12, defaultFamilyName);
            tableUpsert.setString(13, viewStatement);
            tableUpsert.setBoolean(14, disableWAL);
            tableUpsert.setBoolean(15, multiTenant);
            if (viewType == null) {
                tableUpsert.setNull(16, -6);
            } else {
                tableUpsert.setByte(16, viewType.getSerializedValue());
            }
            if (indexId == null) {
                tableUpsert.setNull(17, 5);
            } else {
                tableUpsert.setShort(17, indexId);
            }
            if (indexType == null) {
                tableUpsert.setNull(18, -6);
            } else {
                tableUpsert.setByte(18, indexType.getSerializedValue());
            }
            tableUpsert.setBoolean(19, storeNulls);
            tableUpsert.execute();
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            Collections.reverse(tableMetaData);
            if (!isLocalIndex) {
                splits = SchemaUtil.processSplits(splits, pkColumns, saltBucketNum, this.connection.getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false));
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createTable(tableMetaData, viewType == PTable.ViewType.MAPPED || indexId != null ? ((PName)physicalNames.get(0)).getBytes() : null, tableType, tableProps, familyPropList, splits);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case TABLE_ALREADY_EXISTS: {
                    this.addTableToCache(result);
                    if (!statement.ifNotExists()) {
                        throw new TableAlreadyExistsException(schemaName, tableName, result.getTable());
                    }
                    PTable pTable = null;
                    return pTable;
                }
                case PARENT_TABLE_NOT_FOUND: {
                    throw new TableNotFoundException(schemaName, parent.getName().getString());
                }
                case NEWER_TABLE_FOUND: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                case UNALLOWED_TABLE_MUTATION: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case CONCURRENT_TABLE_MUTATION: {
                    this.addTableToCache(result);
                    throw new ConcurrentTableMutationException(schemaName, tableName);
                }
            }
            PName pName = PNameFactory.newName(schemaName);
            PTableImpl table = PTableImpl.makePTable(tenantId, pName, PNameFactory.newName(tableName), tableType, indexState, result.getMutationTime(), 0L, pkName == null ? null : PNameFactory.newName(pkName), saltBucketNum, columns, dataTableName == null ? null : pName, dataTableName == null ? null : PNameFactory.newName(dataTableName), Collections.emptyList(), isImmutableRows, physicalNames, defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), viewStatement, Boolean.TRUE.equals(disableWAL), multiTenant, storeNulls, viewType, indexId, indexType);
            result = new MetaDataProtocol.MetaDataMutationResult(code, result.getMutationTime(), (PTable)table, true);
            this.addTableToCache(result);
            PTableImpl pTableImpl = table;
            return pTableImpl;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private byte[][] getSplitKeys(List<HRegionLocation> allTableRegions) {
        if (allTableRegions.size() == 1) {
            return null;
        }
        byte[][] splitKeys = new byte[allTableRegions.size() - 1][];
        int i = 0;
        for (HRegionLocation region : allTableRegions) {
            if (region.getRegionInfo().getStartKey().length == 0) continue;
            splitKeys[i] = region.getRegionInfo().getStartKey();
            ++i;
        }
        return splitKeys;
    }

    private static boolean hasColumnWithSameNameAndFamily(Collection<PColumn> columns, PColumn column) {
        for (PColumn currColumn : columns) {
            if (!Objects.equal(currColumn.getFamilyName(), column.getFamilyName()) || !Objects.equal(currColumn.getName(), column.getName())) continue;
            return true;
        }
        return false;
    }

    private static void throwIfInsufficientColumns(String schemaName, String tableName, Collection<PColumn> columns, boolean isSalted, boolean isMultiTenant) throws SQLException {
        PColumn tenantIdCol;
        if (!isMultiTenant) {
            return;
        }
        int nPKColumns = columns.size() - (isSalted ? 1 : 0);
        if (nPKColumns < 2) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        Iterator<PColumn> iterator = columns.iterator();
        if (isSalted) {
            iterator.next();
        }
        if (!(tenantIdCol = iterator.next()).getDataType().isCoercibleTo(PVarchar.INSTANCE) || tenantIdCol.isNullable()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
    }

    public MutationState dropTable(DropTableStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, null, statement.getTableType(), statement.ifExists(), statement.cascade());
    }

    public MutationState dropFunction(DropFunctionStatement statement) throws SQLException {
        return this.dropFunction(statement.getFunctionName(), statement.ifExists());
    }

    public MutationState dropIndex(DropIndexStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getIndexName().getName();
        String parentTableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, parentTableName, PTableType.INDEX, statement.ifExists(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState dropFunction(String functionName, boolean ifExists) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PName tenantId = this.connection.getTenantId();
            byte[] key = SchemaUtil.getFunctionKey(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes(), Bytes.toBytes(functionName));
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            try {
                PFunction function = this.connection.getMetaDataCache().getFunction(new PTableKey(tenantId, functionName));
                if (function.isTemporaryFunction()) {
                    this.connection.removeFunction(tenantId, functionName, clientTimeStamp);
                    MutationState mutationState = new MutationState(0L, this.connection);
                    return mutationState;
                }
            }
            catch (FunctionNotFoundException function) {
                // empty catch block
            }
            ArrayList<Mutation> functionMetaData = Lists.newArrayListWithExpectedSize(2);
            Delete functionDelete = new Delete(key, clientTimeStamp);
            functionMetaData.add(functionDelete);
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropFunction(functionMetaData, ifExists);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case FUNCTION_NOT_FOUND: {
                    if (ifExists) break;
                    throw new FunctionNotFoundException(functionName);
                }
                default: {
                    this.connection.removeFunction(tenantId, functionName, result.getMutationTime());
                }
            }
            MutationState mutationState = new MutationState(0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private MutationState dropTable(String schemaName, String tableName, String parentTableName, PTableType tableType, boolean ifExists, boolean cascade) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PName tenantId = this.connection.getTenantId();
            String tenantIdStr = tenantId == null ? null : tenantId.getString();
            byte[] key = SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName);
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize(2);
            Delete tableDelete = new Delete(key, clientTimeStamp);
            tableMetaData.add(tableDelete);
            boolean hasViewIndexTable = false;
            boolean hasLocalIndexTable = false;
            if (parentTableName != null) {
                byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantIdStr, schemaName, parentTableName, tableName);
                Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                tableMetaData.add(linkDelete);
            } else {
                hasViewIndexTable = MetaDataUtil.hasViewIndexTable(this.connection, schemaName, tableName);
                hasLocalIndexTable = MetaDataUtil.hasLocalIndexTable(this.connection, schemaName, tableName);
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropTable(tableMetaData, tableType, cascade);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case TABLE_NOT_FOUND: {
                    if (ifExists) break;
                    throw new TableNotFoundException(schemaName, tableName);
                }
                case NEWER_TABLE_FOUND: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
                }
                case UNALLOWED_TABLE_MUTATION: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                default: {
                    boolean dropMetaData;
                    long ts;
                    this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), parentTableName, result.getMutationTime());
                    long l = ts = scn == null ? result.getMutationTime() : scn.longValue();
                    if (result.getTable() != null && tableType != PTableType.VIEW) {
                        boolean dropMetaData2 = result.getTable().getViewIndexId() == null && this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                        this.connection.setAutoCommit(true);
                        PTable table = result.getTable();
                        ArrayList<TableRef> tableRefs = Lists.newArrayListWithExpectedSize(2 + table.getIndexes().size());
                        if (tableType == PTableType.TABLE && (table.isMultiTenant() || hasViewIndexTable || hasLocalIndexTable)) {
                            MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName());
                            if (hasViewIndexTable) {
                                void var26_32;
                                Object viewIndexSchemaName = null;
                                Object var26_29 = null;
                                if (schemaName != null) {
                                    viewIndexSchemaName = MetaDataUtil.getViewIndexTableName(schemaName);
                                    String mutationState = tableName;
                                } else {
                                    String string = MetaDataUtil.getViewIndexTableName(tableName);
                                }
                                PTableImpl viewIndexTable = new PTableImpl(null, (String)viewIndexSchemaName, (String)var26_32, ts, table.getColumnFamilies());
                                tableRefs.add(new TableRef(null, viewIndexTable, ts, false));
                            }
                        }
                        tableRefs.add(new TableRef(null, table, ts, false));
                        for (PTable pTable : table.getIndexes()) {
                            tableRefs.add(new TableRef(null, pTable, ts, false));
                        }
                        this.deleteFromStatsTable(tableRefs, ts);
                        if (!dropMetaData2) {
                            MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                            MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                            return mutationState;
                        }
                        break;
                    }
                    if (result.getTable() == null || tableType != PTableType.VIEW) break;
                    PTable table = result.getTable();
                    boolean bl = dropMetaData = table.getViewIndexId() == null && this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                    if (table.getIndexes().isEmpty()) break;
                    ArrayList<TableRef> tableRefs = Lists.newArrayListWithExpectedSize(table.getIndexes().size());
                    for (PTable pTable : table.getIndexes()) {
                        tableRefs.add(new TableRef(null, pTable, ts, false));
                    }
                    if (dropMetaData) break;
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
            }
            MutationState mutationState = new MutationState(0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFromStatsTable(List<TableRef> tableRefs, long ts) throws SQLException {
        block18: {
            Properties props = new Properties(this.connection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(ts));
            Connection conn = DriverManager.getConnection(this.connection.getURL(), props);
            conn.setAutoCommit(true);
            boolean success = false;
            SQLException sqlException = null;
            try {
                StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.STATS WHERE PHYSICAL_NAME IN (");
                for (TableRef ref : tableRefs) {
                    buf.append("'" + ref.getTable().getName().getString() + "',");
                }
                buf.setCharAt(buf.length() - 1, ')');
                if (tableRefs.get(0).getTable().getIndexType() == PTable.IndexType.LOCAL) {
                    buf.append(" AND COLUMN_FAMILY IN(");
                    if (tableRefs.get(0).getTable().getColumnFamilies().isEmpty()) {
                        buf.append("'L#0',");
                    } else {
                        for (PColumnFamily cf : tableRefs.get(0).getTable().getColumnFamilies()) {
                            buf.append("'" + cf.getName().getString() + "',");
                        }
                    }
                    buf.setCharAt(buf.length() - 1, ')');
                }
                conn.createStatement().execute(buf.toString());
                success = true;
            }
            catch (SQLException e) {
                sqlException = e;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (sqlException == null) {
                        if (success) {
                            sqlException = e;
                        }
                    }
                    sqlException.setNextException(e);
                }
                if (sqlException == null) break block18;
                throw sqlException;
            }
        }
    }

    private MetaDataProtocol.MutationCode processMutationResult(String schemaName, String tableName, MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        MetaDataProtocol.MutationCode mutationCode = result.getMutationCode();
        PName tenantId = this.connection.getTenantId();
        switch (mutationCode) {
            case TABLE_NOT_FOUND: {
                this.connection.removeTable(tenantId, SchemaUtil.getTableName(schemaName, tableName), null, Long.MAX_VALUE);
                throw new TableNotFoundException(schemaName, tableName);
            }
            case UNALLOWED_TABLE_MUTATION: {
                String columnName = null;
                String familyName = null;
                String msg = null;
                if (result.getColumnName() != null) {
                    familyName = result.getFamilyName() == null ? null : Bytes.toString(result.getFamilyName());
                    columnName = Bytes.toString(result.getColumnName());
                    msg = "Cannot drop column referenced by VIEW";
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).setFamilyName(familyName).setColumnName(columnName).setMessage(msg).build().buildException();
            }
            case NO_OP: 
            case COLUMN_ALREADY_EXISTS: 
            case COLUMN_NOT_FOUND: {
                break;
            }
            case CONCURRENT_TABLE_MUTATION: {
                this.addTableToCache(result);
                if (logger.isDebugEnabled()) {
                    logger.debug(LogUtil.addCustomAnnotations("CONCURRENT_TABLE_MUTATION for table " + SchemaUtil.getTableName(schemaName, tableName), this.connection));
                }
                throw new ConcurrentTableMutationException(schemaName, tableName);
            }
            case NEWER_TABLE_FOUND: {
                throw new NewerTableAlreadyExistsException(schemaName, tableName, result.getTable());
            }
            case NO_PK_COLUMNS: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case TABLE_ALREADY_EXISTS: {
                break;
            }
            default: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEXPECTED_MUTATION_CODE).setSchemaName(schemaName).setTableName(tableName).setMessage("mutation code: " + (Object)((Object)mutationCode)).build().buildException();
            }
        }
        return mutationCode;
    }

    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta) throws SQLException {
        return this.incrementTableSeqNum(table, expectedType, columnCountDelta, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isImmutableRows, Boolean disableWAL, Boolean isMultiTenant, Boolean storeNulls) throws SQLException {
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        int totalColumnCount = table.getColumns().size() + (table.getBucketNum() == null ? 0 : -1);
        long seqNum = table.getSequenceNumber() + 1L;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try (PreparedStatement tableUpsert = this.connection.prepareStatement(MUTATE_TABLE);){
            tableUpsert.setString(1, tenantId);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, expectedType.getSerializedValue());
            tableUpsert.setLong(5, seqNum);
            tableUpsert.setInt(6, totalColumnCount + columnCountDelta);
            tableUpsert.execute();
        }
        if (isImmutableRows != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "IMMUTABLE_ROWS", isImmutableRows);
        }
        if (disableWAL != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "DISABLE_WAL", disableWAL);
        }
        if (isMultiTenant != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "MULTI_TENANT", isMultiTenant);
        }
        if (storeNulls != null) {
            this.mutateBooleanProperty(tenantId, schemaName, tableName, "STORE_NULLS", storeNulls);
        }
        return seqNum;
    }

    private void mutateBooleanProperty(String tenantId, String schemaName, String tableName, String propertyName, boolean propertyValue) throws SQLException {
        String updatePropertySql = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME," + propertyName + ") VALUES (?, ?, ?, ?)";
        PreparedStatement tableBoolUpsert = this.connection.prepareStatement(updatePropertySql);
        tableBoolUpsert.setString(1, tenantId);
        tableBoolUpsert.setString(2, schemaName);
        tableBoolUpsert.setString(3, tableName);
        tableBoolUpsert.setBoolean(4, propertyValue);
        tableBoolUpsert.execute();
    }

    public MutationState addColumn(AddColumnStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(false);
            PName tenantId = this.connection.getTenantId();
            TableName tableNameNode = statement.getTable().getName();
            String schemaName = tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            Boolean isImmutableRowsProp = null;
            Boolean multiTenantProp = null;
            Boolean disableWALProp = null;
            Boolean storeNullsProp = null;
            ListMultimap<String, Pair<String, Object>> stmtProperties = statement.getProps();
            HashMap<String, List<Pair<String, Object>>> properties = new HashMap<String, List<Pair<String, Object>>>(stmtProperties.size());
            PTable table = FromCompiler.getResolver(statement, this.connection).getTables().get(0).getTable();
            List<ColumnDef> columnDefs = statement.getColumnDefs();
            if (columnDefs == null) {
                columnDefs = Collections.emptyList();
            }
            for (String family : stmtProperties.keySet()) {
                List<Pair<String, Object>> propsList = stmtProperties.get(family);
                for (Pair<String, Object> prop : propsList) {
                    String propName = prop.getFirst();
                    if (!TableProperty.isPhoenixTableProperty(propName)) continue;
                    TableProperty.valueOf(propName).validate(true, !family.equals(""), table.getType());
                    if (propName.equals("IMMUTABLE_ROWS")) {
                        isImmutableRowsProp = (Boolean)prop.getSecond();
                        continue;
                    }
                    if (propName.equals("MULTI_TENANT")) {
                        multiTenantProp = (Boolean)prop.getSecond();
                        continue;
                    }
                    if (propName.equals("DISABLE_WAL")) {
                        disableWALProp = (Boolean)prop.getSecond();
                        continue;
                    }
                    if (!propName.equals("STORE_NULLS")) continue;
                    storeNullsProp = (Boolean)prop.getSecond();
                }
                properties.put(family, propsList);
            }
            boolean retried = false;
            boolean changingPhoenixTableProperty = false;
            while (true) {
                MetaDataProtocol.MetaDataMutationResult result;
                byte[] projectCF;
                byte[] emptyCF;
                Boolean multiTenant;
                block53: {
                    ColumnResolver resolver = FromCompiler.getResolver(statement, this.connection);
                    table = resolver.getTables().get(0).getTable();
                    int nIndexes = table.getIndexes().size();
                    int nNewColumns = columnDefs.size();
                    ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize((1 + nNewColumns) * (nIndexes + 1));
                    ArrayList columnMetaData = Lists.newArrayListWithExpectedSize(nNewColumns * (nIndexes + 1));
                    if (logger.isDebugEnabled()) {
                        logger.debug(LogUtil.addCustomAnnotations("Resolved table to " + table.getName().getString() + " with seqNum " + table.getSequenceNumber() + " at timestamp " + table.getTimeStamp() + " with " + table.getColumns().size() + " columns: " + table.getColumns(), this.connection));
                    }
                    int position = table.getColumns().size();
                    List<PColumn> currentPKs = table.getPKColumns();
                    PColumn lastPK = currentPKs.get(currentPKs.size() - 1);
                    if (lastPK.getDataType() == PVarbinary.INSTANCE || lastPK.getDataType().isArrayType()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    if (lastPK.isNullable() && lastPK.getDataType().isFixedWidth()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULLABLE_FIXED_WIDTH_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    Boolean isImmutableRows = null;
                    if (isImmutableRowsProp != null && isImmutableRowsProp.booleanValue() != table.isImmutableRows()) {
                        isImmutableRows = isImmutableRowsProp;
                        changingPhoenixTableProperty = true;
                    }
                    multiTenant = null;
                    if (multiTenantProp != null && multiTenantProp.booleanValue() != table.isMultiTenant()) {
                        multiTenant = multiTenantProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean disableWAL = null;
                    if (disableWALProp != null && disableWALProp.booleanValue() != table.isWALDisabled()) {
                        disableWAL = disableWALProp;
                        changingPhoenixTableProperty = true;
                    }
                    Boolean storeNulls = null;
                    if (storeNullsProp != null && storeNullsProp.booleanValue() != table.getStoreNulls()) {
                        storeNulls = storeNullsProp;
                        changingPhoenixTableProperty = true;
                    }
                    int numPkColumnsAdded = 0;
                    PreparedStatement colUpsert = this.connection.prepareStatement(INSERT_COLUMN_ALTER_TABLE);
                    ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(columnDefs.size());
                    LinkedHashSet<String> colFamiliesForPColumnsToBeAdded = new LinkedHashSet<String>();
                    LinkedHashSet<String> families = new LinkedHashSet<String>();
                    if (columnDefs.size() > 0) {
                        short nextKeySeq = SchemaUtil.getMaxKeySeq(table);
                        for (ColumnDef colDef : columnDefs) {
                            if (colDef != null && !colDef.isNull()) {
                                if (colDef.isPK()) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ADD_NOT_NULLABLE_COLUMN).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                            }
                            this.throwIfAlteringViewPK(colDef, table);
                            if (colDef != null && colDef.isRowTimestamp()) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.ROWTIMESTAMP_CREATE_ONLY).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                            }
                            PColumn column = this.newColumn(position++, colDef, PrimaryKeyConstraint.EMPTY, table.getDefaultFamilyName() == null ? null : table.getDefaultFamilyName().getString(), true);
                            columns.add(column);
                            String pkName = null;
                            Short keySeq = null;
                            if (column.getFamilyName() == null) {
                                ++numPkColumnsAdded;
                                pkName = table.getPKName() == null ? null : table.getPKName().getString();
                                nextKeySeq = (short)(nextKeySeq + 1);
                                keySeq = nextKeySeq;
                            } else {
                                families.add(column.getFamilyName().getString());
                            }
                            colFamiliesForPColumnsToBeAdded.add(column.getFamilyName() == null ? null : column.getFamilyName().getString());
                            this.addColumnMutation(schemaName, tableName, column, colUpsert, null, pkName, keySeq, table.getBucketNum() != null);
                        }
                        if (numPkColumnsAdded > 0) {
                            ArrayList<PColumn> pkColumns = Lists.newArrayListWithExpectedSize(table.getPKColumns().size() + numPkColumnsAdded);
                            pkColumns.addAll(table.getPKColumns());
                            for (int i = 0; i < columnDefs.size(); ++i) {
                                if (!columnDefs.get(i).isPK()) continue;
                                pkColumns.add((PColumn)columns.get(i));
                            }
                            int pkSlotPosition = table.getPKColumns().size() - 1;
                            for (PTable index : table.getIndexes()) {
                                short nextIndexKeySeq = SchemaUtil.getMaxKeySeq(index);
                                int indexPosition = index.getColumns().size();
                                for (int i = 0; i < columnDefs.size(); ++i) {
                                    ColumnDef colDef = columnDefs.get(i);
                                    if (!colDef.isPK()) continue;
                                    PDataType indexColDataType = IndexUtil.getIndexColumnDataType(colDef.isNull(), colDef.getDataType());
                                    ColumnName indexColName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, colDef.getColumnDefName().getColumnName()));
                                    RowKeyColumnExpression expression = new RowKeyColumnExpression((PDatum)columns.get(i), new RowKeyValueAccessor(pkColumns, ++pkSlotPosition));
                                    ColumnDef indexColDef = FACTORY.columnDef(indexColName, indexColDataType.getSqlTypeName(), colDef.isNull(), colDef.getMaxLength(), colDef.getScale(), true, colDef.getSortOrder(), ((Object)expression).toString(), colDef.isRowTimestamp());
                                    PColumn indexColumn = this.newColumn(indexPosition++, indexColDef, PrimaryKeyConstraint.EMPTY, null, true);
                                    nextIndexKeySeq = (short)(nextIndexKeySeq + 1);
                                    this.addColumnMutation(schemaName, index.getTableName().getString(), indexColumn, colUpsert, index.getParentTableName().getString(), index.getPKName() == null ? null : index.getPKName().getString(), nextIndexKeySeq, index.getBucketNum() != null);
                                }
                            }
                        }
                        columnMetaData.addAll(this.connection.getMutationState().toMutations().next().getSecond());
                        this.connection.rollback();
                    } else {
                        if (Boolean.FALSE.equals(isImmutableRows) && !table.getIndexes().isEmpty()) {
                            int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
                            if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            if (this.connection.getQueryServices().hasInvalidIndexConfiguration()) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                        }
                        if (Boolean.TRUE.equals(multiTenant)) {
                            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, table.getPKColumns(), table.getBucketNum() != null, multiTenant);
                        }
                    }
                    if (numPkColumnsAdded > 0 && !table.getIndexes().isEmpty()) {
                        for (PTable index : table.getIndexes()) {
                            this.incrementTableSeqNum(index, index.getType(), 1);
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                        this.connection.rollback();
                    }
                    long seqNum = table.getSequenceNumber();
                    if (changingPhoenixTableProperty || columnDefs.size() > 0) {
                        seqNum = this.incrementTableSeqNum(table, statement.getTableType(), 1, isImmutableRows, disableWAL, multiTenant, storeNulls);
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                        this.connection.rollback();
                    }
                    Collections.reverse(tableMetaData);
                    tableMetaData.addAll(columnMetaData);
                    byte[] family = families.size() > 0 ? ((String)families.iterator().next()).getBytes() : null;
                    emptyCF = null;
                    projectCF = null;
                    if (table.getType() != PTableType.VIEW && family != null) {
                        if (table.getColumnFamilies().isEmpty()) {
                            emptyCF = family;
                        } else {
                            try {
                                table.getColumnFamily(family);
                            }
                            catch (ColumnFamilyNotFoundException e) {
                                projectCF = family;
                                emptyCF = SchemaUtil.getEmptyColumnFamily(table);
                            }
                        }
                    }
                    result = this.connection.getQueryServices().addColumn(tableMetaData, table, properties, colFamiliesForPColumnsToBeAdded);
                    try {
                        MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                        if (code == MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS) {
                            this.addTableToCache(result);
                            if (!statement.ifNotExists()) {
                                throw new ColumnAlreadyExistsException(schemaName, tableName, SchemaUtil.findExistingColumn(result.getTable(), columns));
                            }
                            MutationState i = new MutationState(0L, this.connection);
                            return i;
                        }
                        if (numPkColumnsAdded != 0 && !table.getIndexes().isEmpty()) break block53;
                    }
                    catch (ConcurrentTableMutationException e) {
                        if (retried) {
                            throw e;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(LogUtil.addCustomAnnotations("Caught ConcurrentTableMutationException for table " + SchemaUtil.getTableName(schemaName, tableName) + ". Will try again...", this.connection));
                        }
                        retried = true;
                        continue;
                    }
                    this.connection.addColumn(tenantId, SchemaUtil.getTableName(schemaName, tableName), columns, result.getMutationTime(), seqNum, isImmutableRows == null ? table.isImmutableRows() : isImmutableRows.booleanValue(), disableWAL == null ? table.isWALDisabled() : disableWAL.booleanValue(), multiTenant == null ? table.isMultiTenant() : multiTenant.booleanValue(), storeNulls == null ? table.getStoreNulls() : storeNulls.booleanValue());
                }
                if (table.getType() == PTableType.TABLE && Boolean.FALSE.equals(multiTenant) && MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName())) {
                    this.connection.setAutoCommit(true);
                    MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName());
                    if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true)) {
                        Long scn = this.connection.getSCN();
                        long ts = scn == null ? result.getMutationTime() : scn.longValue();
                        String viewIndexSchemaName = MetaDataUtil.getViewIndexSchemaName(schemaName);
                        String viewIndexTableName = MetaDataUtil.getViewIndexTableName(tableName);
                        PTableImpl viewIndexTable = new PTableImpl(null, viewIndexSchemaName, viewIndexTableName, ts, table.getColumnFamilies());
                        List<TableRef> tableRefs = Collections.singletonList(new TableRef(null, viewIndexTable, ts, false));
                        MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.emptyList(), ts);
                        this.connection.getQueryServices().updateData(plan);
                    }
                }
                if (emptyCF != null) {
                    Long scn = this.connection.getSCN();
                    this.connection.setAutoCommit(true);
                    long ts = scn == null ? result.getMutationTime() : scn.longValue();
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(new TableRef(null, table, ts, false)), emptyCF, projectCF, null, ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
                MutationState mutationState = new MutationState(0L, this.connection);
                return mutationState;
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String dropColumnMutations(PTable table, List<PColumn> columnsToDrop, List<Mutation> tableMetaData) throws SQLException {
        String tenantId = this.connection.getTenantId() == null ? "" : this.connection.getTenantId().getString();
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        String familyName = null;
        StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.\"CATALOG\" WHERE ");
        buf.append("(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME, COLUMN_FAMILY) IN (");
        for (PColumn columnToDrop : columnsToDrop) {
            buf.append("('" + tenantId + "'");
            buf.append(",'" + schemaName + "'");
            buf.append(",'" + tableName + "'");
            buf.append(",'" + columnToDrop.getName().getString() + "'");
            buf.append(",'" + (columnToDrop.getFamilyName() == null ? "" : columnToDrop.getFamilyName().getString()) + "'),");
        }
        buf.setCharAt(buf.length() - 1, ')');
        this.connection.createStatement().execute(buf.toString());
        Collections.sort(columnsToDrop, new Comparator<PColumn>(){

            @Override
            public int compare(PColumn left, PColumn right) {
                return Ints.compare(left.getPosition(), right.getPosition());
            }
        });
        boolean isSalted = table.getBucketNum() != null;
        int columnsToDropIndex = 0;
        PreparedStatement colUpdate = this.connection.prepareStatement(UPDATE_COLUMN_POSITION);
        colUpdate.setString(1, tenantId);
        colUpdate.setString(2, schemaName);
        colUpdate.setString(3, tableName);
        for (int i = columnsToDrop.get(columnsToDropIndex).getPosition() + 1; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (columnsToDrop.contains(column)) {
                ++columnsToDropIndex;
                continue;
            }
            colUpdate.setString(4, column.getName().getString());
            colUpdate.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
            colUpdate.setInt(6, column.getPosition() - columnsToDropIndex - (isSalted ? 1 : 0));
            colUpdate.execute();
        }
        return familyName;
    }

    private static byte[] getNewEmptyColumnFamilyOrNull(PTable table, PColumn columnToDrop) {
        if (table.getType() != PTableType.VIEW && !SchemaUtil.isPKColumn(columnToDrop) && table.getColumnFamilies().get(0).getName().equals(columnToDrop.getFamilyName()) && table.getColumnFamilies().get(0).getColumns().size() == 1) {
            return SchemaUtil.getEmptyColumnFamily(table.getDefaultFamilyName(), table.getColumnFamilies().subList(1, table.getColumnFamilies().size()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutationState dropColumn(DropColumnStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            MetaDataProtocol.MetaDataMutationResult result;
            MutationState mutationState;
            ArrayList<TableRef> indexesToDrop;
            ArrayList<ColumnRef> columnsToDrop;
            PTable table;
            this.connection.setAutoCommit(false);
            PName tenantId = this.connection.getTenantId();
            TableName tableNameNode = statement.getTable().getName();
            String schemaName = tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            boolean retried = false;
            while (true) {
                Object tableContainingColumnToDrop;
                ColumnResolver resolver = FromCompiler.getResolver(statement, this.connection);
                table = resolver.getTables().get(0).getTable();
                List<ColumnName> columnRefs = statement.getColumnRefs();
                if (columnRefs == null) {
                    columnRefs = Lists.newArrayListWithCapacity(0);
                }
                TableRef tableRef = null;
                columnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size() + table.getIndexes().size());
                indexesToDrop = Lists.newArrayListWithExpectedSize(table.getIndexes().size());
                ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize((table.getIndexes().size() + 1) * (1 + table.getColumns().size() - columnRefs.size()));
                ArrayList<PColumn> tableColumnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size());
                for (ColumnName column : columnRefs) {
                    ColumnRef columnRef = null;
                    try {
                        columnRef = resolver.resolveColumn(null, column.getFamilyName(), column.getColumnName());
                    }
                    catch (ColumnNotFoundException e) {
                        if (!statement.ifExists()) throw e;
                        mutationState = new MutationState(0L, this.connection);
                        this.connection.setAutoCommit(wasAutoCommit);
                        return mutationState;
                    }
                    tableRef = columnRef.getTableRef();
                    PColumn columnToDrop = columnRef.getColumn();
                    tableColumnsToDrop.add(columnToDrop);
                    if (SchemaUtil.isPKColumn(columnToDrop)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DROP_PK).setColumnName(columnToDrop.getName().getString()).build().buildException();
                    }
                    columnsToDrop.add(new ColumnRef(tableRef, columnToDrop.getPosition()));
                }
                this.dropColumnMutations(table, tableColumnsToDrop, tableMetaData);
                for (PTable index : table.getIndexes()) {
                    IndexMaintainer indexMaintainer = index.getIndexMaintainer(table, this.connection);
                    Set<ColumnReference> indexColumns = indexMaintainer.getIndexedColumns();
                    Set<ColumnReference> coveredColumns = indexMaintainer.getCoverededColumns();
                    ArrayList<PColumn> indexColumnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size());
                    for (PColumn columnToDrop : tableColumnsToDrop) {
                        ColumnReference columnToDropRef = new ColumnReference(columnToDrop.getFamilyName().getBytes(), columnToDrop.getName().getBytes());
                        if (indexColumns.contains(columnToDropRef)) {
                            indexesToDrop.add(new TableRef(index));
                            continue;
                        }
                        if (!coveredColumns.contains(columnToDropRef)) continue;
                        String indexColumnName = IndexUtil.getIndexColumnName(columnToDrop);
                        indexColumnsToDrop.add(index.getColumn(indexColumnName));
                    }
                    if (indexColumnsToDrop.isEmpty()) continue;
                    this.incrementTableSeqNum(index, index.getType(), -1);
                    this.dropColumnMutations(index, indexColumnsToDrop, tableMetaData);
                }
                tableMetaData.addAll((Collection<Mutation>)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
                long seqNum = this.incrementTableSeqNum(table, statement.getTableType(), -1);
                tableMetaData.addAll((Collection<Mutation>)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
                Collections.reverse(tableMetaData);
                for (ColumnRef columnRefToDrop : columnsToDrop) {
                    tableContainingColumnToDrop = columnRefToDrop.getTable();
                    byte[] emptyCF = MetaDataClient.getNewEmptyColumnFamilyOrNull((PTable)tableContainingColumnToDrop, columnRefToDrop.getColumn());
                    if (emptyCF == null) continue;
                    try {
                        tableContainingColumnToDrop.getColumnFamily(emptyCF);
                    }
                    catch (ColumnFamilyNotFoundException e) {
                        byte[] tenantIdBytes;
                        HashMap<String, List<Pair<String, Object>>> family = new HashMap<String, List<Pair<String, Object>>>(1);
                        family.put(Bytes.toString(emptyCF), Collections.emptyList());
                        byte[] byArray = tenantIdBytes = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
                        if (tenantIdBytes == null) {
                            tenantIdBytes = ByteUtil.EMPTY_BYTE_ARRAY;
                        }
                        this.connection.getQueryServices().addColumn(Collections.singletonList(new Put(SchemaUtil.getTableKey(tenantIdBytes, tableContainingColumnToDrop.getSchemaName().getBytes(), tableContainingColumnToDrop.getTableName().getBytes()))), (PTable)tableContainingColumnToDrop, family, Sets.newHashSet(Bytes.toString(emptyCF)));
                    }
                }
                result = this.connection.getQueryServices().dropColumn(tableMetaData, statement.getTableType());
                try {
                    MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                    if (code == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND) {
                        this.addTableToCache(result);
                        if (!statement.ifExists()) {
                            throw new ColumnNotFoundException(schemaName, tableName, Bytes.toString(result.getFamilyName()), Bytes.toString(result.getColumnName()));
                        }
                        tableContainingColumnToDrop = new MutationState(0L, this.connection);
                        return tableContainingColumnToDrop;
                    }
                    if (tableColumnsToDrop.size() <= 0 || !indexesToDrop.isEmpty()) break;
                    this.connection.removeColumn(tenantId, SchemaUtil.getTableName(schemaName, tableName), tableColumnsToDrop, result.getMutationTime(), seqNum);
                }
                catch (ConcurrentTableMutationException e) {
                    if (retried) {
                        throw e;
                    }
                    table = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
                    retried = true;
                    continue;
                }
                break;
            }
            if (table.getType() != PTableType.VIEW) {
                MutationState state = null;
                this.connection.setAutoCommit(true);
                Long scn = this.connection.getSCN();
                long ts = scn == null ? result.getMutationTime() : scn.longValue();
                PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
                boolean dropMetaData = this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetaData) {
                    this.connection.getQueryServices().updateData(compiler.compile(indexesToDrop, null, null, Collections.emptyList(), ts));
                }
                Iterator iterator = columnsToDrop.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        iterator = state;
                        return iterator;
                    }
                    ColumnRef droppedColumnRef = (ColumnRef)iterator.next();
                    droppedColumnRef = droppedColumnRef.cloneAtTimestamp(ts);
                    TableRef droppedColumnTableRef = droppedColumnRef.getTableRef();
                    PColumn droppedColumn = droppedColumnRef.getColumn();
                    MutationPlan plan = compiler.compile(Collections.singletonList(droppedColumnTableRef), MetaDataClient.getNewEmptyColumnFamilyOrNull(droppedColumnTableRef.getTable(), droppedColumn), null, Collections.singletonList(droppedColumn), ts);
                    state = this.connection.getQueryServices().updateData(plan);
                }
            }
            mutationState = new MutationState(0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState alterIndex(AlterIndexStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            String dataTableName = statement.getTableName();
            String schemaName = statement.getTable().getName().getSchemaName();
            String indexName = statement.getTable().getName().getTableName();
            PIndexState newIndexState = statement.getIndexState();
            if (newIndexState == PIndexState.REBUILD) {
                newIndexState = PIndexState.BUILDING;
            }
            this.connection.setAutoCommit(false);
            TableRef indexRef = FromCompiler.getResolver(statement, this.connection).getTables().get(0);
            try (Statement tableUpsert = null;){
                tableUpsert = newIndexState == PIndexState.ACTIVE ? this.connection.prepareStatement(UPDATE_INDEX_STATE_TO_ACTIVE) : this.connection.prepareStatement(UPDATE_INDEX_STATE);
                tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                tableUpsert.setString(2, schemaName);
                tableUpsert.setString(3, indexName);
                tableUpsert.setString(4, newIndexState.getSerializedValue());
                if (newIndexState == PIndexState.ACTIVE) {
                    tableUpsert.setLong(5, 0L);
                }
                tableUpsert.execute();
            }
            List<Mutation> tableMetadata = this.connection.getMutationState().toMutations().next().getSecond();
            this.connection.rollback();
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().updateIndexState(tableMetadata, dataTableName);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                throw new TableNotFoundException(schemaName, indexName);
            }
            if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage(" currentState=" + (Object)((Object)indexRef.getTable().getIndexState()) + ". requestedState=" + (Object)((Object)newIndexState)).setSchemaName(schemaName).setTableName(indexName).build().buildException();
            }
            if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() != null) {
                this.addTableToCache(result);
            }
            if (newIndexState == PIndexState.BUILDING) {
                PTable index = indexRef.getTable();
                Long scn = this.connection.getSCN();
                long ts = scn == null ? Long.MAX_VALUE : scn;
                MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(indexRef), null, null, Collections.emptyList(), ts);
                this.connection.getQueryServices().updateData(plan);
                NamedTableNode dataTableNode = NamedTableNode.create(null, TableName.create(schemaName, dataTableName), Collections.emptyList());
                this.connection.setAutoCommit(true);
                if (this.connection.getSCN() != null) {
                    MutationState mutationState = this.buildIndexAtTimeStamp(index, dataTableNode);
                    return mutationState;
                }
                TableRef dataTableRef = FromCompiler.getResolver(dataTableNode, this.connection).getTables().get(0);
                MutationState mutationState = this.buildIndex(index, dataTableRef);
                return mutationState;
            }
            MutationState mutationState = new MutationState(1L, this.connection);
            return mutationState;
        }
        catch (TableNotFoundException e) {
            if (!statement.ifExists()) {
                throw e;
            }
            MutationState mutationState = new MutationState(0L, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private PTable addTableToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        this.addIndexesFromPhysicalTable(result);
        PTable table = result.getTable();
        this.connection.addTable(table);
        return table;
    }

    private List<PFunction> addFunctionToCache(MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        for (PFunction function : result.getFunctions()) {
            this.connection.addFunction(function);
        }
        return result.getFunctions();
    }

    private void throwIfAlteringViewPK(ColumnDef col, PTable table) throws SQLException {
        if (col != null && col.isPK() && table.getType() == PTableType.VIEW) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MODIFY_VIEW_PK).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).setColumnName(col.getColumnDefName().getColumnName()).build().buildException();
        }
    }

    public PTableStats getTableStats(PTable table) throws SQLException {
        boolean isSharedIndex;
        boolean bl = isSharedIndex = table.getViewIndexId() != null;
        if (isSharedIndex) {
            return this.connection.getQueryServices().getTableStats(table.getPhysicalName().getBytes(), this.getClientTimeStamp());
        }
        boolean isView = table.getType() == PTableType.VIEW;
        String physicalName = table.getPhysicalName().getString();
        if (isView && table.getViewType() != PTable.ViewType.MAPPED) {
            try {
                return this.connection.getMetaDataCache().getTable(new PTableKey(null, physicalName)).getTableStats();
            }
            catch (TableNotFoundException e) {
                String physicalSchemaName = SchemaUtil.getSchemaNameFromFullName(physicalName);
                String physicalTableName = SchemaUtil.getTableNameFromFullName(physicalName);
                MetaDataProtocol.MetaDataMutationResult result = this.updateCache(null, physicalSchemaName, physicalTableName, false);
                if (result.getTable() == null) {
                    throw new TableNotFoundException(physicalSchemaName, physicalTableName);
                }
                return result.getTable().getTableStats();
            }
        }
        return table.getTableStats();
    }
}

