/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.util.PhoenixContextExecutor;

public interface ConfigurationFactory {
    public Configuration getConfiguration();

    public Configuration getConfiguration(Configuration var1);

    public static class ConfigurationFactoryImpl
    implements ConfigurationFactory {
        @Override
        public Configuration getConfiguration() {
            return PhoenixContextExecutor.callWithoutPropagation(new Callable<Configuration>(){

                @Override
                public Configuration call() throws Exception {
                    return HBaseConfiguration.create();
                }
            });
        }

        @Override
        public Configuration getConfiguration(final Configuration conf) {
            return PhoenixContextExecutor.callWithoutPropagation(new Callable<Configuration>(){

                @Override
                public Configuration call() throws Exception {
                    return HBaseConfiguration.create(conf);
                }
            });
        }
    }
}

