/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.util.ReadOnlyProps;

public abstract class BaseQueryServicesImpl
implements QueryServices {
    private final ThreadPoolExecutor executor;
    private final MemoryManager memoryManager;
    private final ReadOnlyProps props;
    private final QueryOptimizer queryOptimizer;

    public BaseQueryServicesImpl(ReadOnlyProps defaultProps, QueryServicesOptions options) {
        this.executor = JobManager.createThreadPoolExec(options.getKeepAliveMs(), options.getThreadPoolSize(), options.getQueueSize(), options.isMetricsEnabled());
        this.memoryManager = new GlobalMemoryManager(Runtime.getRuntime().maxMemory() * (long)options.getMaxMemoryPerc() / 100L, options.getMaxMemoryWaitMs());
        this.props = options.getProps(defaultProps);
        this.queryOptimizer = new QueryOptimizer(this);
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public final ReadOnlyProps getProps() {
        return this.props;
    }

    @Override
    public void close() {
    }

    @Override
    public QueryOptimizer getOptimizer() {
        return this.queryOptimizer;
    }
}

