/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnDefInPkConstraint;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.schema.SortOrder;

public class PrimaryKeyConstraint
extends NamedNode {
    public static final PrimaryKeyConstraint EMPTY = new PrimaryKeyConstraint(null, Collections.emptyList());
    private final List<Pair<ColumnName, SortOrder>> columns;
    private final Map<ColumnName, Pair<ColumnName, SortOrder>> columnNameToSortOrder;
    private final Map<ColumnName, Pair<ColumnName, Boolean>> columnNameToRowTimestamp;
    private final int numColumnsWithRowTimestamp;

    PrimaryKeyConstraint(String name, List<ColumnDefInPkConstraint> columnDefs) {
        super(name);
        if (columnDefs == null) {
            this.columns = Collections.emptyList();
            this.columnNameToSortOrder = Collections.emptyMap();
            this.columnNameToRowTimestamp = Collections.emptyMap();
            this.numColumnsWithRowTimestamp = 0;
        } else {
            int numRowTimestampCols = 0;
            ArrayList<Pair<ColumnName, SortOrder>> l = new ArrayList<Pair<ColumnName, SortOrder>>(columnDefs.size());
            this.columnNameToSortOrder = Maps.newHashMapWithExpectedSize(columnDefs.size());
            this.columnNameToRowTimestamp = Maps.newHashMapWithExpectedSize(columnDefs.size());
            for (ColumnDefInPkConstraint colDef : columnDefs) {
                Pair<ColumnName, SortOrder> p = Pair.newPair(colDef.getColumnName(), colDef.getSortOrder());
                l.add(p);
                this.columnNameToSortOrder.put(colDef.getColumnName(), p);
                this.columnNameToRowTimestamp.put(colDef.getColumnName(), Pair.newPair(colDef.getColumnName(), colDef.isRowTimestamp()));
                if (!colDef.isRowTimestamp()) continue;
                ++numRowTimestampCols;
            }
            this.numColumnsWithRowTimestamp = numRowTimestampCols;
            this.columns = ImmutableList.copyOf(l);
        }
    }

    public List<Pair<ColumnName, SortOrder>> getColumnNames() {
        return this.columns;
    }

    public Pair<ColumnName, SortOrder> getColumnWithSortOrder(ColumnName columnName) {
        return this.columnNameToSortOrder.get(columnName);
    }

    public boolean isColumnRowTimestamp(ColumnName columnName) {
        return this.columnNameToRowTimestamp.get(columnName) != null && this.columnNameToRowTimestamp.get(columnName).getSecond() == Boolean.TRUE;
    }

    public boolean contains(ColumnName columnName) {
        return this.columnNameToSortOrder.containsKey(columnName);
    }

    public int getNumColumnsWithRowTimestamp() {
        return this.numColumnsWithRowTimestamp;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

