/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNodeVisitor;

public class NamedTableNode
extends ConcreteTableNode {
    private final List<ColumnDef> dynColumns;

    public static NamedTableNode create(String alias, TableName name, List<ColumnDef> dynColumns) {
        return new NamedTableNode(alias, name, dynColumns);
    }

    NamedTableNode(String alias, TableName name) {
        super(alias, name);
        this.dynColumns = Collections.emptyList();
    }

    NamedTableNode(String alias, TableName name, List<ColumnDef> dynColumns) {
        super(alias, name);
        this.dynColumns = dynColumns != null ? ImmutableList.copyOf(dynColumns) : Collections.emptyList();
    }

    @Override
    public <T> T accept(TableNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public List<ColumnDef> getDynamicColumns() {
        return this.dynColumns;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(this.getName().toString());
        if (!this.dynColumns.isEmpty()) {
            buf.append('(');
            for (ColumnDef def : this.dynColumns) {
                buf.append(def);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
            buf.append(')');
        }
        if (this.getAlias() != null) {
            buf.append(" " + this.getAlias());
        }
        buf.append(' ');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dynColumns == null ? 0 : this.dynColumns.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedTableNode other = (NamedTableNode)obj;
        return !(this.dynColumns == null ? other.dynColumns != null : !this.dynColumns.equals(other.dynColumns));
    }
}

