/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class CaseParseNode
extends CompoundParseNode {
    CaseParseNode(List<ParseNode> children) {
        super(children);
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append("CASE ");
        List<ParseNode> children = this.getChildren();
        for (int i = 0; i < children.size() - 1; i += 2) {
            buf.append("WHEN ");
            children.get(i + 1).toSQL(resolver, buf);
            buf.append(" THEN ");
            children.get(i).toSQL(resolver, buf);
        }
        if (children.size() % 2 != 0) {
            buf.append(" ELSE ");
            children.get(children.size() - 1).toSQL(resolver, buf);
        }
        buf.append(" END ");
    }
}

