/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.util.SchemaUtil;

public class AliasedNode {
    private final String alias;
    private final ParseNode node;
    private final boolean isCaseSensitve;

    public AliasedNode(String alias, ParseNode node) {
        this.isCaseSensitve = alias != null && SchemaUtil.isCaseSensitive(alias);
        this.alias = alias == null ? null : SchemaUtil.normalizeIdentifier(alias);
        this.node = node;
    }

    public String getAlias() {
        return this.alias;
    }

    public ParseNode getNode() {
        return this.node;
    }

    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        this.node.toSQL(resolver, buf);
        if (this.alias != null) {
            buf.append(' ');
            if (this.isCaseSensitve) {
                buf.append('\"');
            }
            buf.append(this.alias);
            if (this.isCaseSensitve) {
                buf.append('\"');
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AliasedNode other = (AliasedNode)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }

    public boolean isCaseSensitve() {
        return this.isCaseSensitve;
    }
}

