/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.phoenix.monitoring.Metric;

@ThreadSafe
class Counter
implements Metric {
    private final AtomicLong counter;
    private final String name;
    private final String description;

    public Counter(String name, String description) {
        this.name = name;
        this.description = description;
        this.counter = new AtomicLong(0L);
    }

    public long increment() {
        return this.counter.incrementAndGet();
    }

    public long getCurrentCount() {
        return this.counter.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void reset() {
        this.counter.set(0L);
    }

    public String toString() {
        return "Name: " + this.name + ", Current count: " + this.counter.get();
    }

    @Override
    public String getCurrentMetricState() {
        return this.toString();
    }

    @Override
    public long getNumberOfSamples() {
        return this.getCurrentCount();
    }

    @Override
    public long getTotalSum() {
        return this.getCurrentCount();
    }
}

