/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;

public class PhoenixRecordWriter<T extends DBWritable>
extends RecordWriter<NullWritable, T> {
    private static final Log LOG = LogFactory.getLog(PhoenixRecordWriter.class);
    private final Connection conn;
    private final PreparedStatement statement;
    private final long batchSize;
    private long numRecords = 0L;

    public PhoenixRecordWriter(Configuration configuration) throws SQLException {
        this.conn = ConnectionUtil.getOutputConnection(configuration);
        this.batchSize = PhoenixConfigurationUtil.getBatchSize(configuration);
        String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
        this.statement = this.conn.prepareStatement(upsertQuery);
    }

    @Override
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.statement.executeBatch();
            this.conn.commit();
        }
        catch (SQLException e) {
            LOG.error("SQLException while performing the commit for the task.");
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.statement.close();
                this.conn.close();
            }
            catch (SQLException ex) {
                LOG.error("SQLException while closing the connection for the task.");
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void write(NullWritable n, T record) throws IOException, InterruptedException {
        try {
            record.write(this.statement);
            ++this.numRecords;
            this.statement.addBatch();
            if (this.numRecords % this.batchSize == 0L) {
                LOG.debug("commit called on a batch of size : " + this.batchSize);
                this.statement.executeBatch();
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Exception while committing to database.", e);
        }
    }
}

