/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PDataType;

public class PhoenixParameterMetaData
implements ParameterMetaData {
    private final PDatum[] params;
    private static final PDatum EMPTY_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public PDataType getDataType() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    public static final PhoenixParameterMetaData EMPTY_PARAMETER_META_DATA = new PhoenixParameterMetaData(0);

    public PhoenixParameterMetaData(int paramCount) {
        this.params = new PDatum[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.params[i] = EMPTY_DATUM;
        }
    }

    private PDatum getParam(int index) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_INDEX_OUT_OF_BOUND).setMessage("The index is " + index + ". Must be between 1 and " + this.params.length).build().buildException();
        }
        PDatum param = this.params[index - 1];
        if (param == EMPTY_DATUM) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.PARAM_VALUE_UNBOUND).setMessage("Parameter at index " + index + " is unbound").build().buildException();
        }
        return param;
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        PDatum datum = this.getParam(index);
        PDataType type = datum == null ? null : datum.getDataType();
        return type == null ? null : type.getJavaClassName();
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.length;
    }

    @Override
    public int getParameterMode(int index) throws SQLException {
        return 1;
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        return this.getParam(index).getDataType().getSqlType();
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        return this.getParam(index).getDataType().getSqlTypeName();
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int index) throws SQLException {
        return 0;
    }

    @Override
    public int isNullable(int index) throws SQLException {
        return this.getParam(index).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        Class clazz = this.getParam(index).getDataType().getJavaClass();
        return Number.class.isInstance(clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }

    public void addParam(BindParseNode bind, PDatum datum) throws SQLException {
        PDatum bindDatum = this.params[bind.getIndex()];
        if (bindDatum != null && bindDatum.getDataType() != null && !datum.getDataType().isCoercibleTo(bindDatum.getDataType())) {
            throw TypeMismatchException.newException(datum.getDataType(), bindDatum.getDataType());
        }
        this.params[bind.getIndex()] = datum;
    }
}

