/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.BaseResultIterators;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialIterators
extends BaseResultIterators {
    private static final Logger logger = LoggerFactory.getLogger(SerialIterators.class);
    private static final String NAME = "SERIAL";
    private final ParallelIteratorFactory iteratorFactory;

    public SerialIterators(QueryPlan plan, Integer perScanLimit, ParallelIteratorFactory iteratorFactory, ParallelScanGrouper scanGrouper) throws SQLException {
        super(plan, perScanLimit, scanGrouper);
        Preconditions.checkArgument(perScanLimit != null);
        this.iteratorFactory = iteratorFactory;
    }

    @Override
    protected void submitWork(List<List<Scan>> nestedScans, List<List<Pair<Scan, Future<PeekingResultIterator>>>> nestedFutures, final Queue<PeekingResultIterator> allIterators, int estFlattenedSize) {
        ThreadPoolExecutor executor = this.context.getConnection().getQueryServices().getExecutor();
        for (final List<Scan> scans : nestedScans) {
            Scan firstScan = scans.get(0);
            Scan lastScan = scans.get(scans.size() - 1);
            Scan overallScan = ScanUtil.newScan(firstScan);
            overallScan.setStopRow(lastScan.getStopRow());
            Future<PeekingResultIterator> future = executor.submit(Tracing.wrap(new JobManager.JobCallable<PeekingResultIterator>(){

                @Override
                public PeekingResultIterator call() throws Exception {
                    ArrayList<PeekingResultIterator> concatIterators = Lists.newArrayListWithExpectedSize(scans.size());
                    for (Scan scan : scans) {
                        long startTime = System.currentTimeMillis();
                        TableResultIterator scanner = new TableResultIterator(SerialIterators.this.context, SerialIterators.this.tableRef, scan, TableResultIterator.ScannerCreation.DELAYED);
                        if (logger.isDebugEnabled()) {
                            logger.debug(LogUtil.addCustomAnnotations("Id: " + SerialIterators.this.scanId + ", Time: " + (System.currentTimeMillis() - startTime) + "ms, Scan: " + scan, ScanUtil.getCustomAnnotations(scan)));
                        }
                        concatIterators.add(SerialIterators.this.iteratorFactory.newIterator(SerialIterators.this.context, scanner, scan));
                    }
                    PeekingResultIterator concatIterator = ConcatResultIterator.newIterator(concatIterators);
                    allIterators.add(concatIterator);
                    return concatIterator;
                }

                @Override
                public Object getJobId() {
                    return SerialIterators.this;
                }
            }, "Serial scanner for table: " + this.tableRef.getTable().getName().getString()));
            nestedFutures.add(Collections.singletonList(new Pair<Scan, Future<PeekingResultIterator>>(overallScan, future)));
        }
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

