/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import com.google.common.collect.MinMaxPriorityQueue;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.iterate.MappedByteBufferQueue;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ResultUtil;

public class MappedByteBufferSortedQueue
extends MappedByteBufferQueue<OrderedResultIterator.ResultEntry> {
    private Comparator<OrderedResultIterator.ResultEntry> comparator;
    private final int limit;

    public MappedByteBufferSortedQueue(Comparator<OrderedResultIterator.ResultEntry> comparator, Integer limit, int thresholdBytes) throws IOException {
        super(thresholdBytes);
        this.comparator = comparator;
        this.limit = limit == null ? -1 : limit;
    }

    @Override
    protected MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry> createSegmentQueue(int index, int thresholdBytes) {
        return new MappedByteBufferResultEntryPriorityQueue(index, thresholdBytes, this.limit, this.comparator);
    }

    @Override
    protected Comparator<MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry>> getSegmentQueueComparator() {
        return new Comparator<MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry>>(){

            @Override
            public int compare(MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry> q1, MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry> q2) {
                return MappedByteBufferSortedQueue.this.comparator.compare(q1.peek(), q2.peek());
            }
        };
    }

    private static class MappedByteBufferResultEntryPriorityQueue
    extends MappedByteBufferQueue.MappedByteBufferSegmentQueue<OrderedResultIterator.ResultEntry> {
        private MinMaxPriorityQueue<OrderedResultIterator.ResultEntry> results = null;

        public MappedByteBufferResultEntryPriorityQueue(int index, int thresholdBytes, int limit, Comparator<OrderedResultIterator.ResultEntry> comparator) {
            super(index, thresholdBytes, limit >= 0);
            this.results = limit < 0 ? MinMaxPriorityQueue.orderedBy(comparator).create() : MinMaxPriorityQueue.orderedBy(comparator).maximumSize(limit).create();
        }

        @Override
        protected Queue<OrderedResultIterator.ResultEntry> getInMemoryQueue() {
            return this.results;
        }

        @Override
        protected int sizeOf(OrderedResultIterator.ResultEntry e) {
            return this.sizeof(e.sortKeys) + this.sizeof(this.toKeyValues(e));
        }

        @Override
        protected void writeToBuffer(MappedByteBuffer buffer, OrderedResultIterator.ResultEntry e) {
            int totalLen = 0;
            List<KeyValue> keyValues = this.toKeyValues(e);
            for (KeyValue kv : keyValues) {
                totalLen += kv.getLength() + 4;
            }
            buffer.putInt(totalLen);
            for (KeyValue kv : keyValues) {
                buffer.putInt(kv.getLength());
                buffer.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
            ImmutableBytesWritable[] sortKeys = e.sortKeys;
            buffer.putInt(sortKeys.length);
            for (ImmutableBytesWritable sortKey : sortKeys) {
                if (sortKey != null) {
                    buffer.putInt(sortKey.getLength());
                    buffer.put(sortKey.get(), sortKey.getOffset(), sortKey.getLength());
                    continue;
                }
                buffer.putInt(0);
            }
        }

        @Override
        protected OrderedResultIterator.ResultEntry readFromBuffer(MappedByteBuffer buffer) {
            int length = buffer.getInt();
            if (length < 0) {
                return null;
            }
            byte[] rb = new byte[length];
            buffer.get(rb);
            Result result = ResultUtil.toResult(new ImmutableBytesWritable(rb));
            ResultTuple rt = new ResultTuple(result);
            int sortKeySize = buffer.getInt();
            ImmutableBytesWritable[] sortKeys = new ImmutableBytesWritable[sortKeySize];
            for (int i = 0; i < sortKeySize; ++i) {
                int contentLength = buffer.getInt();
                if (contentLength > 0) {
                    byte[] sortKeyContent = new byte[contentLength];
                    buffer.get(sortKeyContent);
                    sortKeys[i] = new ImmutableBytesWritable(sortKeyContent);
                    continue;
                }
                sortKeys[i] = null;
            }
            return new OrderedResultIterator.ResultEntry(sortKeys, rt);
        }

        private List<KeyValue> toKeyValues(OrderedResultIterator.ResultEntry entry) {
            Tuple result = entry.getResult();
            int size = result.size();
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(size);
            for (int i = 0; i < size; ++i) {
                kvs.add(KeyValueUtil.ensureKeyValue(result.getValue(i)));
            }
            return kvs;
        }

        private int sizeof(List<KeyValue> kvs) {
            int size = 4;
            for (KeyValue kv : kvs) {
                size += kv.getLength();
                size += 4;
            }
            return size;
        }

        private int sizeof(ImmutableBytesWritable[] sortKeys) {
            int size = 4;
            if (sortKeys != null) {
                for (ImmutableBytesWritable sortKey : sortKeys) {
                    if (sortKey != null) {
                        size += sortKey.getLength();
                    }
                    size += 4;
                }
            }
            return size;
        }
    }
}

