/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;

public class FilterResultIterator
extends LookAheadResultIterator {
    private final ResultIterator delegate;
    private final Expression expression;
    private final ImmutableBytesWritable ptr = new ImmutableBytesWritable();

    public FilterResultIterator(ResultIterator delegate, Expression expression) {
        if (delegate instanceof AggregatingResultIterator) {
            throw new IllegalArgumentException("FilterResultScanner may not be used with an aggregate delegate. Use phoenix.iterate.FilterAggregateResultScanner instead");
        }
        this.delegate = delegate;
        this.expression = expression;
        if (expression.getDataType() != PBoolean.INSTANCE) {
            throw new IllegalArgumentException("FilterResultIterator requires a boolean expression, but got " + expression);
        }
    }

    @Override
    protected Tuple advance() throws SQLException {
        Tuple next;
        do {
            next = this.delegate.next();
            this.expression.reset();
        } while (next != null && (!this.expression.evaluate(next, this.ptr) || Boolean.FALSE.equals(this.expression.getDataType().toObject(this.ptr))));
        return next;
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.delegate.explain(planSteps);
        planSteps.add("CLIENT FILTER BY " + this.expression.toString());
    }

    public String toString() {
        return "FilterResultIterator [delegate=" + this.delegate + ", expression=" + this.expression + ", ptr=" + this.ptr + "]";
    }
}

