/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.ReadOnlyImmutableBytesPtr;

public class ColumnReference
implements Comparable<ColumnReference> {
    public static final byte[] ALL_QUALIFIERS = new byte[0];
    private final int hashCode;
    protected volatile byte[] family;
    protected volatile byte[] qualifier;
    private final ImmutableBytesPtr familyPtr;
    private final ImmutableBytesPtr qualifierPtr;

    private static int calcHashCode(ImmutableBytesWritable familyPtr, ImmutableBytesWritable qualifierPtr) {
        int prime = 31;
        int result = 1;
        result = 31 * result + familyPtr.hashCode();
        result = 31 * result + qualifierPtr.hashCode();
        return result;
    }

    public ColumnReference(byte[] family, byte[] qualifier) {
        this.familyPtr = new ReadOnlyImmutableBytesPtr(family);
        this.qualifierPtr = new ReadOnlyImmutableBytesPtr(qualifier);
        this.hashCode = ColumnReference.calcHashCode(this.familyPtr, this.qualifierPtr);
    }

    public ColumnReference(byte[] family, int familyOffset, int familyLength, byte[] qualifier, int qualifierOffset, int qualifierLength) {
        this.familyPtr = new ReadOnlyImmutableBytesPtr(family, familyOffset, familyLength);
        this.qualifierPtr = new ReadOnlyImmutableBytesPtr(qualifier, qualifierOffset, qualifierLength);
        this.hashCode = ColumnReference.calcHashCode(this.familyPtr, this.qualifierPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFamily() {
        if (this.family == null) {
            ImmutableBytesPtr immutableBytesPtr = this.familyPtr;
            synchronized (immutableBytesPtr) {
                if (this.family == null) {
                    this.family = this.familyPtr.copyBytesIfNecessary();
                }
            }
        }
        return this.family;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getQualifier() {
        if (this.qualifier == null) {
            ImmutableBytesPtr immutableBytesPtr = this.qualifierPtr;
            synchronized (immutableBytesPtr) {
                if (this.qualifier == null) {
                    this.qualifier = this.qualifierPtr.copyBytesIfNecessary();
                }
            }
        }
        return this.qualifier;
    }

    public ImmutableBytesPtr getFamilyWritable() {
        return this.familyPtr;
    }

    public ImmutableBytesPtr getQualifierWritable() {
        return this.qualifierPtr;
    }

    public boolean matches(Cell kv) {
        if (this.matchesFamily(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength())) {
            return this.matchesQualifier(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
        }
        return false;
    }

    public boolean matchesQualifier(byte[] qual) {
        return this.matchesQualifier(qual, 0, qual.length);
    }

    public boolean matchesQualifier(byte[] bytes, int offset, int length) {
        return this.allColumns() ? true : this.match(bytes, offset, length, this.qualifierPtr.get(), this.qualifierPtr.getOffset(), this.qualifierPtr.getLength());
    }

    public boolean matchesFamily(byte[] family) {
        return this.matchesFamily(family, 0, family.length);
    }

    public boolean matchesFamily(byte[] bytes, int offset, int length) {
        return this.match(bytes, offset, length, this.familyPtr.get(), this.familyPtr.getOffset(), this.familyPtr.getLength());
    }

    public boolean allColumns() {
        return this.getQualifier() == ALL_QUALIFIERS;
    }

    private boolean match(byte[] first, int offset1, int length1, byte[] storedKey, int offset2, int length2) {
        return first == null ? false : Bytes.equals(first, offset1, length1, storedKey, offset2, length2);
    }

    public KeyValue getFirstKeyValueForRow(byte[] row) {
        return KeyValue.createFirstOnRow(row, this.getFamily(), this.getQualifier() == ALL_QUALIFIERS ? null : this.getQualifier());
    }

    @Override
    public int compareTo(ColumnReference o) {
        int c = this.familyPtr.compareTo(o.familyPtr);
        if (c == 0) {
            c = this.qualifierPtr.compareTo(o.qualifierPtr);
        }
        return c;
    }

    public boolean equals(Object o) {
        if (o instanceof ColumnReference) {
            ColumnReference other = (ColumnReference)o;
            if (this.hashCode == other.hashCode && this.familyPtr.equals(other.familyPtr)) {
                return this.qualifierPtr.equals(other.qualifierPtr);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ColumnReference - " + Bytes.toString(this.getFamily()) + ":" + Bytes.toString(this.getQualifier());
    }
}

