/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.filter.MultiKeyValueComparisonFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class MultiCQKeyValueComparisonFilter
extends MultiKeyValueComparisonFilter {
    private ImmutableBytesPtr ptr = new ImmutableBytesPtr();

    public MultiCQKeyValueComparisonFilter() {
    }

    public MultiCQKeyValueComparisonFilter(Expression expression) {
        super(expression);
    }

    @Override
    protected Object setColumnKey(byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength) {
        this.ptr.set(cq, cqOffset, cqLength);
        return this.ptr;
    }

    @Override
    protected Object newColumnKey(byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength) {
        byte[] cfKey;
        if (cfOffset == 0 && cf.length == cfLength) {
            cfKey = cf;
        } else {
            cfKey = new byte[cfLength];
            System.arraycopy(cf, cfOffset, cfKey, 0, cfLength);
        }
        this.cfSet.add(cfKey);
        return new ImmutableBytesPtr(cq, cqOffset, cqLength);
    }

    public static MultiCQKeyValueComparisonFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (MultiCQKeyValueComparisonFilter)Writables.getWritable(pbBytes, new MultiCQKeyValueComparisonFilter());
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }
}

