/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Format;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ToCharParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="TO_CHAR", nodeClass=ToCharParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class, PDecimal.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, isConstant=true, defaultValue="null")})
public class ToCharFunction
extends ScalarFunction {
    public static final String NAME = "TO_CHAR";
    private String formatString;
    private Format formatter;
    private FunctionArgumentType type;

    public ToCharFunction() {
    }

    public ToCharFunction(List<Expression> children, FunctionArgumentType type, String formatString, Format formatter) throws SQLException {
        super(children.subList(0, 1));
        Preconditions.checkNotNull(formatString);
        Preconditions.checkNotNull(formatter);
        Preconditions.checkNotNull(type);
        this.type = type;
        this.formatString = formatString;
        this.formatter = formatter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.formatString.hashCode();
        result = 31 * result + this.getExpression().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToCharFunction other = (ToCharFunction)obj;
        if (!this.getExpression().equals(other.getExpression())) {
            return false;
        }
        return this.formatString.equals(other.formatString);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr)) {
            return false;
        }
        PDataType type = expression.getDataType();
        String value = this.formatter.format(type.toObject(ptr, expression.getSortOrder()));
        byte[] b = this.getDataType().toBytes(value);
        ptr.set(b);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return this.getExpression().isNullable();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.formatString = WritableUtils.readString(input);
        this.type = WritableUtils.readEnum(input, FunctionArgumentType.class);
        this.formatter = this.type.getFormatter(this.formatString);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeString(output, this.formatString);
        WritableUtils.writeEnum(output, this.type);
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

