/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="LPAD", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PInteger.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="' '")})
public class LpadFunction
extends ScalarFunction {
    public static final String NAME = "LPAD";

    public LpadFunction() {
    }

    public LpadFunction(List<Expression> children) {
        super(children);
    }

    private int getUTF8Length(ImmutableBytesWritable ptr, SortOrder sortOrder, boolean isCharType) {
        return isCharType ? ptr.getLength() : StringUtil.calculateUTF8Length(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder);
    }

    private int getSubstringByteLength(ImmutableBytesWritable ptr, int length, SortOrder sortOrder, boolean isCharType) {
        return isCharType ? length : StringUtil.getByteLengthForUtf8SubStr(ptr.get(), ptr.getOffset(), length, sortOrder);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ImmutableBytesWritable fillPtr;
        Expression outputStrLenExpr = this.getOutputStrLenExpr();
        if (!outputStrLenExpr.evaluate(tuple, ptr)) {
            return false;
        }
        int outputStrLen = outputStrLenExpr.getDataType().getCodec().decodeInt(ptr, outputStrLenExpr.getSortOrder());
        if (outputStrLen < 0) {
            return false;
        }
        Expression strExp = this.getStrExpr();
        if (!strExp.evaluate(tuple, ptr)) {
            return false;
        }
        boolean isStrCharType = this.getStrExpr().getDataType() == PChar.INSTANCE;
        boolean isFillCharType = this.getFillExpr().getDataType() == PChar.INSTANCE;
        SortOrder strSortOrder = this.getStrExpr().getSortOrder();
        SortOrder fillSortOrder = this.getFillExpr().getSortOrder();
        int inputStrLen = this.getUTF8Length(ptr, strSortOrder, isStrCharType);
        if (outputStrLen == inputStrLen) {
            return true;
        }
        if (outputStrLen < inputStrLen) {
            int subStrByteLength = this.getSubstringByteLength(ptr, outputStrLen, strSortOrder, isStrCharType);
            ptr.set(ptr.get(), ptr.getOffset(), subStrByteLength);
            return true;
        }
        Expression fillExpr = this.getFillExpr();
        if (!fillExpr.evaluate(tuple, fillPtr = new ImmutableBytesWritable())) {
            return false;
        }
        int fillExprLen = fillPtr.getLength();
        if (fillExprLen < 1) {
            return false;
        }
        int fillLen = this.getUTF8Length(fillPtr, fillSortOrder, isFillCharType);
        int padLen = outputStrLen - inputStrLen;
        int numFillsPrepended = padLen / fillLen;
        int numFillCharsPrepended = padLen % fillLen;
        int strByteLength = this.getSubstringByteLength(ptr, ptr.getLength(), strSortOrder, isStrCharType);
        int fillByteLength = this.getSubstringByteLength(fillPtr, fillPtr.getLength(), fillSortOrder, isFillCharType);
        int fullFillsByteLength = numFillsPrepended * fillByteLength;
        int fillCharsByteLength = this.getSubstringByteLength(fillPtr, numFillCharsPrepended, fillSortOrder, isFillCharType);
        int strWithPaddingByteLength = fullFillsByteLength + fillCharsByteLength + strByteLength;
        boolean invertFill = fillSortOrder != strSortOrder;
        byte[] paddedStr = StringUtil.lpad(ptr.get(), ptr.getOffset(), ptr.getLength(), fillPtr.get(), fillPtr.getOffset(), fillPtr.getLength(), invertFill, strWithPaddingByteLength);
        ptr.set(paddedStr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getStrExpr().getSortOrder();
    }

    private Expression getStrExpr() {
        return (Expression)this.children.get(0);
    }

    private Expression getFillExpr() {
        return (Expression)this.children.get(2);
    }

    private Expression getOutputStrLenExpr() {
        return (Expression)this.children.get(1);
    }
}

