/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="LOWER", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class LowerFunction
extends ScalarFunction {
    public static final String NAME = "LOWER";

    public LowerFunction() {
    }

    public LowerFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getStrExpression().evaluate(tuple, ptr)) {
            return false;
        }
        String sourceStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getStrExpression().getSortOrder());
        if (sourceStr == null) {
            return true;
        }
        ptr.set(PVarchar.INSTANCE.toBytes(sourceStr.toLowerCase()));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return this.getStrExpression().getDataType();
    }

    @Override
    public boolean isNullable() {
        return this.getStrExpression().isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getStrExpression() {
        return (Expression)this.children.get(0);
    }
}

