/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinaryArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryArray;

@FunctionParseNode.BuiltInFunction(name="ARRAY_APPEND", args={@FunctionParseNode.Argument(allowedTypes={PBinaryArray.class, PVarbinaryArray.class}), @FunctionParseNode.Argument(allowedTypes={PVarbinary.class}, defaultValue="null")})
public class ArrayAppendFunction
extends ScalarFunction {
    public static final String NAME = "ARRAY_APPEND";

    public ArrayAppendFunction() {
    }

    public ArrayAppendFunction(List<Expression> children) throws TypeMismatchException {
        super(children);
        if (!(this.getDataType() == null || this.getElementExpr() instanceof LiteralExpression && this.getElementExpr().isNullable() || this.getElementDataType().isCoercibleTo(this.getBaseType()))) {
            throw TypeMismatchException.newException(this.getBaseType(), this.getElementDataType());
        }
        if (this.getDataType() != null && this.getElementExpr().getDataType().getByteSize() == null && this.getElementDataType() != null && this.getBaseType().isFixedWidth() && this.getElementDataType().isFixedWidth() && this.getArrayExpr().getMaxLength() != null && this.getElementExpr().getMaxLength() != null && this.getElementExpr().getMaxLength() > this.getArrayExpr().getMaxLength()) {
            throw new DataExceedsCapacityException("");
        }
        if (this.getDataType() != null && this.getArrayExpr().getScale() != null && this.getElementExpr().getScale() != null && this.getElementExpr().getScale() > this.getArrayExpr().getScale()) {
            throw new DataExceedsCapacityException(this.getBaseType(), this.getArrayExpr().getMaxLength(), this.getArrayExpr().getScale());
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getArrayExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int arrayLength = PArrayDataType.getArrayLength(ptr, this.getBaseType(), this.getArrayExpr().getMaxLength());
        int length = ptr.getLength();
        int offset = ptr.getOffset();
        byte[] arrayBytes = ptr.get();
        if (!this.getElementExpr().evaluate(tuple, ptr) || ptr.getLength() == 0) {
            ptr.set(arrayBytes, offset, length);
            return true;
        }
        if (!this.getBaseType().isSizeCompatible(ptr, null, this.getElementDataType(), this.getElementExpr().getMaxLength(), this.getElementExpr().getScale(), this.getArrayExpr().getMaxLength(), this.getArrayExpr().getScale())) {
            throw new DataExceedsCapacityException("");
        }
        this.getBaseType().coerceBytes(ptr, null, this.getElementDataType(), this.getElementExpr().getMaxLength(), this.getElementExpr().getScale(), this.getElementExpr().getSortOrder(), this.getArrayExpr().getMaxLength(), this.getArrayExpr().getScale(), this.getArrayExpr().getSortOrder());
        return PArrayDataType.appendItemToArray(ptr, length, offset, arrayBytes, this.getBaseType(), arrayLength, this.getMaxLength(), this.getArrayExpr().getSortOrder());
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getChildren().get(0).getSortOrder();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Expression getArrayExpr() {
        return this.getChildren().get(0);
    }

    public Expression getElementExpr() {
        return this.getChildren().get(1);
    }

    public PDataType getBaseType() {
        return PDataType.arrayBaseType(this.getArrayExpr().getDataType());
    }

    public PDataType getElementDataType() {
        return this.getElementExpr().getDataType();
    }
}

