/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.sun.istack.NotNull;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.PhoenixMetrics;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.trace.util.Tracing;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationState
implements SQLCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MutationState.class);
    private PhoenixConnection connection;
    private final long maxSize;
    private final ImmutableBytesPtr tempPtr = new ImmutableBytesPtr();
    private final Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> mutations;
    private long sizeOffset;
    private int numRows = 0;

    MutationState(long maxSize, PhoenixConnection connection, Map<TableRef, Map<ImmutableBytesPtr, RowMutationState>> mutations) {
        this.maxSize = maxSize;
        this.connection = connection;
        this.mutations = mutations;
    }

    public MutationState(long maxSize, PhoenixConnection connection) {
        this(maxSize, connection, 0L);
    }

    public MutationState(long maxSize, PhoenixConnection connection, long sizeOffset) {
        this(maxSize, connection, Maps.newHashMapWithExpectedSize(connection.getMutateBatchSize()));
        this.sizeOffset = sizeOffset;
    }

    public MutationState(TableRef table, Map<ImmutableBytesPtr, RowMutationState> mutations, long sizeOffset, long maxSize, PhoenixConnection connection) {
        this(maxSize, connection, sizeOffset);
        this.mutations.put(table, mutations);
        this.numRows = mutations.size();
        this.throwIfTooBig();
    }

    private void throwIfTooBig() {
        if ((long)this.numRows > this.maxSize) {
            throw new IllegalArgumentException("MutationState size of " + this.numRows + " is bigger than max allowed size of " + this.maxSize);
        }
    }

    public long getUpdateCount() {
        return this.sizeOffset + (long)this.numRows;
    }

    public void join(MutationState newMutation) {
        if (this == newMutation) {
            return;
        }
        this.sizeOffset += newMutation.sizeOffset;
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> entry : newMutation.mutations.entrySet()) {
            TableRef tableRef = entry.getKey();
            PTable table = tableRef.getTable();
            boolean isIndex = table.getType() == PTableType.INDEX;
            Map<ImmutableBytesPtr, RowMutationState> existingRows = this.mutations.put(tableRef, entry.getValue());
            if (existingRows != null) {
                for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : entry.getValue().entrySet()) {
                    RowMutationState existingRowMutationState = existingRows.put(rowEntry.getKey(), rowEntry.getValue());
                    if (existingRowMutationState != null) {
                        Map<PColumn, byte[]> newRow;
                        Map<PColumn, byte[]> existingValues = existingRowMutationState.getColumnValues();
                        if (existingValues == PRow.DELETE_MARKER || (newRow = rowEntry.getValue().getColumnValues()) == PRow.DELETE_MARKER) continue;
                        existingRowMutationState.join(rowEntry.getValue());
                        existingRows.put(rowEntry.getKey(), existingRowMutationState);
                        continue;
                    }
                    if (isIndex) continue;
                    ++this.numRows;
                }
                this.mutations.put(entry.getKey(), existingRows);
                continue;
            }
            if (isIndex) continue;
            this.numRows += entry.getValue().size();
        }
        this.throwIfTooBig();
    }

    private static ImmutableBytesPtr getNewRowKeyWithRowTimestamp(ImmutableBytesPtr ptr, long rowTimestamp, PTable table) {
        RowKeySchema schema = table.getRowKeySchema();
        int rowTimestampColPos = table.getRowTimestampColPos();
        ValueSchema.Field rowTimestampField = schema.getField(rowTimestampColPos);
        byte[] rowTimestampBytes = PLong.INSTANCE.toBytes(rowTimestamp, rowTimestampField.getSortOrder());
        int oldOffset = ptr.getOffset();
        int oldLength = ptr.getLength();
        schema.position(ptr, 0, rowTimestampColPos);
        byte[] b = ptr.get();
        int newOffset = ptr.getOffset();
        int length = ptr.getLength();
        for (int i = newOffset; i < newOffset + length; ++i) {
            b[i] = rowTimestampBytes[i - newOffset];
        }
        ptr.set(ptr.get(), oldOffset, oldLength);
        return ptr;
    }

    private Iterator<Pair<byte[], List<Mutation>>> addRowMutations(TableRef tableRef, Map<ImmutableBytesPtr, RowMutationState> values, long timestamp, boolean includeMutableIndexes) {
        final PTable table = tableRef.getTable();
        boolean tableWithRowTimestampCol = table.getRowTimestampColPos() != -1;
        final UnmodifiableIterator indexes = table.isImmutableRows() || includeMutableIndexes ? IndexMaintainer.nonDisabledIndexIterator(table.getIndexes().iterator()) : Iterators.emptyIterator();
        final ArrayList<Mutation> mutations = Lists.newArrayListWithExpectedSize(values.size());
        final ArrayList mutationsPertainingToIndex = indexes.hasNext() ? Lists.newArrayListWithExpectedSize(values.size()) : null;
        Iterator<Map.Entry<ImmutableBytesPtr, RowMutationState>> iterator = values.entrySet().iterator();
        long timestampToUse = timestamp;
        while (iterator.hasNext()) {
            List<Object> rowMutationsPertainingToIndex;
            List<Mutation> rowMutations;
            Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry = iterator.next();
            ImmutableBytesPtr key = rowEntry.getKey();
            RowMutationState state = rowEntry.getValue();
            if (tableWithRowTimestampCol) {
                RowTimestampColInfo rowTsColInfo = state.getRowTimestampColInfo();
                if (rowTsColInfo.useServerTimestamp()) {
                    key = MutationState.getNewRowKeyWithRowTimestamp(key, timestampToUse, table);
                } else if (rowTsColInfo.getTimestamp() != null) {
                    timestampToUse = rowTsColInfo.getTimestamp();
                }
            }
            PRow row = table.newRow(this.connection.getKeyValueBuilder(), timestampToUse, key, (byte[][])new byte[0][]);
            if (rowEntry.getValue().getColumnValues() == PRow.DELETE_MARKER) {
                row.delete();
                rowMutations = row.toRowMutations();
                rowMutationsPertainingToIndex = Collections.emptyList();
            } else {
                for (Map.Entry<PColumn, byte[]> valueEntry : rowEntry.getValue().getColumnValues().entrySet()) {
                    row.setValue(valueEntry.getKey(), valueEntry.getValue());
                }
                rowMutations = row.toRowMutations();
                rowMutationsPertainingToIndex = rowMutations;
            }
            mutations.addAll(rowMutations);
            if (mutationsPertainingToIndex == null) continue;
            mutationsPertainingToIndex.addAll(rowMutationsPertainingToIndex);
        }
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            boolean isFirst = true;

            @Override
            public boolean hasNext() {
                return this.isFirst || indexes.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                List<Mutation> indexMutations;
                if (this.isFirst) {
                    this.isFirst = false;
                    return new Pair<byte[], List<Mutation>>(table.getPhysicalName().getBytes(), mutations);
                }
                PTable index = (PTable)indexes.next();
                try {
                    indexMutations = IndexUtil.generateIndexData(table, index, mutationsPertainingToIndex, MutationState.this.tempPtr, MutationState.this.connection.getKeyValueBuilder(), MutationState.this.connection);
                }
                catch (SQLException e) {
                    throw new IllegalDataException(e);
                }
                return new Pair<byte[], List<Mutation>>(index.getPhysicalName().getBytes(), indexMutations);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations() {
        return this.toMutations(false);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(final boolean includeMutableIndexes) {
        final Iterator<Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>>> iterator = this.mutations.entrySet().iterator();
        if (!iterator.hasNext()) {
            return Iterators.emptyIterator();
        }
        Long scn = this.connection.getSCN();
        final long timestamp = scn == null ? Long.MAX_VALUE : scn;
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            private Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> current;
            private Iterator<Pair<byte[], List<Mutation>>> innerIterator;
            {
                this.current = (Map.Entry)iterator.next();
                this.innerIterator = this.init();
            }

            private Iterator<Pair<byte[], List<Mutation>>> init() {
                return MutationState.this.addRowMutations(this.current.getKey(), this.current.getValue(), timestamp, includeMutableIndexes);
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext() || iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                if (!this.innerIterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                }
                return this.innerIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private long[] validate() throws SQLException {
        int i = 0;
        Long scn = this.connection.getSCN();
        MetaDataClient client = new MetaDataClient(this.connection);
        long[] timeStamps = new long[this.mutations.size()];
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> entry : this.mutations.entrySet()) {
            MetaDataProtocol.MetaDataMutationResult result;
            long timestamp;
            TableRef tableRef = entry.getKey();
            long serverTimeStamp = tableRef.getTimeStamp();
            PTable table = tableRef.getTable();
            if (!this.connection.getAutoCommit() && (timestamp = (result = client.updateCache(table.getSchemaName().getString(), table.getTableName().getString())).getMutationTime()) != -1L) {
                serverTimeStamp = timestamp;
                if (result.wasUpdated()) {
                    table = result.getTable();
                    PColumn[] columns = new PColumn[table.getColumns().size()];
                    for (Map.Entry<ImmutableBytesPtr, RowMutationState> rowEntry : entry.getValue().entrySet()) {
                        Map<PColumn, byte[]> colValues;
                        RowMutationState valueEntry = rowEntry.getValue();
                        if (valueEntry == null || (colValues = valueEntry.getColumnValues()) == PRow.DELETE_MARKER) continue;
                        Iterator<PColumn> iterator = colValues.keySet().iterator();
                        while (iterator.hasNext()) {
                            PColumn column;
                            columns[column.getPosition()] = column = iterator.next();
                        }
                    }
                    for (PColumn column : columns) {
                        if (column == null) continue;
                        table.getColumnFamily(column.getFamilyName().getString()).getColumn(column.getName().getString());
                    }
                    tableRef.setTable(table);
                }
            }
            timeStamps[i++] = scn == null ? (serverTimeStamp == -1L ? Long.MAX_VALUE : serverTimeStamp) : scn;
        }
        return timeStamps;
    }

    private static void logMutationSize(HTableInterface htable, List<Mutation> mutations, PhoenixConnection connection) {
        long byteSize = 0L;
        int keyValueCount = 0;
        if (PhoenixMetrics.isMetricsEnabled() || logger.isDebugEnabled()) {
            for (Mutation mutation : mutations) {
                byteSize += mutation.heapSize();
            }
            PhoenixMetrics.SizeMetric.MUTATION_BYTES.update(byteSize);
            if (logger.isDebugEnabled()) {
                logger.debug(LogUtil.addCustomAnnotations("Sending " + mutations.size() + " mutations for " + Bytes.toString(htable.getTableName()) + " with " + keyValueCount + " key values of total size " + byteSize + " bytes", connection));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        int i = 0;
        byte[] tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
        long[] serverTimeStamps = this.validate();
        Iterator<Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>>> iterator = this.mutations.entrySet().iterator();
        TraceScope trace = Tracing.startNewSpan(this.connection, "Committing mutations to tables");
        Span span = trace.getSpan();
        block48: while (true) {
            if (!iterator.hasNext()) {
                trace.close();
                assert (this.numRows == 0);
                assert (this.mutations.isEmpty());
                return;
            }
            Map.Entry<TableRef, Map<ImmutableBytesPtr, RowMutationState>> entry = iterator.next();
            Map<ImmutableBytesPtr, RowMutationState> valuesMap = entry.getValue();
            TableRef tableRef = entry.getKey();
            PTable table = tableRef.getTable();
            table.getIndexMaintainers(this.tempPtr, this.connection);
            boolean hasIndexMaintainers = this.tempPtr.getLength() > 0;
            boolean isDataTable = true;
            long serverTimestamp = serverTimeStamps[i++];
            Iterator<Pair<byte[], List<Mutation>>> mutationsIterator = this.addRowMutations(tableRef, valuesMap, serverTimestamp, false);
            while (true) {
                if (!mutationsIterator.hasNext()) {
                    if (tableRef.getTable().getType() != PTableType.INDEX) {
                        this.numRows -= entry.getValue().size();
                    }
                    iterator.remove();
                    continue block48;
                }
                Pair<byte[], List<Mutation>> pair = mutationsIterator.next();
                byte[] htableName = pair.getFirst();
                List<Mutation> mutations = pair.getSecond();
                Span child = Tracing.child(span, "Writing mutation batch for table: " + Bytes.toString(htableName));
                int retryCount = 0;
                boolean shouldRetry = false;
                do {
                    ServerCacheClient.ServerCache cache = null;
                    if (hasIndexMaintainers && isDataTable) {
                        byte[] uuidValue;
                        byte[] attribValue = null;
                        if (IndexMetaDataCacheClient.useIndexMetadataCache(this.connection, mutations, this.tempPtr.getLength())) {
                            IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(this.connection, tableRef);
                            cache = client.addIndexMetadataCache(mutations, (ImmutableBytesWritable)this.tempPtr);
                            child.addTimelineAnnotation("Updated index metadata cache");
                            uuidValue = cache.getId();
                            shouldRetry = true;
                        } else {
                            attribValue = ByteUtil.copyKeyBytesIfNecessary(this.tempPtr);
                            uuidValue = ServerCacheClient.generateId();
                        }
                        for (Mutation mutation : mutations) {
                            if (tenantId != null) {
                                mutation.setAttribute("TenantId", tenantId);
                            }
                            mutation.setAttribute("IdxUUID", uuidValue);
                            if (attribValue == null) continue;
                            mutation.setAttribute("IdxMD", attribValue);
                        }
                    }
                    SQLException sqlE = null;
                    HTableInterface hTable = this.connection.getQueryServices().getTable(htableName);
                    try {
                        MutationState.logMutationSize(hTable, mutations, this.connection);
                        PhoenixMetrics.SizeMetric.MUTATION_BATCH_SIZE.update(mutations.size());
                        long startTime = System.currentTimeMillis();
                        child.addTimelineAnnotation("Attempt " + retryCount);
                        hTable.batch(mutations);
                        child.stop();
                        long duration = System.currentTimeMillis() - startTime;
                        PhoenixMetrics.SizeMetric.MUTATION_COMMIT_TIME.update(duration);
                        shouldRetry = false;
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(LogUtil.addCustomAnnotations("Total time for batch call of  " + mutations.size() + " mutations into " + table.getName().getString() + ": " + duration + " ms", this.connection));
                    }
                    catch (Exception e2) {
                        SQLException e2;
                        SQLException inferredE = ServerUtil.parseServerExceptionOrNull(e2);
                        if (inferredE != null) {
                            if (shouldRetry && retryCount == 0 && inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) {
                                String msg = "Swallowing exception and retrying after clearing meta cache on connection. " + inferredE;
                                logger.warn(LogUtil.addCustomAnnotations(msg, this.connection));
                                this.connection.getQueryServices().clearTableRegionCache(htableName);
                                child.addTimelineAnnotation(msg);
                                child.stop();
                                child = Tracing.child(span, "Failed batch, attempting retry");
                            }
                            e2 = inferredE;
                        }
                        sqlE = new CommitException(e2, this.getUncommittedSattementIndexes());
                    }
                    finally {
                        try {
                            hTable.close();
                        }
                        catch (IOException e) {
                            if (sqlE != null) {
                                sqlE.setNextException(ServerUtil.parseServerException(e));
                            }
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        finally {
                            try {
                                if (cache != null) {
                                    cache.close();
                                }
                            }
                            finally {
                                if (sqlE == null) continue;
                                throw sqlE;
                            }
                        }
                    }
                } while (shouldRetry && retryCount++ < 1);
                isDataTable = false;
            }
            break;
        }
    }

    public void rollback(PhoenixConnection connection) throws SQLException {
        this.mutations.clear();
        this.numRows = 0;
    }

    private int[] getUncommittedSattementIndexes() {
        int[] result = new int[]{};
        for (Map<ImmutableBytesPtr, RowMutationState> rowMutations : this.mutations.values()) {
            for (RowMutationState rowMutationState : rowMutations.values()) {
                result = MutationState.joinSortedIntArrays(result, rowMutationState.getStatementIndexes());
            }
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
    }

    public static int[] joinSortedIntArrays(int[] a, int[] b) {
        int current;
        int[] result = new int[a.length + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < a.length && j < b.length) {
            int n = current = a[i] < b[j] ? a[i++] : b[j++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        while (i < a.length) {
            current = a[i++];
            while (i < a.length && a[i] == current) {
                ++i;
            }
            result[k++] = current;
        }
        while (j < b.length) {
            current = b[j++];
            while (j < b.length && b[j] == current) {
                ++j;
            }
            result[k++] = current;
        }
        return Arrays.copyOf(result, k);
    }

    public static class RowMutationState {
        @Nonnull
        private Map<PColumn, byte[]> columnValues;
        private int[] statementIndexes;
        @Nonnull
        private final RowTimestampColInfo rowTsColInfo;

        public RowMutationState(@NotNull Map<PColumn, byte[]> columnValues, int statementIndex, RowTimestampColInfo rowTsColInfo) {
            Preconditions.checkNotNull(columnValues);
            Preconditions.checkNotNull(rowTsColInfo);
            this.columnValues = columnValues;
            this.statementIndexes = new int[]{statementIndex};
            this.rowTsColInfo = rowTsColInfo;
        }

        Map<PColumn, byte[]> getColumnValues() {
            return this.columnValues;
        }

        int[] getStatementIndexes() {
            return this.statementIndexes;
        }

        void join(RowMutationState newRow) {
            this.getColumnValues().putAll(newRow.getColumnValues());
            this.statementIndexes = MutationState.joinSortedIntArrays(this.statementIndexes, newRow.getStatementIndexes());
        }

        @Nonnull
        RowTimestampColInfo getRowTimestampColInfo() {
            return this.rowTsColInfo;
        }
    }

    @Immutable
    public static class RowTimestampColInfo {
        private final boolean useServerTimestamp;
        private final Long rowTimestamp;
        public static final RowTimestampColInfo NULL_ROWTIMESTAMP_INFO = new RowTimestampColInfo(false, null);

        public RowTimestampColInfo(boolean autoGenerate, Long value) {
            this.useServerTimestamp = autoGenerate;
            this.rowTimestamp = value;
        }

        public boolean useServerTimestamp() {
            return this.useServerTimestamp;
        }

        public Long getTimestamp() {
            return this.rowTimestamp;
        }
    }
}

