/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;

public class UnionCompiler {
    private static final PName UNION_FAMILY_NAME = PNameFactory.newName("unionFamilyName");
    private static final PName UNION_SCHEMA_NAME = PNameFactory.newName("unionSchemaName");
    private static final PName UNION_TABLE_NAME = PNameFactory.newName("unionTableName");

    public static List<QueryPlan> checkProjectionNumAndTypes(List<QueryPlan> selectPlans) throws SQLException {
        QueryPlan plan = selectPlans.get(0);
        int columnCount = plan.getProjector().getColumnCount();
        List<? extends ColumnProjector> projectors = plan.getProjector().getColumnProjectors();
        ArrayList<PDataType> selectTypes = new ArrayList<PDataType>();
        for (ColumnProjector columnProjector : projectors) {
            selectTypes.add(columnProjector.getExpression().getDataType());
        }
        for (int i = 1; i < selectPlans.size(); ++i) {
            plan = selectPlans.get(i);
            if (columnCount != plan.getProjector().getColumnCount()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SELECT_COLUMN_NUM_IN_UNIONALL_DIFFS).setMessage(".").build().buildException();
            }
            List<? extends ColumnProjector> list = plan.getProjector().getColumnProjectors();
            for (int j = 0; j < columnCount; ++j) {
                PDataType type = list.get(j).getExpression().getDataType();
                if (type.isCoercibleTo((PDataType)selectTypes.get(j))) continue;
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.SELECT_COLUMN_TYPE_IN_UNIONALL_DIFFS).setMessage(".").build().buildException();
            }
        }
        return selectPlans;
    }

    public static TableRef contructSchemaTable(PhoenixStatement statement, QueryPlan plan, List<AliasedNode> selectNodes) throws SQLException {
        ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
        for (int i = 0; i < plan.getProjector().getColumnCount(); ++i) {
            ColumnProjector colProj = plan.getProjector().getColumnProjector(i);
            Expression sourceExpression = colProj.getExpression();
            String name = selectNodes == null ? colProj.getName() : selectNodes.get(i).getAlias();
            PColumnImpl projectedColumn = new PColumnImpl(PNameFactory.newName(name), UNION_FAMILY_NAME, sourceExpression.getDataType(), sourceExpression.getMaxLength(), sourceExpression.getScale(), sourceExpression.isNullable(), i, sourceExpression.getSortOrder(), 500, null, false, sourceExpression.toString(), false);
            projectedColumns.add(projectedColumn);
        }
        Long scn = statement.getConnection().getSCN();
        PTableImpl tempTable = PTableImpl.makePTable(statement.getConnection().getTenantId(), UNION_SCHEMA_NAME, UNION_TABLE_NAME, PTableType.SUBQUERY, null, Long.MAX_VALUE, scn == null ? Long.MAX_VALUE : scn, null, null, projectedColumns, null, null, null, true, null, null, null, true, true, true, null, null, null);
        TableRef tableRef = new TableRef(null, tempTable, 0L, false);
        return tableRef;
    }
}

