/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixParameterMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class DropSequenceCompiler {
    private final PhoenixStatement statement;

    public DropSequenceCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(final DropSequenceStatement sequence) throws SQLException {
        final PhoenixConnection connection = this.statement.getConnection();
        final MetaDataClient client = new MetaDataClient(connection);
        final StatementContext context = new StatementContext(this.statement);
        return new MutationPlan(){

            @Override
            public MutationState execute() throws SQLException {
                return client.dropSequence(sequence);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("DROP SEQUENCE"));
            }

            @Override
            public StatementContext getContext() {
                return context;
            }

            @Override
            public PhoenixConnection getConnection() {
                return connection;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return PhoenixParameterMetaData.EMPTY_PARAMETER_META_DATA;
            }
        };
    }
}

