/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache.aggcache;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.UUID;
import org.apache.phoenix.util.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpillFile
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SpillFile.class);
    private static final int SPILL_FILE_SIZE = Integer.MAX_VALUE;
    static final int DEFAULT_PAGE_SIZE = 4096;
    private Map<Integer, TempFile> tempFiles;
    private File spillFilesDirectory = null;

    private SpillFile(File spillFilesDirectory) throws IOException {
        this.spillFilesDirectory = spillFilesDirectory;
        this.tempFiles = Maps.newHashMap();
        this.tempFiles.put(0, this.createTempFile());
    }

    public static SpillFile createSpillFile(File spillFilesDir) {
        try {
            return new SpillFile(spillFilesDir);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create Spillfile " + ioe);
        }
    }

    private TempFile createTempFile() throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), null, this.spillFilesDirectory);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new SpillFile: " + tempFile.getAbsolutePath());
        }
        RandomAccessFile file = new RandomAccessFile(tempFile, "rw");
        file.setLength(Integer.MAX_VALUE);
        return new TempFile(tempFile, file);
    }

    public MappedByteBuffer getPage(int index) {
        try {
            TempFile tempFile = null;
            int fileIndex = 0;
            long offset = (long)index * 4096L;
            if (offset >= Integer.MAX_VALUE && !this.tempFiles.containsKey(fileIndex = (int)(offset / Integer.MAX_VALUE))) {
                tempFile = this.createTempFile();
                this.tempFiles.put(fileIndex, tempFile);
            }
            tempFile = this.tempFiles.get(fileIndex);
            FileChannel fc = tempFile.getChannel();
            return fc.map(FileChannel.MapMode.READ_WRITE, offset, 4096L);
        }
        catch (IOException ioe) {
            this.close();
            throw new RuntimeException("Could not get page at index: " + index);
        }
        catch (IllegalArgumentException iae) {
            this.close();
            throw iae;
        }
    }

    @Override
    public void close() {
        for (TempFile file : this.tempFiles.values()) {
            Closeables.closeQuietly(file);
        }
    }

    private static class TempFile
    implements Closeable {
        private RandomAccessFile rndFile;
        private File file;

        public TempFile(File file, RandomAccessFile rndFile) {
            this.file = file;
            this.rndFile = rndFile;
        }

        public FileChannel getChannel() {
            return this.rndFile.getChannel();
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly(this.rndFile.getChannel());
            Closeables.closeQuietly(this.rndFile);
            if (this.file != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Deleting tempFile: " + this.file.getAbsolutePath());
                }
                try {
                    this.file.delete();
                }
                catch (SecurityException e) {
                    logger.warn("IOException thrown while closing Closeable." + e);
                }
            }
        }
    }
}

