/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.util.Closeables;

public class TenantCacheImpl
implements TenantCache {
    private final int maxTimeToLiveMs;
    private final MemoryManager memoryManager;
    private volatile Cache<ImmutableBytesPtr, Closeable> serverCaches;

    public TenantCacheImpl(MemoryManager memoryManager, int maxTimeToLiveMs) {
        this.memoryManager = memoryManager;
        this.maxTimeToLiveMs = maxTimeToLiveMs;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<ImmutableBytesPtr, Closeable> getServerCaches() {
        if (this.serverCaches == null) {
            TenantCacheImpl tenantCacheImpl = this;
            synchronized (tenantCacheImpl) {
                if (this.serverCaches == null) {
                    this.serverCaches = CacheBuilder.newBuilder().expireAfterAccess(this.maxTimeToLiveMs, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<ImmutableBytesPtr, Closeable>(){

                        @Override
                        public void onRemoval(RemovalNotification<ImmutableBytesPtr, Closeable> notification) {
                            Closeables.closeAllQuietly(Collections.singletonList(notification.getValue()));
                        }
                    }).build();
                }
            }
        }
        return this.serverCaches;
    }

    @Override
    public Closeable getServerCache(ImmutableBytesPtr cacheId) {
        return this.getServerCaches().getIfPresent(cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable addServerCache(ImmutableBytesPtr cacheId, ImmutableBytesWritable cachePtr, ServerCachingProtocol.ServerCacheFactory cacheFactory) throws SQLException {
        MemoryManager.MemoryChunk chunk = this.getMemoryManager().allocate(cachePtr.getLength());
        boolean success = false;
        try {
            Closeable element = cacheFactory.newCache(cachePtr, chunk);
            this.getServerCaches().put(cacheId, element);
            success = true;
            Closeable closeable = element;
            return closeable;
        }
        finally {
            if (!success) {
                Closeables.closeAllQuietly(Collections.singletonList(chunk));
            }
        }
    }

    @Override
    public void removeServerCache(ImmutableBytesPtr cacheId) throws SQLException {
        this.getServerCaches().invalidate(cacheId);
    }
}

