/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.impl.pb.NodeHealthStatusPBImpl;

public class NodeStatusPBImpl
extends NodeStatus {
    YarnServerCommonProtos.NodeStatusProto proto = YarnServerCommonProtos.NodeStatusProto.getDefaultInstance();
    YarnServerCommonProtos.NodeStatusProto.Builder builder = null;
    boolean viaProto = false;
    private NodeId nodeId = null;
    private List<ContainerStatus> containers = null;
    private NodeHealthStatus nodeHealthStatus = null;
    private List<ApplicationId> keepAliveApplications = null;

    public NodeStatusPBImpl() {
        this.builder = YarnServerCommonProtos.NodeStatusProto.newBuilder();
    }

    public NodeStatusPBImpl(YarnServerCommonProtos.NodeStatusProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServerCommonProtos.NodeStatusProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private synchronized void mergeLocalToBuilder() {
        if (this.nodeId != null) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.containers != null) {
            this.addContainersToProto();
        }
        if (this.nodeHealthStatus != null) {
            this.builder.setNodeHealthStatus(this.convertToProtoFormat(this.nodeHealthStatus));
        }
        if (this.keepAliveApplications != null) {
            this.addKeepAliveApplicationsToProto();
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonProtos.NodeStatusProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private synchronized void addContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersStatuses();
        if (this.containers == null) {
            return;
        }
        Iterable<YarnProtos.ContainerStatusProto> iterable = new Iterable<YarnProtos.ContainerStatusProto>(){

            @Override
            public Iterator<YarnProtos.ContainerStatusProto> iterator() {
                return new Iterator<YarnProtos.ContainerStatusProto>(){
                    Iterator<ContainerStatus> iter;
                    {
                        this.iter = NodeStatusPBImpl.this.containers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerStatusProto next() {
                        return NodeStatusPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersStatuses((Iterable<? extends YarnProtos.ContainerStatusProto>)iterable);
    }

    private synchronized void addKeepAliveApplicationsToProto() {
        this.maybeInitBuilder();
        this.builder.clearKeepAliveApplications();
        if (this.keepAliveApplications == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationIdProto> iterable = new Iterable<YarnProtos.ApplicationIdProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationIdProto> iterator() {
                return new Iterator<YarnProtos.ApplicationIdProto>(){
                    Iterator<ApplicationId> iter;
                    {
                        this.iter = NodeStatusPBImpl.this.keepAliveApplications.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationIdProto next() {
                        return NodeStatusPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllKeepAliveApplications((Iterable<? extends YarnProtos.ApplicationIdProto>)iterable);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((NodeStatusPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public synchronized int getResponseId() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public synchronized void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public synchronized NodeId getNodeId() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p;
        YarnServerCommonProtos.NodeStatusProtoOrBuilder nodeStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public synchronized List<ContainerStatus> getContainersStatuses() {
        this.initContainers();
        return this.containers;
    }

    @Override
    public synchronized void setContainersStatuses(List<ContainerStatus> containers) {
        if (containers == null) {
            this.builder.clearContainersStatuses();
        }
        this.containers = containers;
    }

    @Override
    public synchronized List<ApplicationId> getKeepAliveApplications() {
        this.initKeepAliveApplications();
        return this.keepAliveApplications;
    }

    @Override
    public synchronized void setKeepAliveApplications(List<ApplicationId> appIds) {
        if (appIds == null) {
            this.builder.clearKeepAliveApplications();
        }
        this.keepAliveApplications = appIds;
    }

    private synchronized void initContainers() {
        if (this.containers != null) {
            return;
        }
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerStatusProto> list = p.getContainersStatusesList();
        this.containers = new ArrayList<ContainerStatus>();
        for (YarnProtos.ContainerStatusProto c : list) {
            this.containers.add(this.convertFromProtoFormat(c));
        }
    }

    private synchronized void initKeepAliveApplications() {
        if (this.keepAliveApplications != null) {
            return;
        }
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationIdProto> list = p.getKeepAliveApplicationsList();
        this.keepAliveApplications = new ArrayList<ApplicationId>();
        for (YarnProtos.ApplicationIdProto c : list) {
            this.keepAliveApplications.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public synchronized NodeHealthStatus getNodeHealthStatus() {
        YarnServerCommonProtos.NodeStatusProtoOrBuilder p;
        YarnServerCommonProtos.NodeStatusProtoOrBuilder nodeStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeHealthStatus != null) {
            return this.nodeHealthStatus;
        }
        if (!p.hasNodeHealthStatus()) {
            return null;
        }
        this.nodeHealthStatus = this.convertFromProtoFormat(p.getNodeHealthStatus());
        return this.nodeHealthStatus;
    }

    @Override
    public synchronized void setNodeHealthStatus(NodeHealthStatus healthStatus) {
        this.maybeInitBuilder();
        if (healthStatus == null) {
            this.builder.clearNodeHealthStatus();
        }
        this.nodeHealthStatus = healthStatus;
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private NodeId convertFromProtoFormat(YarnProtos.NodeIdProto proto) {
        return new NodeIdPBImpl(proto);
    }

    private YarnServerCommonProtos.NodeHealthStatusProto convertToProtoFormat(NodeHealthStatus healthStatus) {
        return ((NodeHealthStatusPBImpl)healthStatus).getProto();
    }

    private NodeHealthStatus convertFromProtoFormat(YarnServerCommonProtos.NodeHealthStatusProto proto) {
        return new NodeHealthStatusPBImpl(proto);
    }

    private ContainerStatusPBImpl convertFromProtoFormat(YarnProtos.ContainerStatusProto c) {
        return new ContainerStatusPBImpl(c);
    }

    private YarnProtos.ContainerStatusProto convertToProtoFormat(ContainerStatus c) {
        return ((ContainerStatusPBImpl)c).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto c) {
        return new ApplicationIdPBImpl(c);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId c) {
        return ((ApplicationIdPBImpl)c).getProto();
    }
}

