/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.FileSystemNodeLabelsStore;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeRequestPBImpl;

public class NonAppendableFSNodeLabelStore
extends FileSystemNodeLabelsStore {
    protected static final Log LOG = LogFactory.getLog(NonAppendableFSNodeLabelStore.class);

    @Override
    public void close() throws IOException {
    }

    @Override
    public void recover() throws YarnException, IOException {
        Path newMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new");
        Path oldMirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror");
        this.loadFromMirror(newMirrorPath, oldMirrorPath);
        if (this.fs.exists(newMirrorPath)) {
            block3: {
                try {
                    this.fs.delete(oldMirrorPath, false);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while removing old mirror", e);
                }
            }
            this.fs.rename(newMirrorPath, oldMirrorPath);
        }
        LOG.info("Node label store recover is completed");
    }

    @Override
    public void updateNodeToLabelsMappings(Map<NodeId, Set<String>> nodeToLabels) throws IOException {
        this.writeNewMirror();
    }

    @Override
    public void storeNewClusterNodeLabels(List<NodeLabel> labels) throws IOException {
        this.writeNewMirror();
    }

    @Override
    public void removeClusterNodeLabels(Collection<String> labels) throws IOException {
        this.writeNewMirror();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewMirror() throws IOException {
        ReentrantReadWriteLock.ReadLock readLock = this.mgr.readLock;
        try {
            readLock.lock();
            List<NodeLabel> nodeLabels = this.mgr.getClusterNodeLabels();
            Map<NodeId, Set<String>> nodeToLabels = this.mgr.getNodeLabels();
            Path newTmpPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new.tmp");
            FSDataOutputStream os = this.fs.create(newTmpPath, true);
            ((AddToClusterNodeLabelsRequestPBImpl)AddToClusterNodeLabelsRequest.newInstance(nodeLabels)).getProto().writeDelimitedTo(os);
            ((ReplaceLabelsOnNodeRequestPBImpl)ReplaceLabelsOnNodeRequest.newInstance(nodeToLabels)).getProto().writeDelimitedTo(os);
            os.close();
            Path newPath = new Path(this.fsWorkingPath, "nodelabel.mirror.new");
            if (this.fs.exists(newPath)) {
                this.fs.delete(newPath, false);
            }
            this.fs.rename(newTmpPath, newPath);
            Path mirrorPath = new Path(this.fsWorkingPath, "nodelabel.mirror");
            if (this.fs.exists(mirrorPath)) {
                this.fs.delete(mirrorPath, false);
            }
            this.fs.rename(newPath, mirrorPath);
        }
        finally {
            readLock.unlock();
        }
    }
}

