/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LogCLIHelpers
implements Configurable {
    private Configuration conf;

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainersLogs(String appId, String containerId, String nodeId, String jobOwner) throws IOException {
        return this.dumpAContainersLogsForALogType(appId, containerId, nodeId, jobOwner, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainersLogsForALogType(String appId, String containerId, String nodeId, String jobOwner, List<String> logType) throws IOException {
        RemoteIterator<FileStatus> nodeFiles;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, ConverterUtils.toApplicationId(appId), jobOwner, suffix);
        try {
            Path qualifiedLogDir = FileContext.getFileContext(this.getConf()).makeQualified(remoteAppLogDir);
            nodeFiles = FileContext.getFileContext(qualifiedLogDir.toUri(), this.getConf()).listStatus(remoteAppLogDir);
        }
        catch (FileNotFoundException fnf) {
            LogCLIHelpers.logDirNotExist(remoteAppLogDir.toString());
            return -1;
        }
        boolean foundContainerLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = nodeFiles.next();
            String fileName = thisNodeFile.getPath().getName();
            if (!fileName.contains(LogAggregationUtils.getNodeString(nodeId)) || fileName.endsWith(".tmp")) continue;
            AggregatedLogFormat.LogReader reader = null;
            try {
                reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());
                if (logType == null) {
                    if (this.dumpAContainerLogs(containerId, reader, System.out, thisNodeFile.getModificationTime()) <= -1) continue;
                    foundContainerLogs = true;
                    continue;
                }
                if (this.dumpAContainerLogsForALogType(containerId, reader, System.out, thisNodeFile.getModificationTime(), logType) <= -1) continue;
                foundContainerLogs = true;
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        if (!foundContainerLogs) {
            LogCLIHelpers.containerLogNotFound(containerId);
            return -1;
        }
        return 0;
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogs(String containerIdStr, AggregatedLogFormat.LogReader reader, PrintStream out, long logUploadedTime) throws IOException {
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = reader.next(key);
        while (valueStream != null && !key.toString().equals(containerIdStr)) {
            key = new AggregatedLogFormat.LogKey();
            valueStream = reader.next(key);
        }
        if (valueStream == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        try {
            while (true) {
                AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out, logUploadedTime);
                foundContainerLogs = true;
            }
        }
        catch (EOFException eof) {
            if (foundContainerLogs) {
                return 0;
            }
            return -1;
        }
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogsForALogType(String containerIdStr, AggregatedLogFormat.LogReader reader, PrintStream out, long logUploadedTime, List<String> logType) throws IOException {
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = reader.next(key);
        while (valueStream != null && !key.toString().equals(containerIdStr)) {
            key = new AggregatedLogFormat.LogKey();
            valueStream = reader.next(key);
        }
        if (valueStream == null) {
            return -1;
        }
        boolean foundContainerLogs = false;
        try {
            while (true) {
                int result;
                if ((result = AggregatedLogFormat.LogReader.readContainerLogsForALogType(valueStream, out, logUploadedTime, logType)) != 0) {
                    continue;
                }
                foundContainerLogs = true;
            }
        }
        catch (EOFException eof) {
            if (foundContainerLogs) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int dumpAllContainersLogs(ApplicationId appId, String appOwner, PrintStream out) throws IOException {
        RemoteIterator<FileStatus> nodeFiles;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String user = appOwner;
        String logDirSuffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, logDirSuffix);
        try {
            Path qualifiedLogDir = FileContext.getFileContext(this.getConf()).makeQualified(remoteAppLogDir);
            nodeFiles = FileContext.getFileContext(qualifiedLogDir.toUri(), this.getConf()).listStatus(remoteAppLogDir);
        }
        catch (FileNotFoundException fnf) {
            LogCLIHelpers.logDirNotExist(remoteAppLogDir.toString());
            return -1;
        }
        boolean foundAnyLogs = false;
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = nodeFiles.next();
            if (thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
            try (AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), thisNodeFile.getPath());){
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    String containerString = "\n\nContainer: " + key + " on " + thisNodeFile.getPath().getName();
                    out.println(containerString);
                    out.println(StringUtils.repeat("=", containerString.length()));
                    try {
                        while (true) {
                            AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out, thisNodeFile.getModificationTime());
                            foundAnyLogs = true;
                        }
                    }
                    catch (EOFException eof) {
                        key = new AggregatedLogFormat.LogKey();
                        valueStream = reader.next(key);
                    }
                }
            }
        }
        if (!foundAnyLogs) {
            LogCLIHelpers.emptyLogDir(remoteAppLogDir.toString());
            return -1;
        }
        return 0;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    private static void containerLogNotFound(String containerId) {
        System.out.println("Logs for container " + containerId + " are not present in this log-file.");
    }

    private static void logDirNotExist(String remoteAppLogDir) {
        System.out.println(remoteAppLogDir + " does not exist.");
        System.out.println("Log aggregation has not completed or is not enabled.");
    }

    private static void emptyLogDir(String remoteAppLogDir) {
        System.out.println(remoteAppLogDir + " does not have any log files.");
    }
}

