/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeCLI
extends YarnCLI {
    private static final String NODES_PATTERN = "%16s\t%15s\t%17s\t%28s" + System.getProperty("line.separator");
    private static final String NODE_STATE_CMD = "states";
    private static final String NODE_ALL = "all";

    public static void main(String[] args) throws Exception {
        NodeCLI cli = new NodeCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run(cli, args);
        cli.stop();
        System.exit(res);
    }

    @Override
    public int run(String[] args) throws Exception {
        Options opts = new Options();
        opts.addOption("help", false, "Displays help for all commands.");
        opts.addOption("status", true, "Prints the status report of the node.");
        opts.addOption("list", false, "List all running nodes. Supports optional use of -states to filter nodes based on node state, all -all to list all nodes.");
        Option nodeStateOpt = new Option(NODE_STATE_CMD, true, "Works with -list to filter nodes based on input comma-separated list of node states.");
        nodeStateOpt.setValueSeparator(',');
        nodeStateOpt.setArgs(-2);
        nodeStateOpt.setArgName("States");
        opts.addOption(nodeStateOpt);
        Option allOpt = new Option(NODE_ALL, false, "Works with -list to list all nodes.");
        opts.addOption(allOpt);
        opts.getOption("status").setArgName("NodeId");
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(opts);
            return exitCode;
        }
        if (cliParser.hasOption("status")) {
            if (args.length != 2) {
                this.printUsage(opts);
                return exitCode;
            }
            this.printNodeStatus(cliParser.getOptionValue("status"));
        } else if (cliParser.hasOption("list")) {
            HashSet<NodeState> nodeStates = new HashSet<NodeState>();
            if (cliParser.hasOption(NODE_ALL)) {
                for (NodeState state : NodeState.values()) {
                    nodeStates.add(state);
                }
            } else if (cliParser.hasOption(NODE_STATE_CMD)) {
                String[] types = cliParser.getOptionValues(NODE_STATE_CMD);
                if (types != null) {
                    for (String type : types) {
                        if (type.trim().isEmpty()) continue;
                        nodeStates.add(NodeState.valueOf(org.apache.hadoop.util.StringUtils.toUpperCase(type.trim())));
                    }
                }
            } else {
                nodeStates.add(NodeState.RUNNING);
            }
            this.listClusterNodes(nodeStates);
        } else {
            if (cliParser.hasOption("help")) {
                this.printUsage(opts);
                return 0;
            }
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(opts);
        }
        return 0;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("node", opts);
    }

    private void listClusterNodes(Set<NodeState> nodeStates) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<NodeReport> nodesReport = this.client.getNodeReports(nodeStates.toArray(new NodeState[0]));
        writer.println("Total Nodes:" + nodesReport.size());
        writer.printf(NODES_PATTERN, "Node-Id", "Node-State", "Node-Http-Address", "Number-of-Running-Containers");
        for (NodeReport nodeReport : nodesReport) {
            writer.printf(NODES_PATTERN, new Object[]{nodeReport.getNodeId(), nodeReport.getNodeState(), nodeReport.getHttpAddress(), nodeReport.getNumContainers()});
        }
        writer.flush();
    }

    private void printNodeStatus(String nodeIdStr) throws YarnException, IOException {
        NodeId nodeId = ConverterUtils.toNodeId(nodeIdStr);
        List<NodeReport> nodesReport = this.client.getNodeReports(new NodeState[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter nodeReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        NodeReport nodeReport = null;
        for (NodeReport report : nodesReport) {
            if (!report.getNodeId().equals(nodeId)) continue;
            nodeReport = report;
            nodeReportStr.println("Node Report : ");
            nodeReportStr.print("\tNode-Id : ");
            nodeReportStr.println(nodeReport.getNodeId());
            nodeReportStr.print("\tRack : ");
            nodeReportStr.println(nodeReport.getRackName());
            nodeReportStr.print("\tNode-State : ");
            nodeReportStr.println((Object)nodeReport.getNodeState());
            nodeReportStr.print("\tNode-Http-Address : ");
            nodeReportStr.println(nodeReport.getHttpAddress());
            nodeReportStr.print("\tLast-Health-Update : ");
            nodeReportStr.println(DateFormatUtils.format(new Date(nodeReport.getLastHealthReportTime()), "E dd/MMM/yy hh:mm:ss:SSzz"));
            nodeReportStr.print("\tHealth-Report : ");
            nodeReportStr.println(nodeReport.getHealthReport());
            nodeReportStr.print("\tContainers : ");
            nodeReportStr.println(nodeReport.getNumContainers());
            nodeReportStr.print("\tMemory-Used : ");
            nodeReportStr.println(nodeReport.getUsed() == null ? "0MB" : nodeReport.getUsed().getMemory() + "MB");
            nodeReportStr.print("\tMemory-Capacity : ");
            nodeReportStr.println(nodeReport.getCapability().getMemory() + "MB");
            nodeReportStr.print("\tCPU-Used : ");
            nodeReportStr.println(nodeReport.getUsed() == null ? "0 vcores" : nodeReport.getUsed().getVirtualCores() + " vcores");
            nodeReportStr.print("\tCPU-Capacity : ");
            nodeReportStr.println(nodeReport.getCapability().getVirtualCores() + " vcores");
            nodeReportStr.print("\tNode-Labels : ");
            ArrayList<String> nodeLabelsList = new ArrayList<String>(report.getNodeLabels());
            Collections.sort(nodeLabelsList);
            nodeReportStr.println(StringUtils.join(nodeLabelsList.iterator(), ','));
        }
        if (nodeReport == null) {
            nodeReportStr.print("Could not find the node report for node id : " + nodeIdStr);
        }
        nodeReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
    }
}

