/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.utils.CloseableScheduledExecutorService;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ChildReaper
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Reaper reaper;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final CuratorFramework client;
    private final Collection<String> paths = ChildReaper.newConcurrentHashSet();
    private final Reaper.Mode mode;
    private final CloseableScheduledExecutorService executor;
    private final int reapingThresholdMs;
    private volatile Future<?> task;
    static final int DEFAULT_REAPING_THRESHOLD_MS = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);

    public static <E> Set<E> newConcurrentHashSet() {
        return Sets.newSetFromMap(new ConcurrentHashMap());
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode) {
        this(client, path, mode, ChildReaper.newExecutorService(), DEFAULT_REAPING_THRESHOLD_MS, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, int reapingThresholdMs) {
        this(client, path, mode, ChildReaper.newExecutorService(), reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs) {
        this(client, path, mode, executor, reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath) {
        this.client = client;
        this.mode = mode;
        this.executor = new CloseableScheduledExecutorService(executor);
        this.reapingThresholdMs = reapingThresholdMs;
        this.reaper = new Reaper(client, executor, reapingThresholdMs, leaderPath);
        this.addPath(path);
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.task = this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ChildReaper.this.doWork();
            }
        }, (long)this.reapingThresholdMs, (long)this.reapingThresholdMs, TimeUnit.MILLISECONDS);
        this.reaper.start();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CloseableUtils.closeQuietly((Closeable)this.reaper);
            this.task.cancel(true);
        }
    }

    public ChildReaper addPath(String path) {
        this.paths.add(PathUtils.validatePath((String)path));
        return this;
    }

    public boolean removePath(String path) {
        return this.paths.remove(PathUtils.validatePath((String)path));
    }

    private static ScheduledExecutorService newExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool((int)2, (String)"ChildReaper");
    }

    private void doWork() {
        for (String path : this.paths) {
            try {
                List children = (List)this.client.getChildren().forPath(path);
                for (String name : children) {
                    String thisPath = ZKPaths.makePath((String)path, (String)name);
                    Stat stat = (Stat)this.client.checkExists().forPath(thisPath);
                    if (stat == null || stat.getNumChildren() != 0) continue;
                    this.reaper.addPath(thisPath, this.mode);
                }
            }
            catch (Exception e) {
                this.log.error("Could not get children for path: " + path, e);
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

