/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import com.microsoft.windowsazure.storage.CloudStorageAccount;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import com.microsoft.windowsazure.storage.table.TableEntity;
import com.microsoft.windowsazure.storage.table.TableOperation;
import com.microsoft.windowsazure.storage.table.TablePayloadFormat;
import com.microsoft.windowsazure.storage.table.TableRequestOptions;
import com.microsoft.windowsazure.storage.table.TableServiceEntity;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class WindowsAzureTableSink
implements MetricsSink {
    private static final String STORAGE_ACCOUNT_KEY = "accountname";
    private static final String STORAGE_ACCESSKEY_KEY = "accesskey";
    private static final String STORAGE_SAS_KEY = "sas";
    private static final String AZURE_TABLENAME_KEY = "azureTable";
    private static final String AZURE_DEPLOYMENTID_KEY = "azureDeploymentId";
    private static final String AZURE_ROLENAME_KEY = "azureRole";
    private static final String AZURE_ROLEINSTANCENAME_KEY = "azureRoleInstance";
    private static final String STORAGE_PARTITON_KEY_TIMEFORMAT_KEY = "partitionKeyTimeFormat";
    private static Log logger = LogFactory.getLog(WindowsAzureTableSink.class);
    private HashMap<String, CloudTableClient> existingTables = new HashMap();
    private String deploymentId;
    private String roleName;
    private String roleInstanceName;
    private Boolean logDeploymentIdWithMetrics = false;
    private Boolean createMetricsTables = false;
    private Boolean useSas = false;
    private String storageAccountName;
    private String tableName;
    private String partitionKeyTimeFormat;
    private String storageAccountKey;
    private String storageAccountSas;

    @Override
    public void init(SubsetConfiguration conf) {
        logger.info("Entering init");
        this.storageAccountName = conf.getString(STORAGE_ACCOUNT_KEY);
        this.deploymentId = conf.getString(AZURE_DEPLOYMENTID_KEY);
        this.roleName = conf.getString(AZURE_ROLENAME_KEY);
        this.roleInstanceName = conf.getString(AZURE_ROLEINSTANCENAME_KEY);
        this.tableName = conf.getString(AZURE_TABLENAME_KEY);
        this.partitionKeyTimeFormat = conf.getString(STORAGE_PARTITON_KEY_TIMEFORMAT_KEY, "yyyyMMddHHmm");
        this.storageAccountKey = conf.getString(STORAGE_ACCESSKEY_KEY);
        this.storageAccountSas = conf.getString(STORAGE_SAS_KEY);
        if (this.storageAccountKey != null && !StringUtils.isEmpty(this.storageAccountKey)) {
            this.createMetricsTables = true;
            logger.info("Using full storageAccessKey. Will create tables if missing");
        } else if (this.storageAccountSas == null || StringUtils.isEmpty(this.storageAccountSas)) {
            logger.error("accesskey or sas missing in the metrics2 properties file");
        } else {
            this.useSas = true;
            this.createMetricsTables = false;
            logger.info("Using SAS. Will not create tables");
        }
        this.logDeploymentIdWithMetrics = this.deploymentId != null && !this.deploymentId.isEmpty() && this.roleName != null && !this.roleName.isEmpty() && this.roleInstanceName != null && !this.roleInstanceName.isEmpty();
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        CloudTableClient tableClient;
        String partitionKey;
        SimpleDateFormat formatter = new SimpleDateFormat(this.partitionKeyTimeFormat);
        String partitionKeySuffix = formatter.format(new Date());
        if (StringUtils.isEmpty(this.tableName)) {
            this.tableName = record.context().toUpperCase() + record.name();
        }
        HashMap<String, String> metrics2KeyValuePairs = new HashMap<String, String>();
        metrics2KeyValuePairs.put("MetricTimestamp", String.valueOf(record.timestamp()));
        metrics2KeyValuePairs.put("Context", record.context());
        metrics2KeyValuePairs.put("Name", record.name());
        metrics2KeyValuePairs.put("IPAddress", this.getLocalNodeIPAddress());
        if (this.logDeploymentIdWithMetrics.booleanValue()) {
            metrics2KeyValuePairs.put("DeploymentId", this.deploymentId);
            metrics2KeyValuePairs.put("Role", this.roleName);
            metrics2KeyValuePairs.put("RoleInstance", this.roleInstanceName);
            partitionKey = this.deploymentId + "-" + this.roleName + "-" + partitionKeySuffix;
        } else {
            partitionKey = this.getLocalNodeName();
        }
        for (MetricsTag tag : record.tags()) {
            metrics2KeyValuePairs.put(tag.name(), String.valueOf(tag.value()));
        }
        for (AbstractMetric metric : record.metrics()) {
            metrics2KeyValuePairs.put(metric.name(), metric.value().toString());
        }
        AzureTableMetrics2Entity metrics2Entity = new AzureTableMetrics2Entity(partitionKey, UUID.randomUUID().toString());
        metrics2Entity.setMetrics2KeyValuePairs(metrics2KeyValuePairs);
        try {
            tableClient = this.getTableClient(this.tableName);
        }
        catch (StorageException storageException) {
            logger.error(String.format("getTableClient failed. Details: %s, %s", new Object[]{storageException.getMessage(), storageException}));
            return;
        }
        catch (URISyntaxException syntaxException) {
            logger.error(String.format("getTableClient failed. Details: %s, %s", syntaxException.getMessage(), syntaxException));
            return;
        }
        TableOperation insertMetricOperation = TableOperation.insert((TableEntity)metrics2Entity, (boolean)true);
        try {
            TableRequestOptions requestOptions = new TableRequestOptions();
            requestOptions.setTablePayloadFormat(TablePayloadFormat.AtomPub);
            tableClient.execute(this.tableName, insertMetricOperation, requestOptions, null);
        }
        catch (StorageException storageException) {
            logger.error(String.format("tableClient.execute failed. Details: %s, %s", new Object[]{storageException.getMessage(), storageException}));
            return;
        }
    }

    @Override
    public void flush() {
    }

    private CloudTableClient getTableClient(String tableName) throws StorageException, URISyntaxException {
        CloudTableClient tableClient;
        if (this.existingTables.containsKey(tableName)) {
            return this.existingTables.get(tableName);
        }
        if (!this.useSas.booleanValue()) {
            StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(this.storageAccountName, this.storageAccountKey);
            CloudStorageAccount storageAccount = new CloudStorageAccount((StorageCredentials)credentials);
            tableClient = storageAccount.createCloudTableClient();
            logger.debug(String.format("tableClient via Fullkey. Endpoint = %s. Table = %s", tableClient.getStorageUri(), tableName));
        } else {
            URI tableBaseUri = new URI(String.format("https://%s.table.core.windows.net", this.storageAccountName));
            StorageCredentialsSharedAccessSignature sasCredentials = new StorageCredentialsSharedAccessSignature(this.storageAccountSas);
            tableClient = new CloudTableClient(tableBaseUri, (StorageCredentials)sasCredentials);
            logger.debug(String.format("tableClient via SASkey. Endpoint = %s. Table = %s", tableBaseUri, tableName));
        }
        CloudTable table = tableClient.getTableReference(tableName);
        if (this.createMetricsTables.booleanValue()) {
            boolean created = table.createIfNotExists();
            if (created) {
                logger.info(String.format("Created table '%s'", tableName));
            } else {
                logger.info(String.format("Table '%s' already exists", tableName));
            }
        }
        this.existingTables.put(tableName, tableClient);
        return tableClient;
    }

    private String getLocalNodeIPAddress() {
        String nodeIPAddress;
        try {
            nodeIPAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            nodeIPAddress = "Unknown";
        }
        return nodeIPAddress;
    }

    public String getLocalNodeName() {
        String nodeName;
        try {
            nodeName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            nodeName = "Unknown";
        }
        return nodeName;
    }

    private class AzureTableMetrics2Entity
    extends TableServiceEntity {
        private HashMap<String, String> metrics2KeyValuePairs;

        public AzureTableMetrics2Entity(String partitionKey, String rowKey) {
            this.partitionKey = partitionKey;
            this.rowKey = rowKey;
        }

        public void setMetrics2KeyValuePairs(HashMap<String, String> metrics2KeyValuePairs) {
            this.metrics2KeyValuePairs = metrics2KeyValuePairs;
        }

        public HashMap<String, EntityProperty> writeEntity(OperationContext opContext) {
            HashMap<String, EntityProperty> retVal = new HashMap<String, EntityProperty>();
            if (this.metrics2KeyValuePairs != null) {
                for (Map.Entry<String, String> keyValuePair : this.metrics2KeyValuePairs.entrySet()) {
                    String key = keyValuePair.getKey();
                    String newkey = this.sanitizeKey(key);
                    retVal.put(newkey, new EntityProperty(keyValuePair.getValue()));
                }
            }
            return retVal;
        }

        private String sanitizeKey(String originalKey) {
            if (originalKey.contains(" ")) {
                logger.debug("spaces found in metric key " + originalKey + ". Removing them.");
                return originalKey.replaceAll(" ", "");
            }
            return originalKey;
        }
    }
}

