/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

public class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("urlString", token.encodeToUrlString());
        return m;
    }

    public static Token<? extends TokenIdentifier> toToken(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m.get("urlString"));
        return token;
    }

    public static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m = (Map)json.get(Token.class.getSimpleName());
        return JsonUtil.toToken(m);
    }

    private static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m) throws IOException {
        return JsonUtil.toToken(m);
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("exception", e.getClass().getSimpleName());
        m.put("message", e.getMessage());
        m.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m);
    }

    public static RemoteException toRemoteException(Map<?, ?> json) {
        Map m = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m.get("message");
        String javaClassName = (String)m.get("javaClassName");
        return new RemoteException(javaClassName, message);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put(key, value);
        try {
            return MAPPER.writeValueAsString(m);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    private static FsPermission toFsPermission(String s, Boolean aclBit, Boolean encBit) {
        boolean eBit;
        FsPermission perm = new FsPermission(Short.parseShort(s, 8));
        boolean aBit = aclBit != null ? aclBit : false;
        boolean bl = eBit = encBit != null ? encBit : false;
        if (aBit || eBit) {
            return new FsPermissionExtension(perm, aBit, eBit);
        }
        return perm;
    }

    public static String toJsonString(HdfsFileStatus status, boolean includeType) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("pathSuffix", status.getLocalName());
        m.put("type", (Object)PathType.valueOf(status));
        if (status.isSymlink()) {
            m.put("symlink", status.getSymlink());
        }
        m.put("length", status.getLen());
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        FsPermission perm = status.getPermission();
        m.put("permission", JsonUtil.toString(perm));
        if (perm.getAclBit()) {
            m.put("aclBit", true);
        }
        if (perm.getEncryptedBit()) {
            m.put("encBit", true);
        }
        m.put("accessTime", status.getAccessTime());
        m.put("modificationTime", status.getModificationTime());
        m.put("blockSize", status.getBlockSize());
        m.put("replication", status.getReplication());
        m.put("fileId", status.getFileId());
        m.put("childrenNum", status.getChildrenNum());
        m.put("storagePolicy", status.getStoragePolicy());
        try {
            return includeType ? JsonUtil.toJsonString(FileStatus.class, m) : MAPPER.writeValueAsString(m);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m.get("pathSuffix");
        PathType type = PathType.valueOf((String)m.get("type"));
        byte[] symlink = type != PathType.SYMLINK ? null : DFSUtil.string2Bytes((String)m.get("symlink"));
        long len = ((Number)m.get("length")).longValue();
        String owner = (String)m.get("owner");
        String group = (String)m.get("group");
        FsPermission permission = JsonUtil.toFsPermission((String)m.get("permission"), (Boolean)m.get("aclBit"), (Boolean)m.get("encBit"));
        long aTime = ((Number)m.get("accessTime")).longValue();
        long mTime = ((Number)m.get("modificationTime")).longValue();
        long blockSize = ((Number)m.get("blockSize")).longValue();
        short replication = ((Number)m.get("replication")).shortValue();
        long fileId = m.containsKey("fileId") ? ((Number)m.get("fileId")).longValue() : 0L;
        int childrenNum = JsonUtil.getInt(m, "childrenNum", -1);
        byte storagePolicy = m.containsKey("storagePolicy") ? (byte)((Number)m.get("storagePolicy")).longValue() : (byte)0;
        return new HdfsFileStatus(len, type == PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtil.string2Bytes(localName), fileId, childrenNum, null, storagePolicy);
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockPoolId", extendedblock.getBlockPoolId());
        m.put("blockId", extendedblock.getBlockId());
        m.put("numBytes", extendedblock.getNumBytes());
        m.put("generationStamp", extendedblock.getGenerationStamp());
        return m;
    }

    private static ExtendedBlock toExtendedBlock(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        String blockPoolId = (String)m.get("blockPoolId");
        long blockId = ((Number)m.get("blockId")).longValue();
        long numBytes = ((Number)m.get("numBytes")).longValue();
        long generationStamp = ((Number)m.get("generationStamp")).longValue();
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("ipAddr", datanodeinfo.getIpAddr());
        m.put("name", datanodeinfo.getXferAddr());
        m.put("hostName", datanodeinfo.getHostName());
        m.put("storageID", datanodeinfo.getDatanodeUuid());
        m.put("xferPort", datanodeinfo.getXferPort());
        m.put("infoPort", datanodeinfo.getInfoPort());
        m.put("infoSecurePort", datanodeinfo.getInfoSecurePort());
        m.put("ipcPort", datanodeinfo.getIpcPort());
        m.put("capacity", datanodeinfo.getCapacity());
        m.put("dfsUsed", datanodeinfo.getDfsUsed());
        m.put("remaining", datanodeinfo.getRemaining());
        m.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m.put("cacheCapacity", datanodeinfo.getCacheCapacity());
        m.put("cacheUsed", datanodeinfo.getCacheUsed());
        m.put("lastUpdate", datanodeinfo.getLastUpdate());
        m.put("lastUpdateMonotonic", datanodeinfo.getLastUpdateMonotonic());
        m.put("xceiverCount", datanodeinfo.getXceiverCount());
        m.put("networkLocation", datanodeinfo.getNetworkLocation());
        m.put("adminState", datanodeinfo.getAdminState().name());
        return m;
    }

    private static int getInt(Map<?, ?> m, String key, int defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    private static long getLong(Map<?, ?> m, String key, long defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    private static String getString(Map<?, ?> m, String key, String defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    static List<?> getList(Map<?, ?> m, String key) {
        Object list = m.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m) throws IOException {
        String ipAddr;
        if (m == null) {
            return null;
        }
        int xferPort = JsonUtil.getInt(m, "xferPort", -1);
        Object tmpValue = m.get("ipAddr");
        String string = ipAddr = tmpValue == null ? null : (String)tmpValue;
        if (ipAddr == null) {
            tmpValue = m.get("name");
            if (tmpValue == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            String name = (String)tmpValue;
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo(ipAddr, (String)m.get("hostName"), (String)m.get("storageID"), xferPort, ((Number)m.get("infoPort")).intValue(), JsonUtil.getInt(m, "infoSecurePort", 0), ((Number)m.get("ipcPort")).intValue(), JsonUtil.getLong(m, "capacity", 0L), JsonUtil.getLong(m, "dfsUsed", 0L), JsonUtil.getLong(m, "remaining", 0L), JsonUtil.getLong(m, "blockPoolUsed", 0L), JsonUtil.getLong(m, "cacheCapacity", 0L), JsonUtil.getLong(m, "cacheUsed", 0L), JsonUtil.getLong(m, "lastUpdate", 0L), JsonUtil.getLong(m, "lastUpdateMonotonic", 0L), JsonUtil.getInt(m, "xceiverCount", 0), JsonUtil.getString(m, "networkLocation", ""), DatanodeInfo.AdminStates.valueOf(JsonUtil.getString(m, "adminState", "NORMAL")));
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static DatanodeInfo[] toDatanodeInfoArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = JsonUtil.toDatanodeInfo((Map)object);
        }
        return array;
    }

    private static Object[] toJsonArray(StorageType[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    static StorageType[] toStorageTypeArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return StorageType.EMPTY_ARRAY;
        }
        StorageType[] array = new StorageType[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = StorageType.parseStorageType(object.toString());
        }
        return array;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockToken", JsonUtil.toJsonMap(locatedblock.getBlockToken()));
        m.put("isCorrupt", locatedblock.isCorrupt());
        m.put("startOffset", locatedblock.getStartOffset());
        m.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m.put("storageTypes", JsonUtil.toJsonArray(locatedblock.getStorageTypes()));
        m.put("locations", JsonUtil.toJsonArray(locatedblock.getLocations()));
        m.put("cachedLocations", JsonUtil.toJsonArray(locatedblock.getCachedLocations()));
        return m;
    }

    private static LocatedBlock toLocatedBlock(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        ExtendedBlock b = JsonUtil.toExtendedBlock((Map)m.get("block"));
        DatanodeInfo[] locations = JsonUtil.toDatanodeInfoArray(JsonUtil.getList(m, "locations"));
        long startOffset = ((Number)m.get("startOffset")).longValue();
        boolean isCorrupt = (Boolean)m.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtil.toDatanodeInfoArray(JsonUtil.getList(m, "cachedLocations"));
        StorageType[] storageTypes = JsonUtil.toStorageTypeArray(JsonUtil.getList(m, "storageTypes"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, storageTypes, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtil.toBlockToken((Map)m.get("blockToken")));
        return locatedblock;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    private static List<LocatedBlock> toLocatedBlockList(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.size());
        for (Object object : objects) {
            list.add(JsonUtil.toLocatedBlock((Map)object));
        }
        return list;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("fileLength", locatedblocks.getFileLength());
        m.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m);
    }

    public static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = ((Number)m.get("fileLength")).longValue();
        boolean isUnderConstruction = (Boolean)m.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtil.toLocatedBlockList(JsonUtil.getList(m, "locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtil.toLocatedBlock((Map)m.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete, null);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Long> m = new TreeMap<String, Long>();
        m.put("length", contentsummary.getLength());
        m.put("fileCount", contentsummary.getFileCount());
        m.put("directoryCount", contentsummary.getDirectoryCount());
        m.put("quota", contentsummary.getQuota());
        m.put("spaceConsumed", contentsummary.getSpaceConsumed());
        m.put("spaceQuota", contentsummary.getSpaceQuota());
        return JsonUtil.toJsonString(ContentSummary.class, m);
    }

    public static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = ((Number)m.get("length")).longValue();
        long fileCount = ((Number)m.get("fileCount")).longValue();
        long directoryCount = ((Number)m.get("directoryCount")).longValue();
        long quota = ((Number)m.get("quota")).longValue();
        long spaceConsumed = ((Number)m.get("spaceConsumed")).longValue();
        long spaceQuota = ((Number)m.get("spaceQuota")).longValue();
        return new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("algorithm", checksum.getAlgorithmName());
        m.put("length", checksum.getLength());
        m.put("bytes", StringUtils.byteToHexString(checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m);
    }

    public static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32FileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m.get("algorithm");
        int length = ((Number)m.get("length")).intValue();
        byte[] bytes = StringUtils.hexStringToByte((String)m.get("bytes"));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName(algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields(in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    public static String toJsonString(AclStatus status) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        m.put("stickyBit", status.isStickyBit());
        ArrayList<String> stringEntries = new ArrayList<String>();
        for (AclEntry entry : status.getEntries()) {
            stringEntries.add(entry.toString());
        }
        m.put("entries", stringEntries);
        FsPermission perm = status.getPermission();
        if (perm != null) {
            m.put("permission", JsonUtil.toString(perm));
            if (perm.getAclBit()) {
                m.put("aclBit", true);
            }
            if (perm.getEncryptedBit()) {
                m.put("encBit", true);
            }
        }
        TreeMap<String, TreeMap<String, Object>> finalMap = new TreeMap<String, TreeMap<String, Object>>();
        finalMap.put(AclStatus.class.getSimpleName(), m);
        try {
            return MAPPER.writeValueAsString(finalMap);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m.get("owner"));
        aclStatusBuilder.group((String)m.get("group"));
        aclStatusBuilder.stickyBit((Boolean)m.get("stickyBit"));
        String permString = (String)m.get("permission");
        if (permString != null) {
            FsPermission permission = JsonUtil.toFsPermission(permString, (Boolean)m.get("aclBit"), (Boolean)m.get("encBit"));
            aclStatusBuilder.setPermission(permission);
        }
        List entries = (List)m.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (Object entry : entries) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)entry, true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    private static Map<String, Object> toJsonMap(XAttr xAttr, XAttrCodec encoding) throws IOException {
        if (xAttr == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("name", XAttrHelper.getPrefixName(xAttr));
        m.put("value", xAttr.getValue() != null ? XAttrCodec.encodeValue(xAttr.getValue(), encoding) : null);
        return m;
    }

    private static Object[] toJsonArray(List<XAttr> array, XAttrCodec encoding) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i), encoding);
        }
        return a;
    }

    public static String toJsonString(List<XAttr> xAttrs, XAttrCodec encoding) throws IOException {
        TreeMap<String, Object[]> finalMap = new TreeMap<String, Object[]>();
        finalMap.put("XAttrs", JsonUtil.toJsonArray(xAttrs, encoding));
        return MAPPER.writeValueAsString(finalMap);
    }

    public static String toJsonString(List<XAttr> xAttrs) throws IOException {
        ArrayList<String> names = Lists.newArrayListWithCapacity(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            names.add(XAttrHelper.getPrefixName(xAttr));
        }
        String ret = MAPPER.writeValueAsString(names);
        TreeMap<String, String> finalMap = new TreeMap<String, String>();
        finalMap.put("XAttrNames", ret);
        return MAPPER.writeValueAsString(finalMap);
    }

    public static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtil.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    public static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtil.toXAttrMap(JsonUtil.getList(json, "XAttrs"));
    }

    public static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        ObjectReader reader = new ObjectMapper().reader(List.class);
        List xattrs = (List)reader.readValue(namesInJson);
        ArrayList<String> names = Lists.newArrayListWithCapacity(json.keySet().size());
        for (Object xattr : xattrs) {
            names.add((String)xattr);
        }
        return names;
    }

    private static Map<String, byte[]> toXAttrMap(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, byte[]> xAttrs = Maps.newHashMap();
        for (Object object : objects) {
            Map m = (Map)object;
            String name = (String)m.get("name");
            String value = (String)m.get("value");
            xAttrs.put(name, JsonUtil.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    private static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue(value);
        }
        return new byte[0];
    }

    static String getPath(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String path = (String)json.get("Path");
        return path;
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    static enum PathType {
        FILE,
        DIRECTORY,
        SYMLINK;


        static PathType valueOf(HdfsFileStatus status) {
            return status.isDir() ? DIRECTORY : (status.isSymlink() ? SYMLINK : FILE);
        }
    }
}

