/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RegionNormalizerProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class RegionNormalizerTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(RegionNormalizerTracker.class);

    public RegionNormalizerTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getRegionNormalizerZNode(), abortable);
    }

    public boolean isNormalizerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getNormalizerOn();
        }
        catch (DeserializationException dex) {
            LOG.error("ZK state for RegionNormalizer could not be parsed " + Bytes.toStringBinary(upData));
            return false;
        }
    }

    public void setNormalizerOn(boolean normalizerOn) throws KeeperException {
        byte[] upData = this.toByteArray(normalizerOn);
        try {
            ZKUtil.setData(this.watcher, this.watcher.getRegionNormalizerZNode(), upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.getRegionNormalizerZNode(), upData);
        }
        super.nodeDataChanged(this.watcher.getRegionNormalizerZNode());
    }

    private byte[] toByteArray(boolean isNormalizerOn) {
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        builder.setNormalizerOn(isNormalizerOn);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    private RegionNormalizerProtos.RegionNormalizerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        RegionNormalizerProtos.RegionNormalizerState.Builder builder = RegionNormalizerProtos.RegionNormalizerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build();
    }
}

