/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class MapreduceDependencyClasspathTool
implements Tool {
    private Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length > 0) {
            System.err.println("Usage: hbase mapredcp [-Dtmpjars=...]");
            System.err.println("  Construct a CLASSPATH containing dependency jars required to run a mapreduce");
            System.err.println("  job. By default, includes any jars detected by TableMapReduceUtils. Provide");
            System.err.println("  additional entries by specifying a comma-separated list in tmpjars.");
            return 0;
        }
        TableMapReduceUtil.addHBaseDependencyJars(this.getConf());
        System.out.println(TableMapReduceUtil.buildDependencyClasspath(this.getConf()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        Logger logger = Logger.getLogger("org.apache.hadoop.hbase");
        if (logger != null) {
            logger.setLevel(Level.WARN);
        }
        System.exit(ToolRunner.run(HBaseConfiguration.create(), new MapreduceDependencyClasspathTool(), argv));
    }
}

