/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ByteStringer {
    private static final Log LOG = LogFactory.getLog(ByteStringer.class);
    private static boolean USE_ZEROCOPYBYTESTRING = true;

    private ByteStringer() {
    }

    public static ByteString wrap(byte[] array) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array) : ByteString.copyFrom(array);
    }

    public static ByteString wrap(byte[] array, int offset, int length) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array, offset, length) : ByteString.copyFrom(array, offset, length);
    }

    static {
        try {
            HBaseZeroCopyByteString.wrap(new byte[0]);
        }
        catch (IllegalAccessError iae) {
            USE_ZEROCOPYBYTESTRING = false;
            LOG.debug("Failed to classload HBaseZeroCopyByteString: " + iae.toString());
        }
    }
}

