/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;

@InterfaceAudience.Private
class VisibilityLabelFilter
extends FilterBase {
    private final VisibilityExpEvaluator expEvaluator;
    private final Map<ByteRange, Integer> cfVsMaxVersions;
    private final ByteRange curFamily;
    private final ByteRange curQualifier;
    private int curFamilyMaxVersions;
    private int curQualMetVersions;

    public VisibilityLabelFilter(VisibilityExpEvaluator expEvaluator, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.expEvaluator = expEvaluator;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.curFamily = new SimpleMutableByteRange();
        this.curQualifier = new SimpleMutableByteRange();
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        if (this.curFamily.getBytes() == null || Bytes.compareTo(this.curFamily.getBytes(), this.curFamily.getOffset(), this.curFamily.getLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()) != 0) {
            this.curFamily.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            this.curFamilyMaxVersions = this.cfVsMaxVersions.get(this.curFamily);
            this.curQualifier.unset();
        }
        if (this.curQualifier.getBytes() == null || Bytes.compareTo(this.curQualifier.getBytes(), this.curQualifier.getOffset(), this.curQualifier.getLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()) != 0) {
            this.curQualifier.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.curQualMetVersions = 0;
        }
        ++this.curQualMetVersions;
        if (this.curQualMetVersions > this.curFamilyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        return this.expEvaluator.evaluate(cell) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public void reset() throws IOException {
        this.curFamily.unset();
        this.curQualifier.unset();
        this.curFamilyMaxVersions = 0;
        this.curQualMetVersions = 0;
    }
}

