/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;

@InterfaceAudience.Private
public class SplitNormalizationPlan
implements NormalizationPlan {
    private static final Log LOG = LogFactory.getLog(SplitNormalizationPlan.class.getName());
    private HRegionInfo regionInfo;
    private byte[] splitPoint;

    public SplitNormalizationPlan(HRegionInfo regionInfo, byte[] splitPoint) {
        this.regionInfo = regionInfo;
        this.splitPoint = splitPoint;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public void setRegionInfo(HRegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public byte[] getSplitPoint() {
        return this.splitPoint;
    }

    public void setSplitPoint(byte[] splitPoint) {
        this.splitPoint = splitPoint;
    }

    public String toString() {
        return "SplitNormalizationPlan{regionInfo=" + this.regionInfo + ", splitPoint=" + Arrays.toString(this.splitPoint) + '}';
    }

    @Override
    public void execute(Admin admin) {
        LOG.info("Executing splitting normalization plan: " + this);
        try {
            admin.splitRegion(this.regionInfo.getRegionName());
        }
        catch (IOException ex) {
            LOG.error("Error during region split: ", ex);
        }
    }
}

