/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class HFileLinkCleaner
extends BaseHFileCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(HFileLinkCleaner.class);
    private FileSystem fs = null;

    @Override
    public synchronized boolean isFileDeletable(FileStatus fStat) {
        if (this.fs == null) {
            return false;
        }
        Path filePath = fStat.getPath();
        if (HFileLink.isHFileLink(filePath)) {
            return true;
        }
        Path parentDir = filePath.getParent();
        if (HFileLink.isBackReferencesDir(parentDir)) {
            Path hfilePath = null;
            try {
                hfilePath = HFileLink.getHFileFromBackReference(new Path(FSUtils.getRootDir(this.getConf()), ".tmp"), filePath);
                if (this.fs.exists(hfilePath)) {
                    return false;
                }
                hfilePath = HFileLink.getHFileFromBackReference(FSUtils.getRootDir(this.getConf()), filePath);
                return !this.fs.exists(hfilePath);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Couldn't verify if the referenced file still exists, keep it just in case: " + hfilePath);
                }
                return false;
            }
        }
        Path backRefDir = null;
        try {
            backRefDir = HFileLink.getBackReferencesDir(parentDir, filePath.getName());
            return FSUtils.listStatus(this.fs, backRefDir) == null;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't get the references, not deleting file, just in case. filePath=" + filePath + ", backRefDir=" + backRefDir);
            }
            return false;
        }
    }

    @Override
    public void setConf(Configuration conf) {
        block2: {
            super.setConf(conf);
            try {
                this.fs = FileSystem.get(this.getConf());
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Couldn't instantiate the file system, not deleting file, just in case. fs.defaultFS=" + this.getConf().get("fs.defaultFS", "file:///"));
            }
        }
    }
}

