/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc.controller;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.DelegatingPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;

class MetadataRpcController
extends DelegatingPayloadCarryingRpcController {
    private int priority;
    private static final List<String> SYSTEM_TABLE_NAMES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME)).add(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME)).add(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME)).build();

    public MetadataRpcController(PayloadCarryingRpcController delegate, Configuration conf) {
        super(delegate);
        this.priority = PhoenixRpcSchedulerFactory.getMetadataPriority(conf);
    }

    @Override
    public void setPriority(TableName tn) {
        if (SYSTEM_TABLE_NAMES.contains(tn.getNameAsString())) {
            this.setPriority(this.priority);
        } else {
            super.setPriority(tn);
        }
    }
}

