/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PrefixFilter
extends FilterBase {
    protected byte[] prefix = null;
    protected boolean passedPrefix = false;
    protected boolean filterRow = true;

    public PrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.prefix == null) {
            return true;
        }
        if (length < this.prefix.length) {
            return true;
        }
        int cmp = Bytes.compareTo(buffer, offset, this.prefix.length, this.prefix, 0, this.prefix.length);
        if (!this.isReversed() && cmp > 0 || this.isReversed() && cmp < 0) {
            this.passedPrefix = true;
        }
        this.filterRow = cmp != 0;
        return this.filterRow;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.filterRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public boolean filterRow() {
        return this.filterRow;
    }

    @Override
    public void reset() {
        this.filterRow = true;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.passedPrefix;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] prefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new PrefixFilter(prefix);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.PrefixFilter.Builder builder = FilterProtos.PrefixFilter.newBuilder();
        if (this.prefix != null) {
            builder.setPrefix(ByteStringer.wrap(this.prefix));
        }
        return builder.build().toByteArray();
    }

    public static PrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.PrefixFilter proto;
        try {
            proto = FilterProtos.PrefixFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new PrefixFilter(proto.hasPrefix() ? proto.getPrefix().toByteArray() : null);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefixFilter)) {
            return false;
        }
        PrefixFilter other = (PrefixFilter)o;
        return Bytes.equals(this.getPrefix(), other.getPrefix());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.prefix);
    }
}

