/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.conf.Reconfigurable;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.util.Time;

public abstract class ReconfigurableBase
extends Configured
implements Reconfigurable {
    private static final Log LOG = LogFactory.getLog(ReconfigurableBase.class);
    private ReconfigurationUtil reconfigurationUtil = new ReconfigurationUtil();
    private Thread reconfigThread = null;
    private volatile boolean shouldRun = true;
    private Object reconfigLock = new Object();
    private long startTime = 0L;
    private long endTime = 0L;
    private Map<ReconfigurationUtil.PropertyChange, Optional<String>> status = null;

    public ReconfigurableBase() {
        super(new Configuration());
    }

    public ReconfigurableBase(Configuration conf) {
        super(conf == null ? new Configuration() : conf);
    }

    @VisibleForTesting
    public void setReconfigurationUtil(ReconfigurationUtil ru) {
        this.reconfigurationUtil = Preconditions.checkNotNull(ru);
    }

    @VisibleForTesting
    public Collection<ReconfigurationUtil.PropertyChange> getChangedProperties(Configuration newConf, Configuration oldConf) {
        return this.reconfigurationUtil.parseChangedProperties(newConf, oldConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconfigurationTask() throws IOException {
        Object object = this.reconfigLock;
        synchronized (object) {
            if (!this.shouldRun) {
                String errorMessage = "The server is stopped.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            if (this.reconfigThread != null) {
                String errorMessage = "Another reconfiguration task is running.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            this.reconfigThread = new ReconfigurationThread(this);
            this.reconfigThread.setDaemon(true);
            this.reconfigThread.setName("Reconfiguration Task");
            this.reconfigThread.start();
            this.startTime = Time.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconfigurationTaskStatus getReconfigurationTaskStatus() {
        Object object = this.reconfigLock;
        synchronized (object) {
            if (this.reconfigThread != null) {
                return new ReconfigurationTaskStatus(this.startTime, 0L, null);
            }
            return new ReconfigurationTaskStatus(this.startTime, this.endTime, this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReconfigurationTask() {
        Thread tempThread;
        Object object = this.reconfigLock;
        synchronized (object) {
            this.shouldRun = false;
            if (this.reconfigThread == null) {
                return;
            }
            tempThread = this.reconfigThread;
            this.reconfigThread = null;
        }
        try {
            tempThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String reconfigureProperty(String property, String newVal) throws ReconfigurationException {
        if (this.isPropertyReconfigurable(property)) {
            String oldVal;
            LOG.info("changing property " + property + " to " + newVal);
            Configuration configuration = this.getConf();
            synchronized (configuration) {
                oldVal = this.getConf().get(property);
                this.reconfigurePropertyImpl(property, newVal);
                if (newVal != null) {
                    this.getConf().set(property, newVal);
                } else {
                    this.getConf().unset(property);
                }
            }
            return oldVal;
        }
        throw new ReconfigurationException(property, newVal, this.getConf().get(property));
    }

    @Override
    public abstract Collection<String> getReconfigurableProperties();

    @Override
    public boolean isPropertyReconfigurable(String property) {
        return this.getReconfigurableProperties().contains(property);
    }

    protected abstract void reconfigurePropertyImpl(String var1, String var2) throws ReconfigurationException;

    private static class ReconfigurationThread
    extends Thread {
        private ReconfigurableBase parent;

        ReconfigurationThread(ReconfigurableBase base) {
            this.parent = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Starting reconfiguration task.");
            Configuration oldConf = this.parent.getConf();
            Configuration newConf = new Configuration();
            Collection<ReconfigurationUtil.PropertyChange> changes = this.parent.getChangedProperties(newConf, oldConf);
            HashMap<ReconfigurationUtil.PropertyChange, Optional<String>> results = Maps.newHashMap();
            for (ReconfigurationUtil.PropertyChange change : changes) {
                String errorMessage = null;
                if (!this.parent.isPropertyReconfigurable(change.prop)) {
                    errorMessage = "Property " + change.prop + " is not reconfigurable";
                    LOG.info(errorMessage);
                    results.put(change, Optional.of(errorMessage));
                    continue;
                }
                LOG.info("Change property: " + change.prop + " from \"" + (change.oldVal == null ? "<default>" : change.oldVal) + "\" to \"" + (change.newVal == null ? "<default>" : change.newVal) + "\".");
                try {
                    this.parent.reconfigurePropertyImpl(change.prop, change.newVal);
                }
                catch (ReconfigurationException e) {
                    errorMessage = e.getCause().getMessage();
                }
                results.put(change, Optional.fromNullable(errorMessage));
            }
            Object object = this.parent.reconfigLock;
            synchronized (object) {
                this.parent.endTime = Time.now();
                this.parent.status = Collections.unmodifiableMap(results);
                this.parent.reconfigThread = null;
            }
        }
    }
}

