/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.management;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AbstractSliderResource;
import org.apache.slider.server.appmaster.web.rest.management.resources.AggregateConfResource;
import org.apache.slider.server.appmaster.web.rest.management.resources.ConfTreeResource;
import org.apache.slider.server.appmaster.web.rest.management.resources.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementResource
extends AbstractSliderResource {
    protected static final Logger log = LoggerFactory.getLogger(ManagementResource.class);
    public static final String CONFIG = "config";
    public static final String APP_UNDER_MANAGEMENT = "/app";

    public ManagementResource(WebAppApi slider) {
        super(slider);
    }

    private void init(HttpServletResponse res) {
        res.setContentType(null);
    }

    @GET
    public Response getWadl(@Context HttpServletRequest request) {
        return this.redirectToAppWadl(request);
    }

    @GET
    @Path(value="/app")
    @Produces(value={"application/json", "application/xml"})
    public AggregateConfResource getAggregateConfiguration(@Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res);
        return ResourceFactory.createAggregateConfResource(this.getAggregateConf(), uriInfo.getAbsolutePathBuilder());
    }

    @GET
    @Path(value="/app/configurations/{config}")
    @Produces(value={"application/json", "application/xml"})
    public ConfTreeResource getConfTreeResource(@PathParam(value="config") String config, @Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res);
        AggregateConfResource aggregateConf = ResourceFactory.createAggregateConfResource(this.getAggregateConf(), uriInfo.getBaseUriBuilder().path("/ws/v1/slider").path("mgmt/app"));
        return aggregateConf.getConfTree(config);
    }

    protected AggregateConf getAggregateConf() {
        return this.slider.getAppState().getInstanceDefinitionSnapshot();
    }
}

