/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.annotations.VisibleForTesting;
import org.apache.slider.api.types.NodeEntryInformation;
import org.apache.slider.server.appmaster.state.ContainerOutcome;
import org.apache.slider.server.appmaster.state.RoleHistoryUtils;

public class NodeEntry
implements Cloneable {
    public final int rolePriority;
    private int requested;
    private int starting;
    private int startFailed;
    private int failed;
    private int failedRecently;
    private int preempted;
    private int live;
    private int releasing;
    private long lastUsed;

    public NodeEntry(int rolePriority) {
        this.rolePriority = rolePriority;
    }

    public synchronized boolean isAvailable() {
        return this.live + this.requested + this.starting - this.releasing <= 0;
    }

    public synchronized boolean isAntiAffinityConstraintHeld() {
        return this.live - this.releasing + this.starting <= 1;
    }

    public synchronized int getActive() {
        return this.live - this.releasing;
    }

    public synchronized boolean notUsedSince(long absoluteTime) {
        return this.isAvailable() && this.lastUsed < absoluteTime;
    }

    public synchronized int getLive() {
        return this.live;
    }

    public int getStarting() {
        return this.starting;
    }

    public synchronized void setLive(int v) {
        this.live = v;
    }

    private synchronized void incLive() {
        ++this.live;
    }

    private synchronized void decLive() {
        this.live = RoleHistoryUtils.decToFloor(this.live);
    }

    public synchronized void onStarting() {
        ++this.starting;
    }

    private void decStarting() {
        this.starting = RoleHistoryUtils.decToFloor(this.starting);
    }

    public synchronized void onStartCompleted() {
        this.decStarting();
        this.incLive();
    }

    public synchronized boolean onStartFailed() {
        this.decStarting();
        ++this.startFailed;
        return this.containerCompleted(false, ContainerOutcome.Failed);
    }

    public synchronized int getRequested() {
        return this.requested;
    }

    public synchronized void request() {
        ++this.requested;
    }

    public synchronized void requestCompleted() {
        this.requested = RoleHistoryUtils.decToFloor(this.requested);
    }

    public synchronized int getReleasing() {
        return this.releasing;
    }

    public synchronized void release() {
        ++this.releasing;
    }

    public synchronized boolean containerCompleted(boolean wasReleased, ContainerOutcome outcome) {
        if (wasReleased) {
            this.releasing = RoleHistoryUtils.decToFloor(this.releasing);
        } else {
            switch (outcome) {
                case Failed: 
                case Node_failure: {
                    ++this.failed;
                    ++this.failedRecently;
                    break;
                }
                case Preempted: {
                    ++this.preempted;
                    break;
                }
            }
        }
        this.decLive();
        return this.isAvailable();
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public synchronized int getStartFailed() {
        return this.startFailed;
    }

    public synchronized int getFailed() {
        return this.failed;
    }

    public synchronized int getFailedRecently() {
        return this.failedRecently;
    }

    @VisibleForTesting
    public synchronized void setFailedRecently(int failedRecently) {
        this.failedRecently = failedRecently;
    }

    public synchronized int getPreempted() {
        return this.preempted;
    }

    public void resetFailedRecently() {
        this.failedRecently = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeEntry{");
        sb.append("priority=").append(this.rolePriority);
        sb.append(", requested=").append(this.requested);
        sb.append(", starting=").append(this.starting);
        sb.append(", live=").append(this.live);
        sb.append(", releasing=").append(this.releasing);
        sb.append(", lastUsed=").append(this.lastUsed);
        sb.append(", failedRecently=").append(this.failedRecently);
        sb.append(", preempted=").append(this.preempted);
        sb.append(", startFailed=").append(this.startFailed);
        sb.append('}');
        return sb.toString();
    }

    public synchronized NodeEntryInformation serialize() {
        NodeEntryInformation info = new NodeEntryInformation();
        info.priority = this.rolePriority;
        info.requested = this.requested;
        info.releasing = this.releasing;
        info.starting = this.starting;
        info.startFailed = this.startFailed;
        info.failed = this.failed;
        info.failedRecently = this.failedRecently;
        info.preempted = this.preempted;
        info.live = this.live;
        info.lastUsed = this.lastUsed;
        return info;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

