/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.rpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.api.proto.Messages;
import org.apache.slider.server.appmaster.rpc.SliderClusterProtocolPB;

public class SliderClusterProtocolProxy
implements SliderClusterProtocol {
    private static final RpcController NULL_CONTROLLER = null;
    private final SliderClusterProtocolPB endpoint;
    private final InetSocketAddress address;

    public SliderClusterProtocolProxy(SliderClusterProtocolPB endpoint, InetSocketAddress address) {
        Preconditions.checkArgument(endpoint != null, "null endpoint");
        Preconditions.checkNotNull(address != null, "null address");
        this.endpoint = endpoint;
        this.address = address;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SliderClusterProtocolProxy{");
        sb.append("address=").append(this.address);
        sb.append('}');
        return sb.toString();
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        if (!protocol.equals(RPC.getProtocolName(SliderClusterProtocolPB.class))) {
            throw new IOException("Serverside implements " + RPC.getProtocolName(SliderClusterProtocolPB.class) + ". The following requested protocol is unknown: " + protocol);
        }
        return ProtocolSignature.getProtocolSignature((int)clientMethodsHash, (long)RPC.getProtocolVersion(SliderClusterProtocol.class), SliderClusterProtocol.class);
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    private IOException convert(ServiceException se) {
        IOException ioe = ProtobufHelper.getRemoteException((ServiceException)se);
        if (ioe instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)ioe;
            return remoteException.unwrapRemoteException();
        }
        return ioe;
    }

    @Override
    public Messages.StopClusterResponseProto stopCluster(Messages.StopClusterRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.stopCluster(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.UpgradeContainersResponseProto upgradeContainers(Messages.UpgradeContainersRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.upgradeContainers(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.FlexClusterResponseProto flexCluster(Messages.FlexClusterRequestProto request) throws IOException {
        try {
            return this.endpoint.flexCluster(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetJSONClusterStatusResponseProto getJSONClusterStatus(Messages.GetJSONClusterStatusRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.getJSONClusterStatus(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetInstanceDefinitionResponseProto getInstanceDefinition(Messages.GetInstanceDefinitionRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.getInstanceDefinition(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.ListNodeUUIDsByRoleResponseProto listNodeUUIDsByRole(Messages.ListNodeUUIDsByRoleRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.listNodeUUIDsByRole(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetNodeResponseProto getNode(Messages.GetNodeRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.getNode(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetClusterNodesResponseProto getClusterNodes(Messages.GetClusterNodesRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.getClusterNodes(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.EchoResponseProto echo(Messages.EchoRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.echo(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.KillContainerResponseProto killContainer(Messages.KillContainerRequestProto request) throws IOException, YarnException {
        try {
            return this.endpoint.killContainer(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.AMSuicideResponseProto amSuicide(Messages.AMSuicideRequestProto request) throws IOException {
        try {
            return this.endpoint.amSuicide(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.ApplicationLivenessInformationProto getLivenessInformation(Messages.GetApplicationLivenessRequestProto request) throws IOException {
        try {
            return this.endpoint.getLivenessInformation(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetLiveContainersResponseProto getLiveContainers(Messages.GetLiveContainersRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveContainers(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.ContainerInformationProto getLiveContainer(Messages.GetLiveContainerRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveContainer(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetLiveComponentsResponseProto getLiveComponents(Messages.GetLiveComponentsRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveComponents(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.ComponentInformationProto getLiveComponent(Messages.GetLiveComponentRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveComponent(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetLiveNodesResponseProto getLiveNodes(Messages.GetLiveNodesRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveNodes(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.NodeInformationProto getLiveNode(Messages.GetLiveNodeRequestProto request) throws IOException {
        try {
            return this.endpoint.getLiveNode(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelDesired(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelDesired(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelDesiredAppconf(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelDesiredAppconf(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelDesiredResources(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelDesiredResources(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelResolved(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelResolved(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelResolvedAppconf(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelResolvedAppconf(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getModelResolvedResources(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getModelResolvedResources(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.WrappedJsonProto getLiveResources(Messages.EmptyPayloadProto request) throws IOException {
        try {
            return this.endpoint.getLiveResources(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }

    @Override
    public Messages.GetCertificateStoreResponseProto getClientCertificateStore(Messages.GetCertificateStoreRequestProto request) throws IOException {
        try {
            return this.endpoint.getClientCertificateStore(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw this.convert(e);
        }
    }
}

