/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.AbstractClientProvider;
import org.apache.slider.providers.ProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SliderProviderFactory
extends Configured {
    public static final String DEFAULT_CLUSTER_TYPE = "agent";
    protected static final Logger log = LoggerFactory.getLogger(SliderProviderFactory.class);
    public static final String PROVIDER_NOT_FOUND = "Unable to find provider of application type %s";

    public SliderProviderFactory(Configuration conf) {
        super(conf);
    }

    protected SliderProviderFactory() {
    }

    public abstract AbstractClientProvider createClientProvider();

    public abstract ProviderService createServerProvider();

    public static SliderProviderFactory createSliderProviderFactory(String application) throws SliderException {
        Class providerClass;
        Configuration conf = SliderProviderFactory.loadSliderConfiguration();
        if (application == null) {
            application = DEFAULT_CLUSTER_TYPE;
        }
        String providerKey = String.format("slider.provider.%s", application);
        if (application.contains(".")) {
            log.debug("Treating {} as a classname", (Object)application);
            String name = "classname.key";
            conf.set(name, application);
            providerKey = name;
        }
        try {
            providerClass = conf.getClass(providerKey, null, SliderProviderFactory.class);
        }
        catch (RuntimeException e) {
            throw new BadClusterStateException(e, "Failed to load provider %s: %s", application, e);
        }
        if (providerClass == null) {
            throw new BadClusterStateException(PROVIDER_NOT_FOUND, application);
        }
        try {
            SliderProviderFactory providerFactory = (SliderProviderFactory)((Object)providerClass.newInstance());
            providerFactory.setConf(conf);
            return providerFactory;
        }
        catch (Exception e) {
            Exception ex = e;
            throw new BadClusterStateException(ex, "Failed to create an instance of %s : %s", providerClass, ex);
        }
    }

    public static Configuration loadSliderConfiguration() {
        Configuration conf = new Configuration();
        conf.addResource("org/apache/slider/slider.xml");
        return conf;
    }
}

